/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class SavedDataFeaturePoolElementFix
extends DataFix {
    private static final Pattern a = Pattern.compile("\\[(\\d+)\\]");
    private static final Set<String> b = Sets.newHashSet((Object[])new String[]{"minecraft:jigsaw", "minecraft:nvi", "minecraft:pcp", "minecraft:bastionremnant", "minecraft:runtime"});
    private static final Set<String> c = Sets.newHashSet((Object[])new String[]{"minecraft:tree", "minecraft:flower", "minecraft:block_pile", "minecraft:random_patch"});

    public SavedDataFeaturePoolElementFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    public TypeRewriteRule makeRule() {
        return this.writeFixAndRead("SavedDataFeaturePoolElementFix", this.getInputSchema().getType(DataConverterTypes.G), this.getOutputSchema().getType(DataConverterTypes.G), SavedDataFeaturePoolElementFix::b);
    }

    private static <T> Dynamic<T> b(Dynamic<T> structureFeature) {
        return structureFeature.update("Children", SavedDataFeaturePoolElementFix::c);
    }

    private static <T> Dynamic<T> c(Dynamic<T> children) {
        return children.asStreamOpt().map(SavedDataFeaturePoolElementFix::a).map(arg_0 -> children.createList(arg_0)).result().orElse(children);
    }

    private static Stream<? extends Dynamic<?>> a(Stream<? extends Dynamic<?>> children) {
        return children.map(child -> {
            String string = child.get("id").asString("");
            if (!b.contains(string)) {
                return child;
            }
            OptionalDynamic optionalDynamic = child.get("pool_element");
            if (!optionalDynamic.get("element_type").asString("").equals("minecraft:feature_pool_element")) {
                return child;
            }
            return child.update("pool_element", poolElement -> poolElement.update("feature", SavedDataFeaturePoolElementFix::a));
        });
    }

    private static <T> OptionalDynamic<T> a(Dynamic<T> root, String ... pathParts) {
        if (pathParts.length == 0) {
            throw new IllegalArgumentException("Missing path");
        }
        OptionalDynamic optionalDynamic = root.get(pathParts[0]);
        for (int i2 = 1; i2 < pathParts.length; ++i2) {
            String string = pathParts[i2];
            Matcher matcher = a.matcher(string);
            if (matcher.matches()) {
                int j2 = Integer.parseInt(matcher.group(1));
                List list = optionalDynamic.asList(Function.identity());
                if (j2 >= 0 && j2 < list.size()) {
                    optionalDynamic = new OptionalDynamic(root.getOps(), DataResult.success((Object)((Object)((Dynamic)((Object)list.get(j2))))));
                    continue;
                }
                optionalDynamic = new OptionalDynamic(root.getOps(), DataResult.error(() -> "Missing id:" + j2));
                continue;
            }
            optionalDynamic = optionalDynamic.get(string);
        }
        return optionalDynamic;
    }

    @VisibleForTesting
    protected static Dynamic<?> a(Dynamic<?> feature) {
        Optional<String> optional = SavedDataFeaturePoolElementFix.a(SavedDataFeaturePoolElementFix.a(feature, "type").asString(""), SavedDataFeaturePoolElementFix.a(feature, "name").asString(""), SavedDataFeaturePoolElementFix.a(feature, "config", "state_provider", "type").asString(""), SavedDataFeaturePoolElementFix.a(feature, "config", "state_provider", "state", "Name").asString(""), SavedDataFeaturePoolElementFix.a(feature, "config", "state_provider", "entries", "[0]", "data", "Name").asString(""), SavedDataFeaturePoolElementFix.a(feature, "config", "foliage_placer", "type").asString(""), SavedDataFeaturePoolElementFix.a(feature, "config", "leaves_provider", "state", "Name").asString(""));
        if (optional.isPresent()) {
            return feature.createString(optional.get());
        }
        return feature;
    }

    /*
     * WARNING - void declaration
     */
    private static Optional<String> a(String type, String name, String stateProviderType, String stateProviderStateName, String stateProviderFirstEntryName, String foliagePlacerType, String leavesProviderStateName) {
        void string4;
        if (!type.isEmpty()) {
            String string = type;
        } else if (!name.isEmpty()) {
            if ("minecraft:normal_tree".equals(name)) {
                String string2 = "minecraft:tree";
            } else {
                String string3 = name;
            }
        } else {
            return Optional.empty();
        }
        if (c.contains(string4)) {
            if ("minecraft:random_patch".equals(string4)) {
                if ("minecraft:simple_state_provider".equals(stateProviderType)) {
                    if ("minecraft:sweet_berry_bush".equals(stateProviderStateName)) {
                        return Optional.of("minecraft:patch_berry_bush");
                    }
                    if ("minecraft:cactus".equals(stateProviderStateName)) {
                        return Optional.of("minecraft:patch_cactus");
                    }
                } else if ("minecraft:weighted_state_provider".equals(stateProviderType) && ("minecraft:grass".equals(stateProviderFirstEntryName) || "minecraft:fern".equals(stateProviderFirstEntryName))) {
                    return Optional.of("minecraft:patch_taiga_grass");
                }
            } else if ("minecraft:block_pile".equals(string4)) {
                if ("minecraft:simple_state_provider".equals(stateProviderType) || "minecraft:rotated_block_provider".equals(stateProviderType)) {
                    if ("minecraft:hay_block".equals(stateProviderStateName)) {
                        return Optional.of("minecraft:pile_hay");
                    }
                    if ("minecraft:melon".equals(stateProviderStateName)) {
                        return Optional.of("minecraft:pile_melon");
                    }
                    if ("minecraft:snow".equals(stateProviderStateName)) {
                        return Optional.of("minecraft:pile_snow");
                    }
                } else if ("minecraft:weighted_state_provider".equals(stateProviderType)) {
                    if ("minecraft:packed_ice".equals(stateProviderFirstEntryName) || "minecraft:blue_ice".equals(stateProviderFirstEntryName)) {
                        return Optional.of("minecraft:pile_ice");
                    }
                    if ("minecraft:jack_o_lantern".equals(stateProviderFirstEntryName) || "minecraft:pumpkin".equals(stateProviderFirstEntryName)) {
                        return Optional.of("minecraft:pile_pumpkin");
                    }
                }
            } else {
                if ("minecraft:flower".equals(string4)) {
                    return Optional.of("minecraft:flower_plain");
                }
                if ("minecraft:tree".equals(string4)) {
                    if ("minecraft:acacia_foliage_placer".equals(foliagePlacerType)) {
                        return Optional.of("minecraft:acacia");
                    }
                    if ("minecraft:blob_foliage_placer".equals(foliagePlacerType) && "minecraft:oak_leaves".equals(leavesProviderStateName)) {
                        return Optional.of("minecraft:oak");
                    }
                    if ("minecraft:pine_foliage_placer".equals(foliagePlacerType)) {
                        return Optional.of("minecraft:pine");
                    }
                    if ("minecraft:spruce_foliage_placer".equals(foliagePlacerType)) {
                        return Optional.of("minecraft:spruce");
                    }
                }
            }
        }
        return Optional.empty();
    }
}

