/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class WorldGenSettingsHeightAndBiomeFix
extends DataFix {
    private static final String b = "WorldGenSettingsHeightAndBiomeFix";
    public static final String a = "has_increased_height_already";

    public WorldGenSettingsHeightAndBiomeFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.M);
        OpticFinder opticFinder = type.findField("dimensions");
        Type type2 = this.getOutputSchema().getType(DataConverterTypes.M);
        Type type3 = type2.findFieldType("dimensions");
        return this.fixTypeEverywhereTyped(b, type, type2, worldGenSettingsTyped -> {
            OptionalDynamic optionalDynamic = ((Dynamic)((Object)((Object)worldGenSettingsTyped.get(DSL.remainderFinder())))).get(a);
            boolean bl = optionalDynamic.result().isEmpty();
            boolean bl2 = optionalDynamic.asBoolean(true);
            return worldGenSettingsTyped.update(DSL.remainderFinder(), worldGenSettingsDynamic -> worldGenSettingsDynamic.remove(a)).updateTyped(opticFinder, type3, dimensionsTyped -> SystemUtils.a(dimensionsTyped, type3, dimensionsDynamic -> dimensionsDynamic.update("minecraft:overworld", overworldDimensionDynamic -> overworldDimensionDynamic.update("generator", overworldGeneratorDynamic -> {
                String string = overworldGeneratorDynamic.get("type").asString("");
                if ("minecraft:noise".equals(string)) {
                    MutableBoolean mutableBoolean = new MutableBoolean();
                    overworldGeneratorDynamic = overworldGeneratorDynamic.update("biome_source", overworldBiomeSourceDynamic -> {
                        String string = overworldBiomeSourceDynamic.get("type").asString("");
                        if ("minecraft:vanilla_layered".equals(string) || bl && "minecraft:multi_noise".equals(string)) {
                            if (overworldBiomeSourceDynamic.get("large_biomes").asBoolean(false)) {
                                mutableBoolean.setTrue();
                            }
                            return overworldBiomeSourceDynamic.createMap((Map)ImmutableMap.of((Object)((Object)overworldBiomeSourceDynamic.createString("preset")), (Object)((Object)overworldBiomeSourceDynamic.createString("minecraft:overworld")), (Object)((Object)overworldBiomeSourceDynamic.createString("type")), (Object)((Object)overworldBiomeSourceDynamic.createString("minecraft:multi_noise"))));
                        }
                        return overworldBiomeSourceDynamic;
                    });
                    if (mutableBoolean.booleanValue()) {
                        return overworldGeneratorDynamic.update("settings", overworldGeneratorSettingsDynamic -> {
                            if ("minecraft:overworld".equals(overworldGeneratorSettingsDynamic.asString(""))) {
                                return overworldGeneratorSettingsDynamic.createString("minecraft:large_biomes");
                            }
                            return overworldGeneratorSettingsDynamic;
                        });
                    }
                    return overworldGeneratorDynamic;
                }
                if ("minecraft:flat".equals(string)) {
                    if (bl2) {
                        return overworldGeneratorDynamic;
                    }
                    return overworldGeneratorDynamic.update("settings", overworldGeneratorSettingsDynamic -> overworldGeneratorSettingsDynamic.update("layers", WorldGenSettingsHeightAndBiomeFix::a));
                }
                return overworldGeneratorDynamic;
            }))));
        });
    }

    private static Dynamic<?> a(Dynamic<?> dynamic) {
        Dynamic dynamic2 = dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("height")), (Object)((Object)dynamic.createInt(64)), (Object)((Object)dynamic.createString("block")), (Object)((Object)dynamic.createString("minecraft:air"))));
        return dynamic.createList(Stream.concat(Stream.of(dynamic2), dynamic.asStream()));
    }
}

