/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.ComparisonChain;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import org.slf4j.Logger;

public class MobEffect
implements Comparable<MobEffect> {
    private static final Logger f = LogUtils.getLogger();
    public static final int a = -1;
    public static final int b = 0;
    public static final int c = 255;
    public static final Codec<MobEffect> d = RecordCodecBuilder.create(instance -> instance.group((App)MobEffectList.a.fieldOf("id").forGetter(MobEffect::c), (App)net.minecraft.world.effect.MobEffect$b.a.forGetter(MobEffect::l)).apply((Applicative)instance, MobEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MobEffect> e = StreamCodec.a(MobEffectList.b, MobEffect::c, net.minecraft.world.effect.MobEffect$b.b, MobEffect::l, MobEffect::new);
    private final Holder<MobEffectList> g;
    private int h;
    private int i;
    private boolean j;
    private boolean k;
    private boolean l;
    @Nullable
    public MobEffect m;
    private final a n = new a();

    public MobEffect(Holder<MobEffectList> effect) {
        this(effect, 0, 0);
    }

    public MobEffect(Holder<MobEffectList> effect, int duration) {
        this(effect, duration, 0);
    }

    public MobEffect(Holder<MobEffectList> effect, int duration, int amplifier) {
        this(effect, duration, amplifier, false, true);
    }

    public MobEffect(Holder<MobEffectList> effect, int duration, int amplifier, boolean ambient, boolean visible) {
        this(effect, duration, amplifier, ambient, visible, visible);
    }

    public MobEffect(Holder<MobEffectList> effect, int duration, int amplifier, boolean ambient, boolean showParticles, boolean showIcon) {
        this(effect, duration, amplifier, ambient, showParticles, showIcon, null);
    }

    public MobEffect(Holder<MobEffectList> effect, int duration, int amplifier, boolean ambient, boolean showParticles, boolean showIcon, @Nullable MobEffect hiddenEffect) {
        this.g = effect;
        this.h = duration;
        this.i = MathHelper.a(amplifier, 0, 255);
        this.j = ambient;
        this.k = showParticles;
        this.l = showIcon;
        this.m = hiddenEffect;
    }

    public MobEffect(MobEffect instance) {
        this.g = instance.g;
        this.a(instance);
    }

    private MobEffect(Holder<MobEffectList> effect, b parameters) {
        this(effect, parameters.b(), parameters.a(), parameters.c(), parameters.d(), parameters.e(), parameters.f().map(parametersx -> new MobEffect(effect, (b)parametersx)).orElse(null));
    }

    private b l() {
        return new b(this.e(), this.d(), this.f(), this.g(), this.h(), Optional.ofNullable(this.m).map(MobEffect::l));
    }

    public float a(EntityLiving entity, float tickDelta) {
        return this.n.a(entity, tickDelta);
    }

    public ParticleParam a() {
        return this.g.a().a(this);
    }

    void a(MobEffect that) {
        this.h = that.h;
        this.i = that.i;
        this.j = that.j;
        this.k = that.k;
        this.l = that.l;
    }

    public boolean b(MobEffect that) {
        if (!this.g.equals(that.g)) {
            f.warn("This method should only be called for matching effects!");
        }
        boolean bl = false;
        if (that.i > this.i) {
            if (that.e(this)) {
                MobEffect mobEffectInstance = this.m;
                this.m = new MobEffect(this);
                this.m.m = mobEffectInstance;
            }
            this.i = that.i;
            this.h = that.h;
            bl = true;
        } else if (this.e(that)) {
            if (that.i == this.i) {
                this.h = that.h;
                bl = true;
            } else if (this.m == null) {
                this.m = new MobEffect(that);
            } else {
                this.m.b(that);
            }
        }
        if (!that.j && this.j || bl) {
            this.j = that.j;
            bl = true;
        }
        if (that.k != this.k) {
            this.k = that.k;
            bl = true;
        }
        if (that.l != this.l) {
            this.l = that.l;
            bl = true;
        }
        return bl;
    }

    private boolean e(MobEffect effect) {
        return !this.b() && (this.h < effect.h || effect.b());
    }

    public boolean b() {
        return this.h == -1;
    }

    public boolean a(int duration) {
        return !this.b() && this.h <= duration;
    }

    public int a(Int2IntFunction mapper) {
        if (this.b() || this.h == 0) {
            return this.h;
        }
        return mapper.applyAsInt(this.h);
    }

    public Holder<MobEffectList> c() {
        return this.g;
    }

    public int d() {
        return this.h;
    }

    public int e() {
        return this.i;
    }

    public boolean f() {
        return this.j;
    }

    public boolean g() {
        return this.k;
    }

    public boolean h() {
        return this.l;
    }

    public boolean a(EntityLiving entity, Runnable overwriteCallback) {
        if (this.m()) {
            int i2;
            int n2 = i2 = this.b() ? entity.ai : this.h;
            if (this.g.a().a(i2, this.i) && !this.g.a().a(entity, this.i)) {
                entity.e(this.g);
            }
            this.n();
            if (this.h == 0 && this.m != null) {
                this.a(this.m);
                this.m = this.m.m;
                overwriteCallback.run();
            }
        }
        this.n.b(this);
        return this.m();
    }

    private boolean m() {
        return this.b() || this.h > 0;
    }

    private int n() {
        if (this.m != null) {
            this.m.n();
        }
        this.h = this.a(duration -> duration - 1);
        return this.h;
    }

    public void a(EntityLiving entity) {
        this.g.a().b(entity, this.i);
    }

    public void a(EntityLiving entity, Entity.RemovalReason reason) {
        this.g.a().a(entity, this.i, reason);
    }

    public void a(EntityLiving entity, DamageSource source, float amount) {
        this.g.a().a(entity, this.i, source, amount);
    }

    public String i() {
        return this.g.a().d();
    }

    @Override
    public String toString() {
        String string2;
        if (this.i > 0) {
            String string = this.i() + " x " + (this.i + 1) + ", Duration: " + this.o();
        } else {
            string2 = this.i() + ", Duration: " + this.o();
        }
        if (!this.k) {
            string2 = string2 + ", Particles: false";
        }
        if (!this.l) {
            string2 = string2 + ", Show Icon: false";
        }
        return string2;
    }

    private String o() {
        if (this.b()) {
            return "infinite";
        }
        return Integer.toString(this.h);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MobEffect) {
            MobEffect mobEffectInstance = (MobEffect)object;
            return this.h == mobEffectInstance.h && this.i == mobEffectInstance.i && this.j == mobEffectInstance.j && this.k == mobEffectInstance.k && this.l == mobEffectInstance.l && this.g.equals(mobEffectInstance.g);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int i2 = this.g.hashCode();
        i2 = 31 * i2 + this.h;
        i2 = 31 * i2 + this.i;
        i2 = 31 * i2 + (this.j ? 1 : 0);
        i2 = 31 * i2 + (this.k ? 1 : 0);
        i2 = 31 * i2 + (this.l ? 1 : 0);
        return i2;
    }

    public NBTBase j() {
        return (NBTBase)d.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this).getOrThrow();
    }

    @Nullable
    public static MobEffect a(NBTTagCompound nbt) {
        return d.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt).resultOrPartial(arg_0 -> ((Logger)f).error(arg_0)).orElse(null);
    }

    @Override
    public int c(MobEffect mobEffectInstance) {
        int i2 = 32147;
        if (this.d() > 32147 && mobEffectInstance.d() > 32147 || this.f() && mobEffectInstance.f()) {
            return ComparisonChain.start().compare(Boolean.valueOf(this.f()), Boolean.valueOf(mobEffectInstance.f())).compare(this.c().a().g(), mobEffectInstance.c().a().g()).result();
        }
        return ComparisonChain.start().compareFalseFirst(this.f(), mobEffectInstance.f()).compareFalseFirst(this.b(), mobEffectInstance.b()).compare(this.d(), mobEffectInstance.d()).compare(this.c().a().g(), mobEffectInstance.c().a().g()).result();
    }

    public void b(EntityLiving entity) {
        this.g.a().c(entity, this.i);
    }

    public boolean a(Holder<MobEffectList> effect) {
        return this.g.equals(effect);
    }

    public void d(MobEffect effect) {
        this.n.a(effect.n);
    }

    public void k() {
        this.n.a(this);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.c((MobEffect)object);
    }

    static class a {
        private float a;
        private float b;

        a() {
        }

        public void a(MobEffect effect) {
            this.b = this.a = net.minecraft.world.effect.MobEffect$a.c(effect);
        }

        public void a(a fading) {
            this.a = fading.a;
            this.b = fading.b;
        }

        public void b(MobEffect effect) {
            this.b = this.a;
            int i2 = net.minecraft.world.effect.MobEffect$a.d(effect);
            if (i2 == 0) {
                this.a = 1.0f;
                return;
            }
            float f2 = net.minecraft.world.effect.MobEffect$a.c(effect);
            if (this.a != f2) {
                float g2 = 1.0f / (float)i2;
                this.a += MathHelper.a(f2 - this.a, -g2, g2);
            }
        }

        private static float c(MobEffect effect) {
            boolean bl = !effect.a(net.minecraft.world.effect.MobEffect$a.d(effect));
            return bl ? 1.0f : 0.0f;
        }

        private static int d(MobEffect effect) {
            return effect.c().a().b();
        }

        public float a(EntityLiving entity, float tickDelta) {
            if (entity.dJ()) {
                this.b = this.a;
            }
            return MathHelper.i(tickDelta, this.b, this.a);
        }
    }

    static final class b
    extends Record {
        private final int c;
        private final int d;
        private final boolean e;
        private final boolean f;
        private final boolean g;
        private final Optional<b> h;
        public static final MapCodec<b> a = MapCodec.recursive((String)"MobEffectInstance.Details", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.j.optionalFieldOf("amplifier", (Object)0).forGetter(b::a), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(b::b), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(b::c), (App)Codec.BOOL.optionalFieldOf("show_particles", (Object)true).forGetter(b::d), (App)Codec.BOOL.optionalFieldOf("show_icon").forGetter(parameters -> Optional.of(parameters.e())), (App)codec.optionalFieldOf("hidden_effect").forGetter(b::f)).apply((Applicative)instance, b::a)));
        public static final StreamCodec<ByteBuf, b> b = StreamCodec.a(packetCodec -> StreamCodec.a(ByteBufCodecs.g, b::a, ByteBufCodecs.g, b::b, ByteBufCodecs.b, b::c, ByteBufCodecs.b, b::d, ByteBufCodecs.b, b::e, packetCodec.a(ByteBufCodecs::a), b::f, b::new));

        b(int i2, int j2, boolean bl, boolean bl2, boolean bl3, Optional<b> optional) {
            this.c = i2;
            this.d = j2;
            this.e = bl;
            this.f = bl2;
            this.g = bl3;
            this.h = optional;
        }

        private static b a(int amplifier, int duration, boolean ambient, boolean showParticles, Optional<Boolean> showIcon, Optional<b> hiddenEffect) {
            return new b(amplifier, duration, ambient, showParticles, showIcon.orElse(showParticles), hiddenEffect);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "amplifier;duration;ambient;showParticles;showIcon;hiddenEffect", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "amplifier;duration;ambient;showParticles;showIcon;hiddenEffect", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "amplifier;duration;ambient;showParticles;showIcon;hiddenEffect", "c", "d", "e", "f", "g", "h"}, this, object);
        }

        public int a() {
            return this.c;
        }

        public int b() {
            return this.d;
        }

        public boolean c() {
            return this.e;
        }

        public boolean d() {
            return this.f;
        }

        public boolean e() {
            return this.g;
        }

        public Optional<b> f() {
            return this.h;
        }
    }
}

