/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ColorUtil;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityAreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final Logger d = LogUtils.getLogger();
    private static final int e = 5;
    private static final DataWatcherObject<Float> f = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Boolean> g = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<ParticleParam> h = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.l);
    private static final float i = 32.0f;
    private static final float j = 0.5f;
    private static final float k = 3.0f;
    public static final float b = 6.0f;
    public static final float c = 0.5f;
    public PotionContents l = PotionContents.a;
    private final Map<Entity, Integer> m = Maps.newHashMap();
    private int n = 600;
    public int o = 20;
    public int p = 20;
    public int q;
    public float r;
    public float s;
    @Nullable
    private EntityLiving t;
    @Nullable
    public UUID u;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> type, World world) {
        super(type, world);
        this.ag = true;
    }

    public EntityAreaEffectCloud(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.b, world);
        this.a_(x2, y2, z2);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(f, Float.valueOf(3.0f));
        builder.a(g, false);
        builder.a(h, ColorParticleOption.a(Particles.u, -1));
    }

    public void a(float radius) {
        if (!this.dO().B) {
            this.ar().a(f, Float.valueOf(MathHelper.a(radius, 0.0f, 32.0f)));
        }
    }

    @Override
    public void i_() {
        double d0 = this.dt();
        double d1 = this.dv();
        double d2 = this.dz();
        super.i_();
        this.a_(d0, d1, d2);
    }

    public float g() {
        return this.ar().a(f).floatValue();
    }

    public void a(PotionContents potionContentsComponent) {
        this.l = potionContentsComponent;
        this.t();
    }

    public void t() {
        ParticleParam particleparam = this.ao.a(h);
        if (particleparam instanceof ColorParticleOption) {
            ColorParticleOption colorparticleoption = (ColorParticleOption)particleparam;
            int i2 = this.l.equals(PotionContents.a) ? 0 : this.l.b();
            this.ao.a(h, ColorParticleOption.a(colorparticleoption.a(), ColorUtil.b.e(i2)));
        }
    }

    public void a(MobEffect effect) {
        this.a(this.l.a(effect));
    }

    public ParticleParam h() {
        return this.ar().a(h);
    }

    public void a(ParticleParam particle) {
        this.ar().a(h, particle);
    }

    protected void a(boolean waiting) {
        this.ar().a(g, waiting);
    }

    public boolean i() {
        return this.ar().a(g);
    }

    public int j() {
        return this.n;
    }

    public void a(int duration) {
        this.n = duration;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.ai >= this.o + this.n) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return;
        }
    }

    @Override
    public void l() {
        block22: {
            float f2;
            block23: {
                boolean flag1;
                boolean flag;
                block21: {
                    float f1;
                    int i2;
                    super.l();
                    flag = this.i();
                    f2 = this.g();
                    if (!this.dO().B) break block21;
                    if (flag && this.ah.h()) {
                        return;
                    }
                    ParticleParam particleparam = this.h();
                    if (flag) {
                        i2 = 2;
                        f1 = 0.2f;
                    } else {
                        i2 = MathHelper.f((float)Math.PI * f2 * f2);
                        f1 = f2;
                    }
                    for (int j2 = 0; j2 < i2; ++j2) {
                        float f22 = this.ah.i() * ((float)Math.PI * 2);
                        float f3 = MathHelper.c(this.ah.i()) * f1;
                        double d0 = this.dt() + (double)(MathHelper.b(f22) * f3);
                        double d1 = this.dv();
                        double d2 = this.dz() + (double)(MathHelper.a(f22) * f3);
                        if (particleparam.a() == Particles.u) {
                            if (flag && this.ah.h()) {
                                this.dO().b(ColorParticleOption.a(Particles.u, -1), d0, d1, d2, 0.0, 0.0, 0.0);
                                continue;
                            }
                            this.dO().b(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                            continue;
                        }
                        if (flag) {
                            this.dO().b(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                            continue;
                        }
                        this.dO().b(particleparam, d0, d1, d2, (0.5 - this.ah.j()) * 0.15, 0.01f, (0.5 - this.ah.j()) * 0.15);
                    }
                    break block22;
                }
                if (this.ai >= this.o + this.n) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
                boolean bl = flag1 = this.ai < this.o;
                if (flag != flag1) {
                    this.a(flag1);
                }
                if (flag1) {
                    return;
                }
                if (this.s != 0.0f) {
                    if ((f2 += this.s) < 0.5f) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                        return;
                    }
                    this.a(f2);
                }
                if (this.ai % 5 != 0) break block22;
                this.m.entrySet().removeIf(entry -> this.ai >= (Integer)entry.getValue());
                if (this.l.c()) break block23;
                this.m.clear();
                break block22;
            }
            ArrayList list = Lists.newArrayList();
            if (this.l.e().isPresent()) {
                for (MobEffect mobeffect : this.l.e().get().a().a()) {
                    list.add(new MobEffect(mobeffect.c(), mobeffect.a(k2 -> k2 / 4), mobeffect.e(), mobeffect.f(), mobeffect.g()));
                }
            }
            list.addAll(this.l.d());
            List<EntityLiving> list1 = this.dO().a(EntityLiving.class, this.cK());
            if (list1.isEmpty()) break block22;
            Iterator<EntityLiving> iterator1 = list1.iterator();
            ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
            while (iterator1.hasNext()) {
                double d4;
                double d3;
                double d5;
                EntityLiving entityliving = iterator1.next();
                if (this.m.containsKey(entityliving) || !entityliving.fC()) continue;
                Stream stream = list.stream();
                Objects.requireNonNull(entityliving);
                if (stream.noneMatch(entityliving::c) || !((d5 = (d3 = entityliving.dt() - this.dt()) * d3 + (d4 = entityliving.dz() - this.dz()) * d4) <= (double)(f2 * f2))) continue;
                entities.add((LivingEntity)entityliving.getBukkitEntity());
            }
            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
            if (!event.isCancelled()) {
                for (LivingEntity entity : event.getAffectedEntities()) {
                    if (!(entity instanceof CraftLivingEntity)) continue;
                    EntityLiving entityliving = ((CraftLivingEntity)entity).getHandle();
                    this.m.put(entityliving, this.ai + this.p);
                    for (MobEffect mobeffect1 : list) {
                        if (mobeffect1.c().a().a()) {
                            mobeffect1.c().a().a(this, this.q(), entityliving, mobeffect1.e(), 0.5);
                            continue;
                        }
                        entityliving.addEffect(new MobEffect(mobeffect1), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                    }
                    if (this.r != 0.0f) {
                        if ((f2 += this.r) < 0.5f) {
                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                            return;
                        }
                        this.a(f2);
                    }
                    if (this.q == 0) continue;
                    this.n += this.q;
                    if (this.n > 0) continue;
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
            }
        }
    }

    public float k() {
        return this.r;
    }

    public void b(float radiusOnUse) {
        this.r = radiusOnUse;
    }

    public float m() {
        return this.s;
    }

    public void c(float radiusGrowth) {
        this.s = radiusGrowth;
    }

    public int o() {
        return this.q;
    }

    public void b(int durationOnUse) {
        this.q = durationOnUse;
    }

    public int p() {
        return this.o;
    }

    public void c(int waitTime) {
        this.o = waitTime;
    }

    public void a(@Nullable EntityLiving owner) {
        this.t = owner;
        this.u = owner == null ? null : owner.cz();
    }

    @Nullable
    public EntityLiving q() {
        Entity entity;
        if (this.t == null && this.u != null && this.dO() instanceof WorldServer && (entity = ((WorldServer)this.dO()).a(this.u)) instanceof EntityLiving) {
            this.t = (EntityLiving)entity;
        }
        return this.t;
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.ai = nbt.h("Age");
        this.n = nbt.h("Duration");
        this.o = nbt.h("WaitTime");
        this.p = nbt.h("ReapplicationDelay");
        this.q = nbt.h("DurationOnUse");
        this.r = nbt.j("RadiusOnUse");
        this.s = nbt.j("RadiusPerTick");
        this.a(nbt.j("Radius"));
        if (nbt.b("Owner")) {
            this.u = nbt.a("Owner");
        }
        RegistryOps<NBTBase> registryops = this.dQ().a(DynamicOpsNBT.a);
        if (nbt.b("Particle", 10)) {
            Particles.bf.parse(registryops, (Object)nbt.c("Particle")).resultOrPartial(s2 -> d.warn("Failed to parse area effect cloud particle options: '{}'", s2)).ifPresent(this::a);
        }
        if (nbt.e("potion_contents")) {
            PotionContents.b.parse(registryops, (Object)nbt.c("potion_contents")).resultOrPartial(s2 -> d.warn("Failed to parse area effect cloud potions: '{}'", s2)).ifPresent(this::a);
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a("Age", this.ai);
        nbt.a("Duration", this.n);
        nbt.a("WaitTime", this.o);
        nbt.a("ReapplicationDelay", this.p);
        nbt.a("DurationOnUse", this.q);
        nbt.a("RadiusOnUse", this.r);
        nbt.a("RadiusPerTick", this.s);
        nbt.a("Radius", this.g());
        RegistryOps<NBTBase> registryops = this.dQ().a(DynamicOpsNBT.a);
        nbt.a("Particle", (NBTBase)Particles.bf.encodeStart(registryops, (Object)this.h()).getOrThrow());
        if (this.u != null) {
            nbt.a("Owner", this.u);
        }
        if (!this.l.equals(PotionContents.a)) {
            NBTBase nbtbase = (NBTBase)PotionContents.b.encodeStart(registryops, (Object)this.l).getOrThrow();
            nbt.a("potion_contents", nbtbase);
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (f.equals(data)) {
            this.i_();
        }
        super.a(data);
    }

    @Override
    public EnumPistonReaction j_() {
        return EnumPistonReaction.d;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return EntitySize.b(this.g() * 2.0f, 0.5f);
    }
}

