/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import io.papermc.paper.event.entity.TameableDeathMessageEvent;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Tameable;
import org.bukkit.event.entity.EntityTeleportEvent;

public abstract class EntityTameableAnimal
extends EntityAnimal
implements OwnableEntity {
    public static final int cc = 144;
    private static final int cg = 2;
    private static final int ch = 3;
    private static final int ci = 1;
    protected static final DataWatcherObject<Byte> cd = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Optional<UUID>> ce = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.r);
    private boolean cj;

    protected EntityTameableAnimal(EntityTypes<? extends EntityTameableAnimal> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cd, (byte)0);
        builder.a(ce, Optional.empty());
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.aa_() != null) {
            nbt.a("Owner", this.aa_());
        }
        nbt.a("Sitting", this.cj);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        UUID uuid;
        super.a(nbt);
        if (nbt.b("Owner")) {
            uuid = nbt.a("Owner");
        } else {
            String s2 = nbt.l("Owner");
            uuid = NameReferencingFileConverter.a(this.cO(), s2);
        }
        if (uuid != null) {
            try {
                this.b(uuid);
                this.b(true, false);
            }
            catch (Throwable throwable) {
                this.b(false, true);
            }
        }
        this.cj = nbt.q("Sitting");
        this.setInSittingPose(this.cj, false);
    }

    @Override
    public boolean y() {
        return true;
    }

    @Override
    public boolean a(Entity leashHolder, float distance) {
        if (this.x()) {
            if (distance > 10.0f) {
                this.a(true, true);
            }
            return false;
        }
        return super.a(leashHolder, distance);
    }

    protected void x(boolean positive) {
        ParticleType particletype = Particles.Q;
        if (!positive) {
            particletype = Particles.ae;
        }
        for (int i2 = 0; i2 < 7; ++i2) {
            double d0 = this.ah.k() * 0.02;
            double d1 = this.ah.k() * 0.02;
            double d2 = this.ah.k() * 0.02;
            this.dO().a(particletype, this.d(1.0), this.dw() + 0.5, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 7) {
            this.x(true);
        } else if (status == 6) {
            this.x(false);
        } else {
            super.b(status);
        }
    }

    public boolean s() {
        return (this.ao.a(cd) & 4) != 0;
    }

    public void b(boolean tamed, boolean updateAttributes) {
        byte b0 = this.ao.a(cd);
        if (tamed) {
            this.ao.a(cd, (byte)(b0 | 4));
        } else {
            this.ao.a(cd, (byte)(b0 & 0xFFFFFFFB));
        }
        if (updateAttributes) {
            this.t();
        }
    }

    protected void t() {
    }

    public boolean x() {
        return (this.ao.a(cd) & 1) != 0;
    }

    public void y(boolean inSittingPose) {
        this.setInSittingPose(inSittingPose, true);
    }

    public void setInSittingPose(boolean inSittingPose, boolean callEvent) {
        if (callEvent && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), inSittingPose).callEvent()) {
            return;
        }
        byte b0 = this.ao.a(cd);
        if (inSittingPose) {
            this.ao.a(cd, (byte)(b0 | 1));
        } else {
            this.ao.a(cd, (byte)(b0 & 0xFFFFFFFE));
        }
    }

    @Override
    @Nullable
    public UUID aa_() {
        return this.ao.a(ce).orElse(null);
    }

    public void b(@Nullable UUID uuid) {
        this.ao.a(ce, Optional.ofNullable(uuid));
    }

    public void a(EntityHuman player) {
        this.b(true, true);
        this.b(player.cz());
        if (player instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)player;
            CriterionTriggers.y.a(entityplayer, this);
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return this.j(target) ? false : super.c(target);
    }

    public boolean j(EntityLiving entity) {
        return entity == this.T_();
    }

    public boolean a(EntityLiving target, EntityLiving owner) {
        return true;
    }

    @Override
    public ScoreboardTeam ck() {
        EntityLiving entityliving;
        if (this.s() && (entityliving = this.T_()) != null) {
            return entityliving.ck();
        }
        return super.ck();
    }

    @Override
    public boolean s(Entity other) {
        if (this.s()) {
            EntityLiving entityliving = this.T_();
            if (other == entityliving) {
                return true;
            }
            if (entityliving != null) {
                return entityliving.s(other);
            }
        }
        return super.s(other);
    }

    @Override
    public void a(DamageSource damageSource) {
        TameableDeathMessageEvent event;
        if (!this.dO().B && this.dO().ab().b(GameRules.n) && this.T_() instanceof EntityPlayer && (event = new TameableDeathMessageEvent((Tameable)this.getBukkitEntity(), PaperAdventure.asAdventure(this.eL().a()))).callEvent()) {
            this.T_().a(PaperAdventure.asVanilla(event.deathMessage()));
        }
        super.a(damageSource);
    }

    public boolean gk() {
        return this.cj;
    }

    public void z(boolean sitting) {
        this.cj = sitting;
    }

    public void gl() {
        EntityLiving entityliving = this.T_();
        if (entityliving != null) {
            this.h(entityliving.do());
        }
    }

    public boolean gm() {
        EntityLiving entityliving = this.T_();
        return entityliving != null && this.g((Entity)this.T_()) >= 144.0;
    }

    private void h(BlockPosition pos) {
        for (int i2 = 0; i2 < 10; ++i2) {
            int j2 = this.ah.a(-3, 3);
            int k2 = this.ah.a(-3, 3);
            if (Math.abs(j2) < 2 && Math.abs(k2) < 2) continue;
            int l2 = this.ah.a(-1, 1);
            if (!this.a(pos.u() + j2, pos.v() + l2, pos.w() + k2)) continue;
            return;
        }
    }

    private boolean a(int x2, int y2, int z2) {
        if (!this.i(new BlockPosition(x2, y2, z2))) {
            return false;
        }
        EntityTeleportEvent event = CraftEventFactory.callEntityTeleportEvent(this, (double)x2 + 0.5, y2, (double)z2 + 0.5);
        if (event.isCancelled() || event.getTo() == null) {
            return false;
        }
        Location to = event.getTo();
        this.b(to.getX(), to.getY(), to.getZ(), to.getYaw(), to.getPitch());
        this.bV.n();
        return true;
    }

    private boolean i(BlockPosition pos) {
        PathType pathtype = PathfinderNormal.b(this, pos);
        if (pathtype != PathType.c) {
            return false;
        }
        IBlockData iblockdata = this.dO().a_(pos.e());
        if (!this.go() && iblockdata.b() instanceof BlockLeaves) {
            return false;
        }
        BlockPosition blockposition1 = pos.b(this.do());
        return this.dO().a((Entity)this, this.cK().a(blockposition1));
    }

    public final boolean gn() {
        return this.gk() || this.bS() || this.O_() || this.T_() != null && this.T_().R_();
    }

    protected boolean go() {
        return false;
    }

    public class a
    extends PathfinderGoalPanic {
        public a(double d0, TagKey tagkey) {
            super((EntityCreature)EntityTameableAnimal.this, d0, tagkey);
        }

        public a(double d0) {
            super(EntityTameableAnimal.this, d0);
        }

        @Override
        public void a() {
            if (!EntityTameableAnimal.this.gn() && EntityTameableAnimal.this.gm()) {
                EntityTameableAnimal.this.gl();
            }
            super.a();
        }
    }
}

