/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class TemptingSensor
extends Sensor<EntityCreature> {
    public static final int a = 10;
    private static final PathfinderTargetCondition c = PathfinderTargetCondition.b().a(10.0).d();
    private final Predicate<ItemStack> d;

    public TemptingSensor(Predicate<ItemStack> predicate) {
        this.d = predicate;
    }

    @Override
    protected void a(WorldServer world, EntityCreature entity) {
        BehaviorController<?> behaviorcontroller = entity.dT();
        Stream<EntityPlayer> stream = world.x().stream().filter(IEntitySelector.f).filter(entityplayer -> c.a(entity, (EntityLiving)entityplayer)).filter(entityplayer -> entity.a((Entity)entityplayer, 10.0)).filter(this::a).filter(entityplayer -> !entity.x((Entity)entityplayer));
        Objects.requireNonNull(entity);
        List list = stream.sorted(Comparator.comparingDouble(entity::g)).collect(Collectors.toList());
        if (!list.isEmpty()) {
            EntityHuman entityhuman = (EntityHuman)list.get(0);
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entity, entityhuman, EntityTargetEvent.TargetReason.TEMPT);
            if (event.isCancelled()) {
                return;
            }
            if (event.getTarget() instanceof HumanEntity) {
                behaviorcontroller.a(MemoryModuleType.O, ((CraftHumanEntity)event.getTarget()).getHandle());
            } else {
                behaviorcontroller.b(MemoryModuleType.O);
            }
        } else {
            behaviorcontroller.b(MemoryModuleType.O);
        }
    }

    private boolean a(EntityHuman player) {
        return this.a(player.eT()) || this.a(player.eU());
    }

    private boolean a(ItemStack stack) {
        return this.d.test(stack);
    }

    @Override
    public Set<MemoryModuleType<?>> a() {
        return ImmutableSet.of(MemoryModuleType.O);
    }
}

