/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityFox
extends EntityAnimal
implements VariantHolder<Type> {
    private static final DataWatcherObject<Integer> cg = DataWatcher.a(EntityFox.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> ch = DataWatcher.a(EntityFox.class, DataWatcherRegistry.a);
    private static final int ci = 1;
    public static final int cc = 4;
    public static final int cd = 8;
    public static final int ce = 16;
    private static final int cj = 32;
    private static final int ck = 64;
    private static final int cl = 128;
    public static final DataWatcherObject<Optional<UUID>> cm = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    public static final DataWatcherObject<Optional<UUID>> cn = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    static final Predicate<EntityItem> co = entityitem -> !entityitem.y() && entityitem.bE();
    private static final Predicate<Entity> cp = entity -> {
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        return entityliving.ek() != null && entityliving.el() < entityliving.ai + 600;
    };
    static final Predicate<Entity> cq = entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit;
    private static final Predicate<Entity> cr = entity -> !entity.bZ() && IEntitySelector.e.test((Entity)entity);
    private static final int cs = 600;
    private static final EntitySize ct = EntityTypes.Q.n().a(0.5f).b(0.2975f);
    private PathfinderGoal cu;
    private PathfinderGoal cv;
    private PathfinderGoal cw;
    private float cx;
    private float cy;
    float cz;
    float cA;
    private int cB;

    public EntityFox(EntityTypes<? extends EntityFox> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.bS = new k();
        this.bT = new m();
        this.a(PathType.p, 0.0f);
        this.a(PathType.q, 0.0f);
        this.a_(true);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cm, Optional.empty());
        builder.a(cn, Optional.empty());
        builder.a(cg, 0);
        builder.a(ch, (byte)0);
    }

    @Override
    protected void B() {
        this.cu = new PathfinderGoalNearestAttackableTarget<EntityAnimal>(this, EntityAnimal.class, 10, false, false, entityliving -> entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit);
        this.cv = new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.cc);
        this.cw = new PathfinderGoalNearestAttackableTarget<EntityFish>(this, EntityFish.class, 20, false, false, entityliving -> entityliving instanceof EntityFishSchool);
        this.bW.a(0, new g());
        this.bW.a(0, new ClimbOnTopOfPowderSnowGoal(this, this.dO()));
        this.bW.a(1, new b());
        this.bW.a(2, new n(2.2));
        this.bW.a(3, new e(this, this, 1.0));
        this.bW.a(4, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 16.0f, 1.6, 1.4, entityliving -> cr.test((Entity)entityliving) && !this.c(entityliving.cz()) && !this.gw()));
        this.bW.a(4, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 8.0f, 1.6, 1.4, entityliving -> !((EntityWolf)entityliving).s() && !this.gw()));
        this.bW.a(4, new PathfinderGoalAvoidTarget<EntityPolarBear>(this, EntityPolarBear.class, 8.0f, 1.6, 1.4, entityliving -> !this.gw()));
        this.bW.a(5, new u());
        this.bW.a(6, new o());
        this.bW.a(6, new s(1.25));
        this.bW.a(7, new l((double)1.2f, true));
        this.bW.a(7, new t());
        this.bW.a(8, new h(this, this, this, 1.25));
        this.bW.a(9, new q(32, 200));
        this.bW.a(10, new f((double)1.2f, 12, 1));
        this.bW.a(10, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bW.a(11, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bW.a(11, new p());
        this.bW.a(12, new j(this, EntityHuman.class, 24.0f));
        this.bW.a(13, new r());
        this.bX.a(3, new a(EntityLiving.class, false, false, entityliving -> cp.test((Entity)entityliving) && !this.c(entityliving.cz())));
    }

    @Override
    public SoundEffect d(ItemStack stack) {
        return SoundEffects.jj;
    }

    @Override
    public void m_() {
        if (!this.dO().B && this.bE() && this.db()) {
            EntityLiving entityliving;
            ++this.cB;
            ItemStack itemstack = this.a(EnumItemSlot.a);
            if (this.n(itemstack)) {
                if (this.cB > 600) {
                    ItemStack itemstack1 = itemstack.a(this.dO(), (EntityLiving)this);
                    if (!itemstack1.e()) {
                        this.a(EnumItemSlot.a, itemstack1);
                    }
                    this.cB = 0;
                } else if (this.cB > 560 && this.ah.i() < 0.1f) {
                    this.a(this.d(itemstack), 1.0f, 1.0f);
                    this.dO().a((Entity)this, (byte)45);
                }
            }
            if ((entityliving = this.p()) == null || !entityliving.bE()) {
                this.z(false);
                this.A(false);
            }
        }
        if (this.fH() || this.fc()) {
            this.bn = false;
            this.bo = 0.0f;
            this.bq = 0.0f;
        }
        super.m_();
        if (this.gw() && this.ah.i() < 0.05f) {
            this.a(SoundEffects.jf, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean fc() {
        return this.ex();
    }

    private boolean n(ItemStack stack) {
        return stack.b(DataComponents.v) && this.p() == null && this.aF() && !this.fH();
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        if (random.i() < 0.2f) {
            float f2 = random.i();
            ItemStack itemstack = f2 < 0.05f ? new ItemStack(Items.oA) : (f2 < 0.2f ? new ItemStack(Items.qR) : (f2 < 0.4f ? (random.h() ? new ItemStack(Items.uD) : new ItemStack(Items.uE)) : (f2 < 0.6f ? new ItemStack(Items.pw) : (f2 < 0.8f ? new ItemStack(Items.qD) : new ItemStack(Items.pt)))));
            this.a(EnumItemSlot.a, itemstack);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 45) {
            ItemStack itemstack = this.a(EnumItemSlot.a);
            if (!itemstack.e()) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    Vec3D vec3d = new Vec3D(((double)this.ah.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).a(-this.dG() * ((float)Math.PI / 180)).b(-this.dE() * ((float)Math.PI / 180));
                    this.dO().a(new ParticleParamItem(Particles.S, itemstack), this.dt() + this.bM().c / 2.0, this.dv(), this.dz() + this.bM().e / 2.0, vec3d.c, vec3d.d + 0.05, vec3d.e);
                }
            }
        } else {
            super.b(status);
        }
    }

    public static AttributeProvider.Builder s() {
        return EntityInsentient.C().a(GenericAttributes.v, 0.3f).a(GenericAttributes.s, 10.0).a(GenericAttributes.m, 32.0).a(GenericAttributes.c, 2.0).a(GenericAttributes.x, 5.0);
    }

    @Nullable
    public EntityFox b(WorldServer world, EntityAgeable entity) {
        EntityFox entityfox = EntityTypes.Q.a(world);
        if (entityfox != null) {
            entityfox.a(this.ah.h() ? this.t() : ((EntityFox)entity).t());
        }
        return entityfox;
    }

    public static boolean c(EntityTypes<EntityFox> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.e()).a(TagsBlock.cf) && EntityFox.a(world, pos);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData) {
        Holder<BiomeBase> holder = world.t(this.do());
        Type entityfox_type = Type.a(holder);
        boolean flag = false;
        if (entityData instanceof i) {
            i entityfox_i = (i)entityData;
            entityfox_type = entityfox_i.a;
            if (entityfox_i.a() >= 2) {
                flag = true;
            }
        } else {
            entityData = new i(entityfox_type);
        }
        this.a(entityfox_type);
        if (flag) {
            this.c_(-24000);
        }
        if (world instanceof WorldServer) {
            this.gu();
        }
        this.a(world.E_(), difficulty);
        return super.a(world, difficulty, spawnReason, entityData);
    }

    private void gu() {
        if (this.t() == Type.a) {
            this.bX.a(4, this.cu);
            this.bX.a(4, this.cv);
            this.bX.a(6, this.cw);
        } else {
            this.bX.a(4, this.cw);
            this.bX.a(6, this.cu);
            this.bX.a(6, this.cv);
        }
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (this.o(stack)) {
            this.a(this.d(stack), 1.0f, 1.0f);
        }
        super.a(player, hand, stack);
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.o_() ? ct : super.e(pose);
    }

    public Type t() {
        return Type.a(this.ao.a(cg));
    }

    @Override
    public void a(Type variant) {
        this.ao.a(cg, variant.a());
    }

    List<UUID> gv() {
        ArrayList list = Lists.newArrayList();
        list.add(this.ao.a(cm).orElse(null));
        list.add(this.ao.a(cn).orElse(null));
        return list;
    }

    void b(@Nullable UUID uuid) {
        if (this.ao.a(cm).isPresent()) {
            this.ao.a(cn, Optional.ofNullable(uuid));
        } else {
            this.ao.a(cm, Optional.ofNullable(uuid));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        List<UUID> list = this.gv();
        NBTTagList nbttaglist = new NBTTagList();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            nbttaglist.add(GameProfileSerializer.a(uuid));
        }
        nbt.a("Trusted", nbttaglist);
        nbt.a("Sleeping", this.fH());
        nbt.a("Type", this.t().c());
        nbt.a("Sitting", this.x());
        nbt.a("Crouching", this.cb());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        NBTTagList nbttaglist = nbt.c("Trusted", 11);
        for (NBTBase nbtbase : nbttaglist) {
            this.b(GameProfileSerializer.a(nbtbase));
        }
        this.D(nbt.q("Sleeping"));
        this.a(Type.a(nbt.l("Type")));
        this.setSitting(nbt.q("Sitting"), false);
        this.z(nbt.q("Crouching"));
        if (this.dO() instanceof WorldServer) {
            this.gu();
        }
    }

    public boolean x() {
        return this.t(1);
    }

    public void x(boolean sitting) {
        this.setSitting(sitting, true);
    }

    public void setSitting(boolean sitting, boolean fireEvent) {
        if (fireEvent && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), sitting).callEvent()) {
            return;
        }
        this.d(1, sitting);
    }

    public boolean gk() {
        return this.t(64);
    }

    public void B(boolean walking) {
        this.d(64, walking);
    }

    public boolean gw() {
        return this.t(128);
    }

    public void C(boolean aggressive) {
        this.d(128, aggressive);
    }

    @Override
    public boolean fH() {
        return this.t(32);
    }

    public void D(boolean sleeping) {
        this.d(32, sleeping);
    }

    private void d(int mask, boolean value) {
        if (value) {
            this.ao.a(ch, (byte)(this.ao.a(ch) | mask));
        } else {
            this.ao.a(ch, (byte)(this.ao.a(ch) & ~mask));
        }
    }

    private boolean t(int bitmask) {
        return (this.ao.a(ch) & bitmask) != 0;
    }

    @Override
    public boolean f(ItemStack stack) {
        EnumItemSlot enumitemslot = this.h(stack);
        return !this.a(enumitemslot).e() ? false : enumitemslot == EnumItemSlot.a && super.f(stack);
    }

    @Override
    public boolean j(ItemStack stack) {
        ItemStack itemstack1 = this.a(EnumItemSlot.a);
        return itemstack1.e() || this.cB > 0 && stack.b(DataComponents.v) && !itemstack1.b(DataComponents.v);
    }

    private void p(ItemStack stack) {
        if (!stack.e() && !this.dO().B) {
            EntityItem entityitem = new EntityItem(this.dO(), this.dt() + this.bM().c, this.dv() + 1.0, this.dz() + this.bM().e, stack);
            entityitem.b(40);
            entityitem.b((Entity)this);
            this.a(SoundEffects.jo, 1.0f, 1.0f);
            this.spawnAtLocation(entityitem);
        }
    }

    private void q(ItemStack stack) {
        EntityItem entityitem = new EntityItem(this.dO(), this.dt(), this.dv(), this.dz(), stack);
        this.spawnAtLocation(entityitem);
    }

    @Override
    protected void b(EntityItem item) {
        ItemStack itemstack = item.p();
        if (!CraftEventFactory.callEntityPickupItemEvent(this, item, itemstack.H() - 1, !this.j(itemstack)).isCancelled()) {
            itemstack = item.p();
            int i2 = itemstack.H();
            if (i2 > 1) {
                this.q(itemstack.a(i2 - 1));
            }
            this.p(this.a(EnumItemSlot.a));
            this.a(item);
            this.a(EnumItemSlot.a, itemstack.a(1));
            this.e(EnumItemSlot.a);
            this.a((Entity)item, itemstack.H());
            item.discard(EntityRemoveEvent.Cause.PICKUP);
            this.cB = 0;
        }
    }

    @Override
    public void l() {
        super.l();
        if (this.db()) {
            boolean flag = this.bf();
            if (flag || this.p() != null || this.dO().ac()) {
                this.gx();
            }
            if (flag || this.fH()) {
                this.x(false);
            }
            if (this.gk() && this.dO().z.i() < 0.2f) {
                BlockPosition blockposition = this.do();
                IBlockData iblockdata = this.dO().a_(blockposition);
                this.dO().c(2001, blockposition, Block.i(iblockdata));
            }
        }
        this.cy = this.cx;
        this.cx = this.go() ? (this.cx += (1.0f - this.cx) * 0.4f) : (this.cx += (0.0f - this.cx) * 0.4f);
        this.cA = this.cz;
        if (this.cb()) {
            this.cz += 0.2f;
            if (this.cz > 3.0f) {
                this.cz = 3.0f;
            }
        } else {
            this.cz = 0.0f;
        }
    }

    @Override
    public boolean o(ItemStack stack) {
        return stack.a(TagsItem.Z);
    }

    @Override
    protected void a(EntityHuman player, EntityInsentient child) {
        ((EntityFox)child).b(player.cz());
    }

    public boolean gl() {
        return this.t(16);
    }

    public void y(boolean chasing) {
        this.d(16, chasing);
    }

    public boolean gm() {
        return this.bn;
    }

    public boolean gn() {
        return this.cz == 3.0f;
    }

    public void z(boolean crouching) {
        this.d(4, crouching);
    }

    @Override
    public boolean cb() {
        return this.t(4);
    }

    public void A(boolean rollingHead) {
        this.d(8, rollingHead);
    }

    public boolean go() {
        return this.t(8);
    }

    public float H(float tickDelta) {
        return MathHelper.i(tickDelta, this.cy, this.cx) * 0.11f * (float)Math.PI;
    }

    public float I(float tickDelta) {
        return MathHelper.i(tickDelta, this.cA, this.cz);
    }

    @Override
    public void h(@Nullable EntityLiving target) {
        if (this.gw() && target == null) {
            this.C(false);
        }
        super.h(target);
    }

    void gx() {
        this.D(false);
    }

    void gy() {
        this.A(false);
        this.z(false);
        this.x(false);
        this.D(false);
        this.C(false);
        this.B(false);
    }

    boolean gz() {
        return !this.fH() && !this.x() && !this.gk();
    }

    @Override
    public void S() {
        SoundEffect soundeffect = this.v();
        if (soundeffect == SoundEffects.jl) {
            this.a(soundeffect, 2.0f, this.fb());
        } else {
            super.S();
        }
    }

    @Override
    @Nullable
    protected SoundEffect v() {
        List<Entity> list;
        if (this.fH()) {
            return SoundEffects.jm;
        }
        if (!this.dO().R() && this.ah.i() < 0.1f && (list = this.dO().a(EntityHuman.class, this.cK().c(16.0, 16.0, 16.0), IEntitySelector.f)).isEmpty()) {
            return SoundEffects.jl;
        }
        return SoundEffects.jg;
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.jk;
    }

    @Override
    @Nullable
    public SoundEffect n_() {
        return SoundEffects.ji;
    }

    boolean c(UUID uuid) {
        return this.gv().contains(uuid);
    }

    @Override
    protected boolean shouldSkipLoot(EnumItemSlot slot) {
        return slot == EnumItemSlot.a;
    }

    @Override
    protected EntityDeathEvent dropAllDeathLoot(WorldServer world, DamageSource damageSource) {
        EntityDeathEvent deathEvent;
        ItemStack itemstack = this.a(EnumItemSlot.a);
        boolean releaseMouth = false;
        if (!itemstack.e() && this.dO().ab().b(GameRules.f)) {
            this.b(itemstack);
            releaseMouth = true;
        }
        if ((deathEvent = super.dropAllDeathLoot(world, damageSource)) == null || deathEvent.isCancelled()) {
            return deathEvent;
        }
        if (releaseMouth) {
            this.a(EnumItemSlot.a, ItemStack.l);
        }
        return deathEvent;
    }

    public static boolean a(EntityFox fox, EntityLiving chasedEntity) {
        double d0 = chasedEntity.dz() - fox.dz();
        double d1 = chasedEntity.dt() - fox.dt();
        double d2 = d0 / d1;
        boolean flag = true;
        for (int i2 = 0; i2 < 6; ++i2) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)i2 / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)i2 / 6.0f) : d3 / d2;
            for (int j2 = 1; j2 < 4; ++j2) {
                if (fox.dO().a_(BlockPosition.a(fox.dt() + d4, fox.dv() + (double)j2, fox.dz() + d3)).r()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vec3D cM() {
        return new Vec3D(0.0, 0.55f * this.cL(), this.dj() * 0.4f);
    }

    public class k
    extends ControllerLook {
        public k() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (!EntityFox.this.fH()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityFox.this.gl() && !EntityFox.this.cb() && !EntityFox.this.go() && !EntityFox.this.gk();
        }
    }

    private class m
    extends ControllerMove {
        public m() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (EntityFox.this.gz()) {
                super.a();
            }
        }
    }

    private class g
    extends PathfinderGoalFloat {
        public g() {
            super(EntityFox.this);
        }

        @Override
        public void d() {
            super.d();
            EntityFox.this.gy();
        }

        @Override
        public boolean b() {
            return EntityFox.this.bf() && EntityFox.this.b(TagsFluid.a) > 0.25 || EntityFox.this.bt();
        }
    }

    private class b
    extends PathfinderGoal {
        int a;

        public b() {
            this.a(EnumSet.of(PathfinderGoal.Type.b, PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return EntityFox.this.gk();
        }

        @Override
        public boolean c() {
            return this.b() && this.a > 0;
        }

        @Override
        public void d() {
            this.a = this.a(40);
        }

        @Override
        public void e() {
            EntityFox.this.B(false);
        }

        @Override
        public void a() {
            --this.a;
        }
    }

    private class n
    extends PathfinderGoalPanic {
        public n(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public boolean h() {
            return !EntityFox.this.gw() && super.h();
        }
    }

    private class e
    extends PathfinderGoalBreed {
        public e(EntityFox entityFox, EntityFox chance, double fox) {
            super(chance, fox);
        }

        @Override
        public void d() {
            ((EntityFox)this.a).gy();
            ((EntityFox)this.c).gy();
            super.d();
        }

        @Override
        protected void g() {
            WorldServer worldserver = (WorldServer)this.b;
            EntityFox entityfox = (EntityFox)this.a.a(worldserver, (EntityAgeable)this.c);
            if (entityfox != null) {
                EntityPlayer entityplayer = this.a.gr();
                EntityPlayer entityplayer1 = this.c.gr();
                EntityPlayer entityplayer2 = entityplayer;
                if (entityplayer != null) {
                    entityfox.b(entityplayer.cz());
                } else {
                    entityplayer2 = entityplayer1;
                }
                if (entityplayer1 != null && entityplayer != entityplayer1) {
                    entityfox.b(entityplayer1.cz());
                }
                entityfox.c_(-24000);
                entityfox.b(this.a.dt(), this.a.dv(), this.a.dz(), 0.0f, 0.0f);
                int experience = this.a.dR().a(7) + 1;
                EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityfox, this.a, this.c, entityplayer, this.a.breedItem, experience);
                if (entityBreedEvent.isCancelled()) {
                    return;
                }
                experience = entityBreedEvent.getExperience();
                if (entityplayer2 != null) {
                    entityplayer2.a(StatisticList.P);
                    CriterionTriggers.p.a(entityplayer2, this.a, this.c, entityfox);
                }
                this.a.c_(6000);
                this.c.c_(6000);
                this.a.gt();
                this.c.gt();
                worldserver.addFreshEntityWithPassengers(entityfox, CreatureSpawnEvent.SpawnReason.BREEDING);
                this.b.a((Entity)this.a, (byte)18);
                if (this.b.ab().b(GameRules.f) && experience > 0) {
                    this.b.b(new EntityExperienceOrb(this.b, this.a.dt(), this.a.dv(), this.a.dz(), experience, ExperienceOrb.SpawnReason.BREED, entityplayer, entityfox));
                }
            }
        }
    }

    private class u
    extends PathfinderGoal {
        public u() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            if (EntityFox.this.fH()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.p();
            return entityliving != null && entityliving.bE() && cq.test(entityliving) && EntityFox.this.g((Entity)entityliving) > 36.0 && !EntityFox.this.cb() && !EntityFox.this.go() && !EntityFox.this.bn;
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.B(false);
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityFox.this.p();
            if (entityliving != null && EntityFox.a(EntityFox.this, entityliving)) {
                EntityFox.this.A(true);
                EntityFox.this.z(true);
                EntityFox.this.N().n();
                EntityFox.this.I().a(entityliving, (float)EntityFox.this.ae(), (float)EntityFox.this.ac());
            } else {
                EntityFox.this.A(false);
                EntityFox.this.z(false);
            }
        }

        @Override
        public void a() {
            EntityLiving entityliving = EntityFox.this.p();
            if (entityliving != null) {
                EntityFox.this.I().a(entityliving, (float)EntityFox.this.ae(), (float)EntityFox.this.ac());
                if (EntityFox.this.g((Entity)entityliving) <= 36.0) {
                    EntityFox.this.A(true);
                    EntityFox.this.z(true);
                    EntityFox.this.N().n();
                } else {
                    EntityFox.this.N().a((Entity)entityliving, 1.5);
                }
            }
        }
    }

    public class o
    extends PathfinderGoalWaterJumpAbstract {
        @Override
        public boolean b() {
            if (!EntityFox.this.gn()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.p();
            if (entityliving != null && entityliving.bE()) {
                if (entityliving.cI() != entityliving.cH()) {
                    return false;
                }
                boolean flag = EntityFox.a(EntityFox.this, entityliving);
                if (!flag) {
                    EntityFox.this.N().a((Entity)entityliving, 0);
                    EntityFox.this.z(false);
                    EntityFox.this.A(false);
                }
                return flag;
            }
            return false;
        }

        @Override
        public boolean c() {
            EntityLiving entityliving = EntityFox.this.p();
            if (entityliving != null && entityliving.bE()) {
                double d0 = EntityFox.this.dr().d;
                return (d0 * d0 >= (double)0.05f || Math.abs(EntityFox.this.dG()) >= 15.0f || !EntityFox.this.aF()) && !EntityFox.this.gk();
            }
            return false;
        }

        @Override
        public boolean U_() {
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.t(true);
            EntityFox.this.y(true);
            EntityFox.this.A(false);
            EntityLiving entityliving = EntityFox.this.p();
            if (entityliving != null) {
                EntityFox.this.I().a(entityliving, 60.0f, 30.0f);
                Vec3D vec3d = new Vec3D(entityliving.dt() - EntityFox.this.dt(), entityliving.dv() - EntityFox.this.dv(), entityliving.dz() - EntityFox.this.dz()).d();
                EntityFox.this.i(EntityFox.this.dr().b(vec3d.c * 0.8, 0.9, vec3d.e * 0.8));
            }
            EntityFox.this.N().n();
        }

        @Override
        public void e() {
            EntityFox.this.z(false);
            EntityFox.this.cz = 0.0f;
            EntityFox.this.cA = 0.0f;
            EntityFox.this.A(false);
            EntityFox.this.y(false);
        }

        @Override
        public void a() {
            EntityLiving entityliving = EntityFox.this.p();
            if (entityliving != null) {
                EntityFox.this.I().a(entityliving, 60.0f, 30.0f);
            }
            if (!EntityFox.this.gk()) {
                Vec3D vec3d = EntityFox.this.dr();
                if (vec3d.d * vec3d.d < (double)0.03f && EntityFox.this.dG() != 0.0f) {
                    EntityFox.this.u(MathHelper.j(0.2f, EntityFox.this.dG(), 0.0f));
                } else {
                    double d0 = vec3d.h();
                    double d1 = Math.signum(-vec3d.d) * Math.acos(d0 / vec3d.f()) * 57.2957763671875;
                    EntityFox.this.u((float)d1);
                }
            }
            if (entityliving != null && EntityFox.this.f((Entity)entityliving) <= 2.0f) {
                EntityFox.this.D(entityliving);
            } else if (EntityFox.this.dG() > 0.0f && EntityFox.this.aF() && (float)EntityFox.this.dr().d != 0.0f && EntityFox.this.dO().a_(EntityFox.this.do()).a(Blocks.dN)) {
                EntityFox.this.u(60.0f);
                EntityFox.this.h((EntityLiving)null);
                EntityFox.this.B(true);
            }
        }
    }

    private class s
    extends PathfinderGoalFleeSun {
        private int c;

        public s(double d0) {
            super(EntityFox.this, d0);
            this.c = net.minecraft.world.entity.animal.EntityFox$s.b(100);
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.fH() && this.a.p() == null) {
                if (EntityFox.this.dO().ac() && EntityFox.this.dO().h(this.a.do())) {
                    return this.h();
                }
                if (this.c > 0) {
                    --this.c;
                    return false;
                }
                this.c = 100;
                BlockPosition blockposition = this.a.do();
                return EntityFox.this.dO().R() && EntityFox.this.dO().h(blockposition) && !((WorldServer)EntityFox.this.dO()).c(blockposition) && this.h();
            }
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.gy();
            super.d();
        }
    }

    private class l
    extends PathfinderGoalMeleeAttack {
        public l(double d0, boolean flag) {
            super(EntityFox.this, d0, flag);
        }

        @Override
        protected void a(EntityLiving target) {
            if (this.b(target)) {
                this.h();
                this.a.D(target);
                EntityFox.this.a(SoundEffects.jh, 1.0f, 1.0f);
            }
        }

        @Override
        public void d() {
            EntityFox.this.A(false);
            super.d();
        }

        @Override
        public boolean b() {
            return !EntityFox.this.x() && !EntityFox.this.fH() && !EntityFox.this.cb() && !EntityFox.this.gk() && super.b();
        }
    }

    private class t
    extends d {
        private static final int c = net.minecraft.world.entity.animal.EntityFox$t.b(140);
        private int d;

        public t() {
            this.d = EntityFox.this.ah.a(c);
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean b() {
            return EntityFox.this.bo == 0.0f && EntityFox.this.bp == 0.0f && EntityFox.this.bq == 0.0f ? this.k() || EntityFox.this.fH() : false;
        }

        @Override
        public boolean c() {
            return this.k();
        }

        private boolean k() {
            if (this.d > 0) {
                --this.d;
                return false;
            }
            return EntityFox.this.dO().R() && this.h() && !this.i() && !EntityFox.this.az;
        }

        @Override
        public void e() {
            this.d = EntityFox.this.ah.a(c);
            EntityFox.this.gy();
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.z(false);
            EntityFox.this.A(false);
            EntityFox.this.t(false);
            EntityFox.this.D(true);
            EntityFox.this.N().n();
            EntityFox.this.J().a(EntityFox.this.dt(), EntityFox.this.dv(), EntityFox.this.dz(), 0.0);
        }
    }

    private class h
    extends PathfinderGoalFollowParent {
        private final EntityFox d;

        public h(EntityFox entityFox, EntityFox fox, EntityFox speed, double d0) {
            super(speed, d0);
            this.d = speed;
        }

        @Override
        public boolean b() {
            return !this.d.gw() && super.b();
        }

        @Override
        public boolean c() {
            return !this.d.gw() && super.c();
        }

        @Override
        public void d() {
            this.d.gy();
            super.d();
        }
    }

    private class q
    extends PathfinderGoalNearestVillage {
        public q(int i2, int j2) {
            super(EntityFox.this, j2);
        }

        @Override
        public void d() {
            EntityFox.this.gy();
            super.d();
        }

        @Override
        public boolean b() {
            return super.b() && this.h();
        }

        @Override
        public boolean c() {
            return super.c() && this.h();
        }

        private boolean h() {
            return !EntityFox.this.fH() && !EntityFox.this.x() && !EntityFox.this.gw() && EntityFox.this.p() == null;
        }
    }

    public class f
    extends PathfinderGoalGotoTarget {
        private static final int i = 40;
        protected int g;

        public f(double d0, int i2, int j2) {
            super(EntityFox.this, d0, i2, j2);
        }

        @Override
        public double i() {
            return 2.0;
        }

        @Override
        public boolean l() {
            return this.d % 100 == 0;
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            IBlockData iblockdata = world.a_(pos);
            return iblockdata.a(Blocks.oi) && iblockdata.c(BlockSweetBerryBush.c) >= 2 || CaveVines.h_(iblockdata);
        }

        @Override
        public void a() {
            if (this.m()) {
                if (this.g >= 40) {
                    this.o();
                } else {
                    ++this.g;
                }
            } else if (!this.m() && EntityFox.this.ah.i() < 0.05f) {
                EntityFox.this.a(SoundEffects.jn, 1.0f, 1.0f);
            }
            super.a();
        }

        protected void o() {
            if (EntityFox.this.dO().ab().b(GameRules.c)) {
                IBlockData iblockdata = EntityFox.this.dO().a_(this.e);
                if (iblockdata.a(Blocks.oi)) {
                    this.b(iblockdata);
                } else if (CaveVines.h_(iblockdata)) {
                    this.a(iblockdata);
                }
            }
        }

        private void a(IBlockData state) {
            CaveVines.a(EntityFox.this, state, EntityFox.this.dO(), this.e);
        }

        private void b(IBlockData state) {
            int i2 = state.c(BlockSweetBerryBush.c);
            state.a(BlockSweetBerryBush.c, 1);
            if (!CraftEventFactory.callEntityChangeBlockEvent(EntityFox.this, this.e, (IBlockData)state.a(BlockSweetBerryBush.c, 1))) {
                return;
            }
            int j2 = 1 + EntityFox.this.dO().z.a(2) + (i2 == 3 ? 1 : 0);
            ItemStack itemstack = EntityFox.this.a(EnumItemSlot.a);
            if (itemstack.e()) {
                EntityFox.this.a(EnumItemSlot.a, new ItemStack(Items.wu));
                --j2;
            }
            if (j2 > 0) {
                Block.a(EntityFox.this.dO(), this.e, new ItemStack(Items.wu, j2));
            }
            EntityFox.this.a(SoundEffects.zs, 1.0f, 1.0f);
            EntityFox.this.dO().a(this.e, (IBlockData)state.a(BlockSweetBerryBush.c, 1), 2);
            EntityFox.this.dO().a(GameEvent.c, this.e, GameEvent.a.a(EntityFox.this));
        }

        @Override
        public boolean b() {
            return !EntityFox.this.fH() && super.b();
        }

        @Override
        public void d() {
            this.g = 0;
            EntityFox.this.x(false);
            super.d();
        }
    }

    private class p
    extends PathfinderGoal {
        public p() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.a(EnumItemSlot.a).e()) {
                return false;
            }
            if (EntityFox.this.p() == null && EntityFox.this.ei() == null) {
                if (!EntityFox.this.gz()) {
                    return false;
                }
                if (EntityFox.this.dR().a(net.minecraft.world.entity.animal.EntityFox$p.b(10)) != 0) {
                    return false;
                }
                List<EntityItem> list = EntityFox.this.dO().a(EntityItem.class, EntityFox.this.cK().c(8.0, 8.0, 8.0), co);
                return !list.isEmpty() && EntityFox.this.a(EnumItemSlot.a).e();
            }
            return false;
        }

        @Override
        public void a() {
            List<EntityItem> list = EntityFox.this.dO().a(EntityItem.class, EntityFox.this.cK().c(8.0, 8.0, 8.0), co);
            ItemStack itemstack = EntityFox.this.a(EnumItemSlot.a);
            if (itemstack.e() && !list.isEmpty()) {
                EntityFox.this.N().a((Entity)list.get(0), (double)1.2f);
            }
        }

        @Override
        public void d() {
            List<EntityItem> list = EntityFox.this.dO().a(EntityItem.class, EntityFox.this.cK().c(8.0, 8.0, 8.0), co);
            if (!list.isEmpty()) {
                EntityFox.this.N().a((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    private class j
    extends PathfinderGoalLookAtPlayer {
        public j(EntityInsentient mob, Class targetType, float range) {
            super(mob, targetType, range);
        }

        @Override
        public boolean b() {
            return super.b() && !EntityFox.this.gk() && !EntityFox.this.go();
        }

        @Override
        public boolean c() {
            return super.c() && !EntityFox.this.gk() && !EntityFox.this.go();
        }
    }

    private class r
    extends d {
        private double c;
        private double d;
        private int e;
        private int f;

        public r() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return EntityFox.this.ei() == null && EntityFox.this.dR().i() < 0.02f && !EntityFox.this.fH() && EntityFox.this.p() == null && EntityFox.this.N().l() && !this.i() && !EntityFox.this.gl() && !EntityFox.this.cb();
        }

        @Override
        public boolean c() {
            return this.f > 0;
        }

        @Override
        public void d() {
            this.k();
            this.f = 2 + EntityFox.this.dR().a(3);
            EntityFox.this.x(true);
            EntityFox.this.N().n();
        }

        @Override
        public void e() {
            EntityFox.this.x(false);
        }

        @Override
        public void a() {
            --this.e;
            if (this.e <= 0) {
                --this.f;
                this.k();
            }
            EntityFox.this.I().a(EntityFox.this.dt() + this.c, EntityFox.this.dx(), EntityFox.this.dz() + this.d, EntityFox.this.ae(), EntityFox.this.ac());
        }

        private void k() {
            double d0 = Math.PI * 2 * EntityFox.this.dR().j();
            this.c = Math.cos(d0);
            this.d = Math.sin(d0);
            this.e = this.a(80 + EntityFox.this.dR().a(20));
        }
    }

    private class a
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        @Nullable
        private EntityLiving j;
        @Nullable
        private EntityLiving k;
        private int l;

        public a(Class oclass, boolean flag, @Nullable boolean flag1, Predicate<EntityLiving> predicate) {
            super(EntityFox.this, oclass, 10, flag, flag1, predicate);
        }

        @Override
        public boolean b() {
            if (this.b > 0 && this.e.dR().a(this.b) != 0) {
                return false;
            }
            for (UUID uuid : EntityFox.this.gv()) {
                EntityLiving entityliving;
                Entity entity;
                if (uuid == null || !(EntityFox.this.dO() instanceof WorldServer) || !((entity = ((WorldServer)EntityFox.this.dO()).a(uuid)) instanceof EntityLiving)) continue;
                this.k = entityliving = (EntityLiving)entity;
                this.j = entityliving.ei();
                int i2 = entityliving.ej();
                return i2 != this.l && this.a(this.j, this.d);
            }
            return false;
        }

        @Override
        public void d() {
            this.a(this.j);
            this.c = this.j;
            if (this.k != null) {
                this.l = this.k.ej();
            }
            EntityFox.this.a(SoundEffects.jf, 1.0f, 1.0f);
            EntityFox.this.C(true);
            EntityFox.this.gx();
            super.d();
        }
    }

    public static enum Type implements INamable
    {
        a(0, "red"),
        b(1, "snow");

        public static final INamable.a<Type> c;
        private static final IntFunction<Type> d;
        private final int e;
        private final String f;

        private Type(int i2, String s2) {
            this.e = i2;
            this.f = s2;
        }

        @Override
        public String c() {
            return this.f;
        }

        public int a() {
            return this.e;
        }

        public static Type a(String name) {
            return c.a(name, a);
        }

        public static Type a(int id) {
            return d.apply(id);
        }

        public static Type a(Holder<BiomeBase> biome) {
            return biome.a(BiomeTags.ar) ? b : a;
        }

        static {
            c = INamable.a(Type::values);
            d = ByIdMap.a(Type::a, Type.values(), ByIdMap.a.a);
        }
    }

    public static class i
    extends EntityAgeable.a {
        public final Type a;

        public i(Type type) {
            super(false);
            this.a = type;
        }
    }

    public class c
    implements Predicate<EntityLiving> {
        public boolean a(EntityLiving entityliving) {
            return entityliving instanceof EntityFox ? false : (!(entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit || entityliving instanceof EntityMonster) ? (entityliving instanceof EntityTameableAnimal ? !((EntityTameableAnimal)entityliving).s() : (entityliving instanceof EntityHuman && (entityliving.R_() || ((EntityHuman)entityliving).f()) ? false : (EntityFox.this.c(entityliving.cz()) ? false : !entityliving.fH() && !entityliving.bZ()))) : true);
        }
    }

    private abstract class d
    extends PathfinderGoal {
        private final PathfinderTargetCondition b;

        d() {
            this.b = PathfinderTargetCondition.a().a(12.0).d().a(new c());
        }

        protected boolean h() {
            BlockPosition blockposition = BlockPosition.a(EntityFox.this.dt(), EntityFox.this.cK().e, EntityFox.this.dz());
            return !EntityFox.this.dO().h(blockposition) && EntityFox.this.c(blockposition) >= 0.0f;
        }

        protected boolean i() {
            return !EntityFox.this.dO().a(EntityLiving.class, this.b, EntityFox.this, EntityFox.this.cK().c(12.0, 6.0, 12.0)).isEmpty();
        }
    }
}

