/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.EntityDyeEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.animal.WolfVariants;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityWolf
extends EntityTameableAnimal
implements IEntityAngerable,
VariantHolder<Holder<WolfVariant>> {
    private static final DataWatcherObject<Boolean> ch = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> ci = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> cj = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Holder<WolfVariant>> ck = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.y);
    public static final Predicate<EntityLiving> cg = entityliving -> {
        EntityTypes<?> entitytypes = entityliving.am();
        return entitytypes == EntityTypes.aJ || entitytypes == EntityTypes.aG || entitytypes == EntityTypes.Q;
    };
    private static final float cl = 8.0f;
    private static final float cm = 40.0f;
    private static final float cn = 0.125f;
    private float co;
    private float cp;
    private boolean cq;
    private boolean cr;
    private float cs;
    private float ct;
    private static final UniformInt cu = TimeRange.a(20, 39);
    @Nullable
    private UUID cv;

    public EntityWolf(EntityTypes<? extends EntityWolf> type, World world) {
        super((EntityTypes<? extends EntityTameableAnimal>)type, world);
        this.b(false, false);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    @Override
    protected void B() {
        this.bW.a(1, new PathfinderGoalFloat(this));
        this.bW.a(1, new EntityTameableAnimal.a(1.5, DamageTypeTags.G));
        this.bW.a(2, new PathfinderGoalSit(this));
        this.bW.a(3, new a(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.bW.a(4, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bW.a(5, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bW.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.bW.a(7, new PathfinderGoalBreed(this, 1.0));
        this.bW.a(8, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bW.a(9, new PathfinderGoalBeg(this, 8.0f));
        this.bW.a(10, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bW.a(10, new PathfinderGoalRandomLookaround(this));
        this.bX.a(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.bX.a(2, new PathfinderGoalOwnerHurtTarget(this));
        this.bX.a(3, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.bX.a(4, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a_));
        this.bX.a(5, new PathfinderGoalRandomTargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, cg));
        this.bX.a(6, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.cc));
        this.bX.a(7, new PathfinderGoalNearestAttackableTarget<EntitySkeletonAbstract>((EntityInsentient)this, EntitySkeletonAbstract.class, false));
        this.bX.a(8, new PathfinderGoalUniversalAngerReset<EntityWolf>(this, true));
    }

    public MinecraftKey gu() {
        WolfVariant wolfvariant = this.gv().a();
        return this.s() ? wolfvariant.b() : (this.ad_() ? wolfvariant.c() : wolfvariant.a());
    }

    public Holder<WolfVariant> gv() {
        return this.ao.a(ck);
    }

    public void i(Holder<WolfVariant> holder) {
        this.ao.a(ck, holder);
    }

    public static AttributeProvider.Builder gw() {
        return EntityInsentient.C().a(GenericAttributes.v, 0.3f).a(GenericAttributes.s, 8.0).a(GenericAttributes.c, 4.0);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        IRegistryCustom iregistrycustom = this.dQ();
        IRegistry<WolfVariant> iregistry = iregistrycustom.d(Registries.m);
        DataWatcherObject<Holder<WolfVariant>> datawatcherobject = ck;
        Optional<Holder.c<WolfVariant>> optional = iregistry.b(WolfVariants.j);
        Objects.requireNonNull(iregistry);
        builder.a(datawatcherobject, (Holder)optional.or(iregistry::a).orElseThrow());
        builder.a(ch, false);
        builder.a(ci, EnumColor.o.a());
        builder.a(cj, 0);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.CT, 0.15f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("CollarColor", (byte)this.gz().a());
        this.gv().e().ifPresent(resourcekey -> nbt.a("variant", resourcekey.a().toString()));
        this.a_(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        Optional.ofNullable(MinecraftKey.c(nbt.l("variant"))).map(minecraftkey -> ResourceKey.a(Registries.m, minecraftkey)).flatMap(resourcekey -> this.dQ().d(Registries.m).b((ResourceKey<WolfVariant>)resourcekey)).ifPresent(this::i);
        if (nbt.b("CollarColor", 99)) {
            this.a(EnumColor.a(nbt.h("CollarColor")));
        }
        this.a(this.dO(), nbt);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData) {
        Holder<WolfVariant> holder1;
        Holder<BiomeBase> holder = world.t(this.do());
        if (entityData instanceof b) {
            b entitywolf_b = (b)entityData;
            holder1 = entitywolf_b.a;
        } else {
            holder1 = WolfVariants.a(this.dQ(), holder);
            entityData = new b(holder1);
        }
        this.i(holder1);
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected SoundEffect v() {
        return this.ad_() ? SoundEffects.CO : (this.ah.a(3) == 0 ? (this.s() && this.ew() < 20.0f ? SoundEffects.CU : SoundEffects.CR) : SoundEffects.CM);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return this.g(source) ? SoundEffects.CK : SoundEffects.CQ;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.CN;
    }

    @Override
    public float fa() {
        return 0.4f;
    }

    @Override
    public void m_() {
        super.m_();
        if (!this.dO().B && this.cq && !this.cr && !this.gg() && this.aF()) {
            this.cr = true;
            this.cs = 0.0f;
            this.ct = 0.0f;
            this.dO().a((Entity)this, (byte)8);
        }
        if (!this.dO().B) {
            this.a((WorldServer)this.dO(), true);
        }
    }

    @Override
    public void l() {
        super.l();
        if (this.bE()) {
            this.cp = this.co;
            this.co = this.gB() ? (this.co += (1.0f - this.co) * 0.4f) : (this.co += (0.0f - this.co) * 0.4f);
            if (this.bh()) {
                this.cq = true;
                if (this.cr && !this.dO().B) {
                    this.dO().a((Entity)this, (byte)56);
                    this.gC();
                }
            } else if ((this.cq || this.cr) && this.cr) {
                if (this.cs == 0.0f) {
                    this.a(SoundEffects.CS, this.fa(), (this.ah.i() - this.ah.i()) * 0.2f + 1.0f);
                    ((Entity)this).a((Holder<GameEvent>)GameEvent.u);
                }
                this.ct = this.cs;
                this.cs += 0.05f;
                if (this.ct >= 2.0f) {
                    this.cq = false;
                    this.cr = false;
                    this.ct = 0.0f;
                    this.cs = 0.0f;
                }
                if (this.cs > 0.4f) {
                    float f2 = (float)this.dv();
                    int i2 = (int)(MathHelper.a((this.cs - 0.4f) * (float)Math.PI) * 7.0f);
                    Vec3D vec3d = this.dr();
                    for (int j2 = 0; j2 < i2; ++j2) {
                        float f1 = (this.ah.i() * 2.0f - 1.0f) * this.dj() * 0.5f;
                        float f22 = (this.ah.i() * 2.0f - 1.0f) * this.dj() * 0.5f;
                        this.dO().a(Particles.am, this.dt() + (double)f1, (double)(f2 + 0.8f), this.dz() + (double)f22, vec3d.c, vec3d.d, vec3d.e);
                    }
                }
            }
        }
    }

    private void gC() {
        this.cr = false;
        this.cs = 0.0f;
        this.ct = 0.0f;
    }

    @Override
    public void a(DamageSource damageSource) {
        this.cq = false;
        this.cr = false;
        this.ct = 0.0f;
        this.cs = 0.0f;
        super.a(damageSource);
    }

    public boolean gx() {
        return this.cq;
    }

    public float H(float tickDelta) {
        return Math.min(0.75f + MathHelper.i(tickDelta, this.ct, this.cs) / 2.0f * 0.25f, 1.0f);
    }

    public float g(float tickDelta, float f1) {
        float f2 = (MathHelper.i(tickDelta, this.ct, this.cs) + f1) / 1.8f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return MathHelper.a(f2 * (float)Math.PI) * MathHelper.a(f2 * (float)Math.PI * 11.0f) * 0.15f * (float)Math.PI;
    }

    public float I(float tickDelta) {
        return MathHelper.i(tickDelta, this.cp, this.co) * 0.15f * (float)Math.PI;
    }

    @Override
    public int ac() {
        return this.x() ? 20 : super.ac();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        boolean result = super.a(source, amount);
        if (!this.dO().B && result) {
            this.z(false);
        }
        return result;
    }

    @Override
    public boolean d(EnumItemSlot slot) {
        return true;
    }

    @Override
    public boolean actuallyHurt(DamageSource damagesource, float f2, EntityDamageEvent event) {
        if (!this.g(damagesource)) {
            return super.actuallyHurt(damagesource, f2, event);
        }
        if (event.isCancelled()) {
            return false;
        }
        ItemStack itemstack = this.fO();
        int i2 = itemstack.n();
        int j2 = itemstack.o();
        itemstack.a(MathHelper.f(f2), (EntityLiving)this, EnumItemSlot.g);
        if (Crackiness.b.a(i2, j2) != Crackiness.b.a(this.fO())) {
            this.a(SoundEffects.CJ);
            World world = this.dO();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                worldserver.a(new ParticleParamItem(Particles.S, Items.oq.w()), this.dt(), this.dv() + 1.0, this.dz(), 20, 0.2, 0.1, 0.2, 0.1);
            }
        }
        return false;
    }

    private boolean g(DamageSource source) {
        return this.gA() && !source.a(DamageTypeTags.C);
    }

    @Override
    protected void t() {
        if (this.s()) {
            this.f(GenericAttributes.s).a(40.0);
            this.v(this.eN());
        } else {
            this.f(GenericAttributes.s).a(8.0);
        }
    }

    @Override
    protected void b(DamageSource source, float amount) {
        this.a(source, amount, EnumItemSlot.g);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        Item item = itemstack.g();
        if (!(!this.dO().B || this.o_() && this.o(itemstack))) {
            boolean flag = this.j(player) || this.s() || itemstack.a(Items.rz) && !this.s() && !this.ad_();
            return flag ? EnumInteractionResult.c : EnumInteractionResult.e;
        }
        if (this.s()) {
            ItemStack itemstack1;
            if (this.o(itemstack) && this.ew() < this.eN()) {
                itemstack.a(1, (EntityLiving)player);
                FoodInfo foodinfo = itemstack.a(DataComponents.v);
                float f2 = foodinfo != null ? (float)foodinfo.b() : 1.0f;
                this.heal(2.0f * f2, EntityRegainHealthEvent.RegainReason.EATING);
                return EnumInteractionResult.a(this.dO().x_());
            }
            if (item instanceof ItemDye) {
                ItemDye itemdye = (ItemDye)item;
                if (this.j(player)) {
                    EnumColor enumcolor = itemdye.c();
                    if (enumcolor != this.gz()) {
                        EntityDyeEvent event = new EntityDyeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), DyeColor.getByWoolData((byte)((byte)enumcolor.a())), (Player)((EntityPlayer)player).getBukkitEntity());
                        if (!event.callEvent()) {
                            return EnumInteractionResult.f;
                        }
                        enumcolor = EnumColor.a(event.getColor().getWoolData());
                        this.a(enumcolor);
                        itemstack.a(1, (EntityLiving)player);
                        return EnumInteractionResult.a;
                    }
                    return super.b(player, hand);
                }
            }
            if (itemstack.a(Items.or) && this.j(player) && this.fO().e() && !this.o_()) {
                this.m(itemstack.c(1));
                itemstack.a(1, (EntityLiving)player);
                return EnumInteractionResult.a;
            }
            if (itemstack.a(Items.rV) && this.j(player) && this.gA() && (!EnchantmentManager.a(this.fO(), EnchantmentEffectComponents.E) || player.f())) {
                itemstack.a(1, (EntityLiving)player, EntityWolf.d(hand));
                this.a(SoundEffects.az);
                itemstack1 = this.fO();
                this.m(ItemStack.l);
                this.forceDrops = true;
                this.b(itemstack1);
                this.forceDrops = false;
                return EnumInteractionResult.a;
            }
            if (EnumArmorMaterial.h.a().d().get().a(itemstack) && this.x() && this.gA() && this.j(player) && this.fO().m()) {
                itemstack.h(1);
                this.a(SoundEffects.CL);
                itemstack1 = this.fO();
                int i2 = (int)((float)itemstack1.o() * 0.125f);
                itemstack1.b(Math.max(0, itemstack1.n() - i2));
                return EnumInteractionResult.a;
            }
            EnumInteractionResult enuminteractionresult = super.b(player, hand);
            if (!enuminteractionresult.a() && this.j(player)) {
                this.z(!this.gk());
                this.bn = false;
                this.bV.n();
                this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
                return EnumInteractionResult.b;
            }
            return enuminteractionresult;
        }
        if (itemstack.a(Items.rz) && !this.ad_()) {
            itemstack.a(1, (EntityLiving)player);
            this.g(player);
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    private void g(EntityHuman player) {
        if (this.ah.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
            this.a(player);
            this.bV.n();
            this.h((EntityLiving)null);
            this.z(true);
            this.dO().a((Entity)this, (byte)7);
        } else {
            this.dO().a((Entity)this, (byte)6);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 8) {
            this.cr = true;
            this.cs = 0.0f;
            this.ct = 0.0f;
        } else if (status == 56) {
            this.gC();
        } else {
            super.b(status);
        }
    }

    public float gy() {
        if (this.ad_()) {
            return 1.5393804f;
        }
        if (this.s()) {
            float f2 = this.eN();
            float f1 = (f2 - this.ew()) / f2;
            return (0.55f - f1 * 0.4f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean o(ItemStack stack) {
        return stack.a(TagsItem.ad);
    }

    @Override
    public int fN() {
        return 8;
    }

    @Override
    public int a() {
        return this.ao.a(cj);
    }

    @Override
    public void a(int angerTime) {
        this.ao.a(cj, angerTime);
    }

    @Override
    public void c() {
        this.a(cu.a(this.ah));
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cv;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.cv = angryAt;
    }

    public EnumColor gz() {
        return EnumColor.a(this.ao.a(ci));
    }

    public boolean gA() {
        return this.fO().a(Items.or);
    }

    @Override
    public void a(EnumColor color) {
        this.ao.a(ci, color.a());
    }

    @Nullable
    public EntityWolf b(WorldServer world, EntityAgeable entity) {
        EntityWolf entitywolf = EntityTypes.bs.a(world);
        if (entitywolf != null && entity instanceof EntityWolf) {
            EntityWolf entitywolf1 = (EntityWolf)entity;
            if (this.ah.h()) {
                entitywolf.i(this.gv());
            } else {
                entitywolf.i(entitywolf1.gv());
            }
            if (this.s()) {
                entitywolf.b(this.aa_());
                entitywolf.b(true, true);
                if (this.ah.h()) {
                    entitywolf.a(this.gz());
                } else {
                    entitywolf.a(entitywolf1.gz());
                }
            }
        }
        return entitywolf;
    }

    public void A(boolean begging) {
        this.ao.a(ch, begging);
    }

    @Override
    public boolean a(EntityAnimal other) {
        if (other == this) {
            return false;
        }
        if (!this.s()) {
            return false;
        }
        if (!(other instanceof EntityWolf)) {
            return false;
        }
        EntityWolf entitywolf = (EntityWolf)other;
        return !entitywolf.s() ? false : (entitywolf.x() ? false : this.gs() && entitywolf.gs());
    }

    public boolean gB() {
        return this.ao.a(ch);
    }

    @Override
    public boolean a(EntityLiving target, EntityLiving owner) {
        if (!(target instanceof EntityCreeper || target instanceof EntityGhast || target instanceof EntityArmorStand)) {
            EntityTameableAnimal entitytameableanimal;
            EntityHorseAbstract entityhorseabstract;
            if (target instanceof EntityWolf) {
                EntityWolf entitywolf = (EntityWolf)target;
                return !entitywolf.s() || entitywolf.T_() != owner;
            }
            if (target instanceof EntityHuman) {
                EntityHuman entityhuman1;
                EntityHuman entityhuman = (EntityHuman)target;
                if (owner instanceof EntityHuman && !(entityhuman1 = (EntityHuman)owner).a(entityhuman)) {
                    return false;
                }
            }
            if (target instanceof EntityHorseAbstract && (entityhorseabstract = (EntityHorseAbstract)target).gz()) {
                return false;
            }
            if (target instanceof EntityTameableAnimal && (entitytameableanimal = (EntityTameableAnimal)target).s()) {
                boolean flag = false;
                return flag;
            }
            boolean flag = true;
            return flag;
        }
        return false;
    }

    @Override
    public boolean y() {
        return !this.ad_();
    }

    @Override
    public Vec3D cM() {
        return new Vec3D(0.0, 0.6f * this.cL(), this.dj() * 0.4f);
    }

    public static boolean c(EntityTypes<EntityWolf> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.e()).a(TagsBlock.cg) && EntityWolf.a(world, pos);
    }

    private class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityWolf j;

        public a(EntityWolf entitywolf, Class oclass, float f2, double d0, double d1) {
            super(entitywolf, oclass, f2, d0, d1);
            this.j = entitywolf;
        }

        @Override
        public boolean b() {
            return super.b() && this.b instanceof EntityLlama ? !this.j.s() && this.a((EntityLlama)this.b) : false;
        }

        private boolean a(EntityLlama llama) {
            return llama.go() >= EntityWolf.this.ah.a(5);
        }

        @Override
        public void d() {
            EntityWolf.this.h((EntityLiving)null);
            super.d();
        }

        @Override
        public void a() {
            EntityWolf.this.h((EntityLiving)null);
            super.a();
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Holder<WolfVariant> a;

        public b(Holder<WolfVariant> variant) {
            super(false);
            this.a = variant;
        }
    }
}

