/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.slf4j.Logger;

public abstract class BlockAttachedEntity
extends Entity {
    private static final Logger c = LogUtils.getLogger();
    private int d;
    protected BlockPosition b;

    protected BlockAttachedEntity(EntityTypes<? extends BlockAttachedEntity> type, World world) {
        super(type, world);
        this.d = this.an() % this.dO().spigotConfig.hangingTickFrequency;
    }

    protected BlockAttachedEntity(EntityTypes<? extends BlockAttachedEntity> type, World world, BlockPosition attachedBlockPos) {
        this(type, world);
        this.b = attachedBlockPos;
    }

    protected abstract void p();

    @Override
    public void l() {
        if (!this.dO().B) {
            this.ax();
            if (this.d++ == this.dO().spigotConfig.hangingTickFrequency) {
                this.d = 0;
                if (!this.dJ() && !this.s()) {
                    IBlockData material = this.dO().a_(this.do());
                    HangingBreakEvent.RemoveCause cause = !material.i() ? HangingBreakEvent.RemoveCause.OBSTRUCTION : HangingBreakEvent.RemoveCause.PHYSICS;
                    HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), cause);
                    this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (this.dJ() || event.isCancelled()) {
                        return;
                    }
                    this.discard(EntityRemoveEvent.Cause.DROP);
                    this.b((Entity)null);
                }
            }
        }
    }

    public abstract boolean s();

    @Override
    public boolean bA() {
        return true;
    }

    @Override
    public boolean u(Entity attacker) {
        if (attacker instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)attacker;
            return !this.dO().a(entityhuman, this.b) ? true : this.a(this.dP().a(entityhuman), 0.0f);
        }
        return false;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (!this.dJ() && !this.dO().B) {
            Entity damager;
            Entity entity = damager = !source.b() && source.d() != null ? source.d() : source.c();
            Object event = damager != null ? new HangingBreakByEntityEvent((Hanging)this.getBukkitEntity(), (org.bukkit.entity.Entity)damager.getBukkitEntity(), source.a(DamageTypeTags.l) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.ENTITY) : new HangingBreakEvent((Hanging)this.getBukkitEntity(), source.a(DamageTypeTags.l) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.DEFAULT);
            this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.dJ() || event.isCancelled()) {
                return true;
            }
            this.ap();
            this.bw();
            this.b(source.d());
        }
        return true;
    }

    @Override
    public void a(EnumMoveType movementType, Vec3D movement) {
        if (!this.dO().B && !this.dJ() && movement.g() > 0.0) {
            if (this.dJ()) {
                return;
            }
            HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), HangingBreakEvent.RemoveCause.PHYSICS);
            this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.dJ() || event.isCancelled()) {
                return;
            }
            this.ap();
            this.b((Entity)null);
        }
    }

    @Override
    public void push(double deltaX, double deltaY, double deltaZ, @Nullable Entity pushingEntity) {
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound, boolean includeAll) {
        if (includeAll) {
            this.b(nbttagcompound);
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        BlockPosition blockposition = this.t();
        nbt.a("TileX", blockposition.u());
        nbt.a("TileY", blockposition.v());
        nbt.a("TileZ", blockposition.w());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        BlockPosition blockposition = new BlockPosition(nbt.h("TileX"), nbt.h("TileY"), nbt.h("TileZ"));
        if (!blockposition.a(this.do(), 16.0)) {
            c.error("Block-attached entity at invalid position: {}", (Object)blockposition);
        } else {
            this.b = blockposition;
        }
    }

    public abstract void b(@Nullable Entity var1);

    @Override
    protected boolean bC() {
        return false;
    }

    @Override
    public void a_(double x2, double y2, double z2) {
        this.b = BlockPosition.a(x2, y2, z2);
        this.p();
        this.av = true;
    }

    public BlockPosition t() {
        return this.b;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
    }

    @Override
    public void i_() {
    }
}

