/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLeash;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;

public class EntityLeash
extends BlockAttachedEntity {
    public static final double c = 0.375;

    public EntityLeash(EntityTypes<? extends EntityLeash> type, World world) {
        super((EntityTypes<? extends BlockAttachedEntity>)type, world);
    }

    public EntityLeash(World world, BlockPosition pos) {
        super(EntityTypes.al, world, pos);
        this.a_(pos.u(), pos.v(), pos.w());
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Override
    protected void p() {
        this.o((double)this.b.u() + 0.5, (double)this.b.v() + 0.375, (double)this.b.w() + 0.5);
        double d0 = (double)this.am().l() / 2.0;
        double d1 = this.am().m();
        this.a(new AxisAlignedBB(this.dt() - d0, this.dv(), this.dz() - d0, this.dt() + d0, this.dv() + d1, this.dz() + d0));
    }

    @Override
    public boolean a(double distance) {
        return distance < 1024.0;
    }

    @Override
    public void b(@Nullable Entity breaker) {
        this.a(SoundEffects.nS, 1.0f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbt) {
    }

    @Override
    public void a(NBTTagCompound nbt) {
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        if (this.dO().B) {
            return EnumInteractionResult.a;
        }
        boolean flag = false;
        List<Leashable> list = ItemLeash.a(this.dO(), this.t(), (Leashable leashable) -> {
            Entity entity = leashable.A();
            return entity == player || entity == this;
        });
        for (Leashable leashable2 : list) {
            Entity leashed;
            if (leashable2.A() != player) continue;
            if (leashable2 instanceof Entity && CraftEventFactory.callPlayerLeashEntityEvent(leashed = (Entity)((Object)leashable2), this, player, hand).isCancelled()) {
                ((EntityPlayer)player).c.b(new PacketPlayOutAttachEntity(leashed, leashable2.A()));
                flag = true;
                continue;
            }
            leashable2.b((Entity)this, true);
            flag = true;
        }
        boolean flag1 = false;
        if (!flag) {
            boolean die = true;
            for (Leashable leashable1 : list) {
                boolean dropLeash;
                if (!leashable1.N_() || leashable1.A() != this) continue;
                boolean bl = dropLeash = !player.fL();
                if (leashable1 instanceof Entity) {
                    Entity leashed = (Entity)((Object)leashable1);
                    PlayerUnleashEntityEvent event = CraftEventFactory.callPlayerUnleashEntityEvent(leashed, player, hand, dropLeash);
                    dropLeash = event.isDropLeash();
                    if (event.isCancelled()) {
                        die = false;
                        continue;
                    }
                }
                leashable1.a(true, dropLeash);
                flag1 = true;
            }
            if (die) {
                this.discard(EntityRemoveEvent.Cause.DROP);
            }
        }
        if (flag || flag1) {
            this.a(GameEvent.b, (Entity)player);
        }
        return EnumInteractionResult.c;
    }

    @Override
    public boolean s() {
        return this.dO().a_(this.b).a(TagsBlock.T);
    }

    public static EntityLeash b(World world, BlockPosition pos) {
        EntityLeash entityleash;
        int i2 = pos.u();
        int j2 = pos.v();
        int k2 = pos.w();
        List<EntityLeash> list = world.a(EntityLeash.class, new AxisAlignedBB((double)i2 - 1.0, (double)j2 - 1.0, (double)k2 - 1.0, (double)i2 + 1.0, (double)j2 + 1.0, (double)k2 + 1.0));
        Iterator<EntityLeash> iterator = list.iterator();
        do {
            if (iterator.hasNext()) continue;
            EntityLeash entityleash1 = new EntityLeash(world, pos);
            world.b(entityleash1);
            return entityleash1;
        } while (!(entityleash = iterator.next()).t().equals(pos));
        return entityleash;
    }

    public void v() {
        this.a(SoundEffects.nT, 1.0f, 1.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entityTrackerEntry) {
        return new PacketPlayOutSpawnEntity((Entity)this, 0, this.t());
    }

    @Override
    public Vec3D s(float delta) {
        return this.m(delta).b(0.0, 0.2, 0.0);
    }

    @Override
    public ItemStack dB() {
        return new ItemStack(Items.uK);
    }
}

