/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class EntityItem
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<ItemStack> d = DataWatcher.a(EntityItem.class, DataWatcherRegistry.h);
    private static final float e = 0.1f;
    public static final float b = 0.2125f;
    private static final int f = 6000;
    private static final int g = Short.MAX_VALUE;
    private static final int h = Short.MIN_VALUE;
    public int i;
    public int j;
    public int k = 5;
    @Nullable
    public UUID l;
    @Nullable
    private Entity m;
    @Nullable
    public UUID n;
    public final float c;
    private int lastTick = MinecraftServer.currentTick - 1;
    public boolean canMobPickup = true;
    private int despawnRate = -1;
    public TriState frictionState = TriState.NOT_SET;

    public EntityItem(EntityTypes<? extends EntityItem> type, World world) {
        super(type, world);
        this.c = this.ah.i() * (float)Math.PI * 2.0f;
        this.t(this.ah.i() * 360.0f);
    }

    public EntityItem(World world, double x2, double y2, double z2, ItemStack stack) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ag, world);
        this.a_(x2, y2, z2);
        this.n(this.ah.j() * 0.2 - 0.1, 0.2, this.ah.j() * 0.2 - 0.1);
        this.a(stack);
    }

    public EntityItem(World world, double x2, double y2, double z2, ItemStack stack, double velocityX, double velocityY, double velocityZ) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ag, world);
        this.a_(x2, y2, z2);
        this.n(velocityX, velocityY, velocityZ);
        this.a(stack);
    }

    private EntityItem(EntityItem entity) {
        super(entity.am(), entity.dO());
        this.a(entity.p().s());
        this.v(entity);
        this.i = entity.i;
        this.c = entity.c;
    }

    @Override
    public boolean bd() {
        return this.p().a(TagsItem.ba);
    }

    @Override
    @Nullable
    public Entity s() {
        World world;
        if (this.m != null && !this.m.dJ()) {
            return this.m;
        }
        if (this.l != null && (world = this.dO()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.m = worldserver.a(this.l);
            return this.m;
        }
        return null;
    }

    @Override
    public void w(Entity original) {
        super.w(original);
        if (original instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)original;
            this.m = entityitem.m;
        }
    }

    @Override
    protected Entity.MovementEmission bc() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(d, ItemStack.l);
    }

    @Override
    protected double aZ() {
        return 0.04;
    }

    @Override
    public void l() {
        if (this.p().e()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            double d0;
            int i2;
            super.l();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            if (this.j != Short.MAX_VALUE) {
                this.j -= elapsedTicks;
            }
            this.j = Math.max(0, this.j);
            if (this.i != Short.MIN_VALUE) {
                this.i += elapsedTicks;
            }
            this.lastTick = MinecraftServer.currentTick;
            this.L = this.dt();
            this.M = this.dv();
            this.N = this.dz();
            Vec3D vec3d = this.dr();
            if (this.bf() && this.b(TagsFluid.a) > (double)0.1f) {
                this.D();
            } else if (this.bt() && this.b(TagsFluid.b) > (double)0.1f) {
                this.E();
            } else {
                this.bb();
            }
            if (this.dO().B) {
                this.ag = false;
            } else {
                boolean bl = this.ag = !this.dO().a((Entity)this, this.cK().h(1.0E-7));
                if (this.ag) {
                    this.m(this.dt(), (this.cK().b + this.cK().e) / 2.0, this.dz());
                }
            }
            if (!this.aF() || this.dr().i() > (double)1.0E-5f || (this.ai + this.an()) % 4 == 0) {
                this.a(EnumMoveType.a, this.dr());
                float f2 = 0.98f;
                if (this.frictionState == TriState.FALSE) {
                    f2 = 1.0f;
                } else if (this.aF()) {
                    f2 = this.dO().a_(this.aL()).b().h() * 0.98f;
                }
                this.i(this.dr().d(f2, 0.98, f2));
                if (this.aF()) {
                    Vec3D vec3d1 = this.dr();
                    if (vec3d1.d < 0.0) {
                        this.i(vec3d1.d(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.a(this.L) != MathHelper.a(this.dt()) || MathHelper.a(this.M) != MathHelper.a(this.dv()) || MathHelper.a(this.N) != MathHelper.a(this.dz());
            int n2 = i2 = flag ? 2 : 40;
            if (this.ai % i2 == 0 && !this.dO().B && this.H()) {
                this.F();
            }
            this.av |= this.bm();
            if (!this.dO().B && (d0 = this.dr().d(vec3d).g()) > 0.01) {
                this.av = true;
            }
            if (!this.dO().B && this.i >= this.despawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.i = 0;
                    return;
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    @Override
    public void inactiveTick() {
        int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
        if (this.j != Short.MAX_VALUE) {
            this.j -= elapsedTicks;
        }
        this.j = Math.max(0, this.j);
        if (this.i != Short.MIN_VALUE) {
            this.i += elapsedTicks;
        }
        this.lastTick = MinecraftServer.currentTick;
        if (!this.dO().B && this.i >= this.despawnRate) {
            if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                this.i = 0;
                return;
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public BlockPosition aL() {
        return this.e(0.999999f);
    }

    private void D() {
        Vec3D vec3d = this.dr();
        this.n(vec3d.c * (double)0.99f, vec3d.d + (double)(vec3d.d < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.e * (double)0.99f);
    }

    private void E() {
        Vec3D vec3d = this.dr();
        this.n(vec3d.c * (double)0.95f, vec3d.d + (double)(vec3d.d < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.e * (double)0.95f);
    }

    private void F() {
        if (this.H()) {
            double radius = this.dO().spigotConfig.itemMerge;
            List<EntityItem> list = this.dO().a(EntityItem.class, this.cK().c(radius, radius - 0.5, radius), (? super T entityitem) -> entityitem != this && entityitem.H());
            for (EntityItem entityitem2 : list) {
                if (!entityitem2.H() || this.dO().paperConfig().fixes.fixItemsMergingThroughWalls && this.dO().clipDirect(this.dm(), entityitem2.dm(), VoxelShapeCollision.a(this)) == MovingObjectPosition.EnumMovingObjectType.b) continue;
                this.a(entityitem2);
                if (!this.dJ()) continue;
                break;
            }
        }
    }

    private boolean H() {
        ItemStack itemstack = this.p();
        return this.bE() && this.j != Short.MAX_VALUE && this.i != Short.MIN_VALUE && this.i < this.despawnRate && itemstack.H() < itemstack.j();
    }

    private void a(EntityItem other) {
        ItemStack itemstack = this.p();
        ItemStack itemstack1 = other.p();
        if (Objects.equals(this.n, other.n) && EntityItem.a(itemstack, itemstack1)) {
            EntityItem.a(this, itemstack, other, itemstack1);
        }
    }

    public static boolean a(ItemStack stack1, ItemStack stack2) {
        return stack2.H() + stack1.H() > stack2.j() ? false : ItemStack.c(stack1, stack2);
    }

    public static ItemStack a(ItemStack stack1, ItemStack stack2, int maxCount) {
        int j2 = Math.min(Math.min(stack1.j(), maxCount) - stack1.H(), stack2.H());
        ItemStack itemstack2 = stack1.c(stack1.H() + j2);
        stack2.h(j2);
        return itemstack2;
    }

    private static void a(EntityItem targetEntity, ItemStack stack1, ItemStack stack2) {
        ItemStack itemstack2 = EntityItem.a(stack1, stack2, 64);
        targetEntity.a(itemstack2);
    }

    private static void a(EntityItem targetEntity, ItemStack targetStack, EntityItem sourceEntity, ItemStack sourceStack) {
        if (!CraftEventFactory.callItemMergeEvent(sourceEntity, targetEntity)) {
            return;
        }
        EntityItem.a(targetEntity, targetStack, sourceStack);
        targetEntity.j = Math.max(targetEntity.j, sourceEntity.j);
        targetEntity.i = Math.min(targetEntity.i, sourceEntity.i);
        if (sourceStack.e()) {
            sourceEntity.discard(EntityRemoveEvent.Cause.MERGE);
        }
    }

    @Override
    public boolean be() {
        return this.p().b(DataComponents.w) || super.be();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (!this.p().e() && this.p().a(Items.us) && source.a(DamageTypeTags.l)) {
            return false;
        }
        if (!this.p().a(source)) {
            return false;
        }
        if (this.dO().B) {
            return true;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
            return false;
        }
        this.bw();
        this.k = (int)((float)this.k - amount);
        this.a(GameEvent.o, source.d());
        if (this.k <= 0) {
            this.p().a(this);
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        if (this.frictionState != TriState.NOT_SET) {
            nbt.a("Paper.FrictionState", this.frictionState.toString());
        }
        nbt.a("Health", (short)this.k);
        nbt.a("Age", (short)this.i);
        nbt.a("PickupDelay", (short)this.j);
        if (this.l != null) {
            nbt.a("Thrower", this.l);
        }
        if (this.n != null) {
            nbt.a("Owner", this.n);
        }
        if (!this.p().e()) {
            nbt.a("Item", this.p().a(this.dQ()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.k = nbt.g("Health");
        this.i = nbt.g("Age");
        if (nbt.e("PickupDelay")) {
            this.j = nbt.g("PickupDelay");
        }
        if (nbt.b("Owner")) {
            this.n = nbt.a("Owner");
        }
        if (nbt.b("Thrower")) {
            this.l = nbt.a("Thrower");
            this.m = null;
        }
        if (nbt.b("Item", 10)) {
            NBTTagCompound nbttagcompound1 = nbt.p("Item");
            this.a(ItemStack.a((HolderLookup.a)this.dQ(), (NBTBase)nbttagcompound1).orElse(ItemStack.l));
        } else {
            this.a(ItemStack.l);
        }
        if (nbt.e("Paper.FrictionState")) {
            String fs = nbt.l("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                LogUtils.getLogger().error("Unknown friction state " + fs + " for " + String.valueOf(this));
            }
        }
        if (this.p().e()) {
            this.discard(null);
        }
    }

    @Override
    public void b_(EntityHuman player) {
        if (!this.dO().B) {
            ItemStack itemstack = this.p();
            Item item = itemstack.g();
            int i2 = itemstack.H();
            int canHold = player.fY().canHold(itemstack);
            int remaining = i2 - canHold;
            boolean flyAtPlayer = false;
            if (this.j <= 0) {
                PlayerAttemptPickupItemEvent attemptEvent = new PlayerAttemptPickupItemEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                this.dO().getCraftServer().getPluginManager().callEvent((Event)attemptEvent);
                flyAtPlayer = attemptEvent.getFlyAtPlayer();
                if (attemptEvent.isCancelled()) {
                    if (flyAtPlayer) {
                        player.a((Entity)this, i2);
                    }
                    return;
                }
            }
            if (this.j <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                itemstack.e(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.dO().getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                flyAtPlayer = playerEvent.getFlyAtPlayer();
                if (playerEvent.isCancelled()) {
                    itemstack.e(i2);
                    if (flyAtPlayer) {
                        player.a((Entity)this, i2);
                    }
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)((Player)player.getBukkitEntity()), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.dO().getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.e(i2);
                    return;
                }
                ItemStack current = this.p();
                if (!itemstack.equals(current)) {
                    itemstack = current;
                } else {
                    itemstack.e(canHold + remaining);
                }
                this.j = 0;
            } else if (this.j == 0) {
                this.j = -1;
            }
            if (this.j == 0 && (this.n == null || this.n.equals(player.cz())) && player.fY().f(itemstack)) {
                if (flyAtPlayer) {
                    player.a((Entity)this, i2);
                }
                if (itemstack.e()) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                    itemstack.e(i2);
                }
                player.a(StatisticList.e.b(item), i2);
                player.a(this);
            }
        }
    }

    @Override
    public IChatBaseComponent ah() {
        IChatBaseComponent ichatbasecomponent = this.aj();
        return ichatbasecomponent != null ? ichatbasecomponent : IChatBaseComponent.c(this.p().t());
    }

    @Override
    public boolean cu() {
        return false;
    }

    @Override
    @Nullable
    public Entity a(DimensionTransition teleportTarget) {
        Entity entity = super.a(teleportTarget);
        if (!this.dO().B && entity instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)entity;
            entityitem.F();
        }
        return entity;
    }

    public ItemStack p() {
        return this.ar().a(d);
    }

    public void a(ItemStack stack) {
        this.ar().a(d, stack);
        this.despawnRate = this.dO().paperConfig().entities.spawning.altItemDespawnRate.enabled ? this.dO().paperConfig().entities.spawning.altItemDespawnRate.items.getOrDefault((Object)stack.g(), this.dO().spigotConfig.itemDespawnRate) : this.dO().spigotConfig.itemDespawnRate;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (d.equals(data)) {
            this.p().a((Entity)this);
        }
    }

    public void b(@Nullable UUID owner) {
        this.n = owner;
    }

    public void b(Entity thrower) {
        this.l = thrower.cz();
        this.m = thrower;
    }

    public int t() {
        return this.i;
    }

    public void v() {
        this.j = 10;
    }

    public void w() {
        this.j = 0;
    }

    public void x() {
        this.j = Short.MAX_VALUE;
    }

    public void b(int pickupDelay) {
        this.j = pickupDelay;
    }

    public boolean y() {
        return this.j > 0;
    }

    public void z() {
        this.i = Short.MIN_VALUE;
    }

    public void A() {
        this.i = -6000;
    }

    public void B() {
        this.x();
        this.i = this.despawnRate - 1;
    }

    public float a(float tickDelta) {
        return ((float)this.t() + tickDelta) / 20.0f + this.c;
    }

    public EntityItem C() {
        return new EntityItem(this);
    }

    @Override
    public SoundCategory de() {
        return SoundCategory.i;
    }

    @Override
    public float dF() {
        return 180.0f - this.a(0.5f) / ((float)Math.PI * 2) * 360.0f;
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        return mappedIndex == 0 ? SlotAccess.a(this::p, this::a) : super.a_(mappedIndex);
    }
}

