/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.WitchConsumePotionEvent;
import com.destroystokyo.paper.event.entity.WitchThrowPotionEvent;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTargetWitch;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestHealableRaider;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Witch;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.inventory.ItemStack;

public class EntityWitch
extends EntityRaider
implements IRangedEntity {
    private static final MinecraftKey b = MinecraftKey.b("drinking");
    private static final AttributeModifier e = new AttributeModifier(b, -0.25, AttributeModifier.Operation.a);
    private static final DataWatcherObject<Boolean> cc = DataWatcher.a(EntityWitch.class, DataWatcherRegistry.k);
    public int cd;
    private PathfinderGoalNearestHealableRaider<EntityRaider> ce;
    private PathfinderGoalNearestAttackableTargetWitch<EntityHuman> cf;

    public EntityWitch(EntityTypes<? extends EntityWitch> type, World world) {
        super((EntityTypes<? extends EntityRaider>)type, world);
    }

    @Override
    protected void B() {
        super.B();
        this.ce = new PathfinderGoalNearestHealableRaider<EntityRaider>(this, EntityRaider.class, true, entityliving -> entityliving != null && this.gB() && entityliving.am() != EntityTypes.bo);
        this.cf = new PathfinderGoalNearestAttackableTargetWitch<EntityHuman>(this, EntityHuman.class, 10, true, false, (Predicate<EntityLiving>)null);
        this.bW.a(1, new PathfinderGoalFloat(this));
        this.bW.a(2, new PathfinderGoalArrowAttack(this, 1.0, 60, 10.0f));
        this.bW.a(2, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bW.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bW.a(3, new PathfinderGoalRandomLookaround(this));
        this.bX.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class));
        this.bX.a(2, this.ce);
        this.bX.a(3, this.cf);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cc, false);
    }

    @Override
    protected SoundEffect v() {
        return SoundEffects.Cs;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.Cw;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.Cu;
    }

    public void z(boolean drinking) {
        this.ar().a(cc, drinking);
    }

    public boolean s() {
        return this.ar().a(cc);
    }

    public static AttributeProvider.Builder t() {
        return EntityMonster.gq().a(GenericAttributes.s, 26.0).a(GenericAttributes.v, 0.25);
    }

    @Override
    public void m_() {
        if (!this.dO().B && this.bE()) {
            this.ce.k();
            if (this.ce.i() <= 0) {
                this.cf.a(true);
            } else {
                this.cf.a(false);
            }
            if (this.s()) {
                if (this.cd-- <= 0) {
                    this.z(false);
                    net.minecraft.world.item.ItemStack itemstack = this.eT();
                    this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.l);
                    PotionContents potioncontents = itemstack.a(DataComponents.G);
                    if (itemstack.a(Items.sk)) {
                        WitchConsumePotionEvent event = new WitchConsumePotionEvent((Witch)this.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(itemstack));
                        PotionContents potionContents = potioncontents = event.callEvent() ? CraftItemStack.unwrap(event.getPotion()).a(DataComponents.G) : null;
                    }
                    if (itemstack.a(Items.sk) && potioncontents != null) {
                        potioncontents.a((MobEffect effect) -> this.addEffect((MobEffect)effect, EntityPotionEffectEvent.Cause.ATTACK));
                    }
                    ((Entity)this).a(GameEvent.l);
                    this.f(GenericAttributes.v).c(e.b());
                }
            } else {
                Holder<PotionRegistry> holder = null;
                if (this.ah.i() < 0.15f && ((Entity)this).a(TagsFluid.a) && !this.b(MobEffects.m)) {
                    holder = Potions.w;
                } else if (this.ah.i() < 0.15f && (this.bR() || this.ey() != null && this.ey().a(DamageTypeTags.i)) && !this.b(MobEffects.l)) {
                    holder = Potions.l;
                } else if (this.ah.i() < 0.05f && this.ew() < this.eN()) {
                    holder = Potions.y;
                } else if (this.ah.i() < 0.5f && this.p() != null && !this.b(MobEffects.a) && this.p().g((Entity)this) > 121.0) {
                    holder = Potions.n;
                }
                if (holder != null) {
                    this.setDrinkingPotion(PotionContents.a(Items.sk, holder));
                }
            }
            if (this.ah.i() < 7.5E-4f) {
                this.dO().a((Entity)this, (byte)15);
            }
        }
        super.m_();
    }

    public void setDrinkingPotion(net.minecraft.world.item.ItemStack potion) {
        potion = CraftEventFactory.handleWitchReadyPotionEvent(this, potion);
        this.a(EnumItemSlot.a, potion);
        this.cd = this.eT().a(this);
        this.z(true);
        if (!this.aX()) {
            this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.Cv, this.de(), 1.0f, 0.8f + this.ah.i() * 0.4f);
        }
        AttributeModifiable attributemodifiable = this.f(GenericAttributes.v);
        attributemodifiable.c(b);
        attributemodifiable.b(e);
    }

    @Override
    public SoundEffect ai_() {
        return SoundEffects.Ct;
    }

    @Override
    public void b(byte status) {
        if (status == 15) {
            for (int i2 = 0; i2 < this.ah.a(35) + 10; ++i2) {
                this.dO().a(Particles.an, this.dt() + this.ah.k() * (double)0.13f, this.cK().e + 0.5 + this.ah.k() * (double)0.13f, this.dz() + this.ah.k() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.b(status);
        }
    }

    @Override
    protected float e(DamageSource source, float amount) {
        amount = super.e(source, amount);
        if (source.d() == this) {
            amount = 0.0f;
        }
        if (source.a(DamageTypeTags.k)) {
            amount *= 0.15f;
        }
        return amount;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        if (!this.s()) {
            Vec3D vec3d = target.dr();
            double d0 = target.dt() + vec3d.c - this.dt();
            double d1 = target.dx() - (double)1.1f - this.dv();
            double d2 = target.dz() + vec3d.e - this.dz();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            Holder<PotionRegistry> holder = Potions.A;
            if (target instanceof EntityRaider) {
                holder = target.ew() <= 4.0f ? Potions.y : Potions.F;
                this.h((EntityLiving)null);
            } else if (d3 >= 8.0 && !target.b(MobEffects.b)) {
                holder = Potions.q;
            } else if (target.ew() >= 8.0f && !target.b(MobEffects.s)) {
                holder = Potions.C;
            } else if (d3 <= 3.0 && !target.b(MobEffects.r) && this.ah.i() < 0.25f) {
                holder = Potions.L;
            }
            net.minecraft.world.item.ItemStack potion = PotionContents.a(Items.vo, holder);
            WitchThrowPotionEvent event = new WitchThrowPotionEvent((Witch)this.getBukkitEntity(), (LivingEntity)target.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(potion));
            if (!event.callEvent()) {
                return;
            }
            potion = CraftItemStack.asNMSCopy(event.getPotion());
            EntityPotion entitypotion = new EntityPotion(this.dO(), this);
            entitypotion.a(potion);
            entitypotion.u(entitypotion.dG() - -20.0f);
            entitypotion.c(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
            if (!this.aX()) {
                this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.Cx, this.de(), 1.0f, 0.8f + this.ah.i() * 0.4f);
            }
            this.dO().b(entitypotion);
        }
    }

    @Override
    public void a(WorldServer world, int wave, boolean unused) {
    }

    @Override
    public boolean gl() {
        return false;
    }
}

