/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinArmPose;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityPiglin
extends EntityPiglinAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> cd = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> ce = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cf = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final MinecraftKey cg = MinecraftKey.b("baby");
    private static final AttributeModifier ch = new AttributeModifier(cg, 0.2f, AttributeModifier.Operation.b);
    private static final int ci = 16;
    private static final float cj = 0.35f;
    private static final int ck = 5;
    private static final float cl = 0.1f;
    private static final int cm = 3;
    private static final float cn = 0.2f;
    private static final EntitySize co = EntityTypes.aA.n().a(0.5f).b(0.97f);
    private static final double cp = 0.5;
    public final InventorySubcontainer cq = new InventorySubcontainer(8);
    public boolean cr;
    protected static final ImmutableList<SensorType<? extends Sensor<? super EntityPiglin>>> e = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.f, SensorType.l);
    protected static final ImmutableList<MemoryModuleType<?>> cc = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.v, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.ao, MemoryModuleType.an, MemoryModuleType.L, MemoryModuleType.aP, MemoryModuleType.x, MemoryModuleType.y, (Object[])new MemoryModuleType[]{MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.t, MemoryModuleType.ab, MemoryModuleType.ac, MemoryModuleType.z, MemoryModuleType.ad, MemoryModuleType.ae, MemoryModuleType.ag, MemoryModuleType.af, MemoryModuleType.ai, MemoryModuleType.aj, MemoryModuleType.ah, MemoryModuleType.al, MemoryModuleType.M, MemoryModuleType.ar, MemoryModuleType.s, MemoryModuleType.as, MemoryModuleType.at, MemoryModuleType.ak, MemoryModuleType.am, MemoryModuleType.au, MemoryModuleType.av, MemoryModuleType.aw});
    public Set<Item> allowedBarterItems = new HashSet<Item>();
    public Set<Item> interestItems = new HashSet<Item>();

    public EntityPiglin(EntityTypes<? extends EntityPiglinAbstract> type, World world) {
        super(type, world);
        this.bR = 5;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.o_()) {
            nbt.a("IsBaby", true);
        }
        if (this.cr) {
            nbt.a("CannotHunt", true);
        }
        this.b(nbt, this.dQ());
        NBTTagList barterList = new NBTTagList();
        this.allowedBarterItems.stream().map(BuiltInRegistries.g::b).map(MinecraftKey::toString).map(NBTTagString::a).forEach(barterList::add);
        nbt.a("Bukkit.BarterList", barterList);
        NBTTagList interestList = new NBTTagList();
        this.interestItems.stream().map(BuiltInRegistries.g::b).map(MinecraftKey::toString).map(NBTTagString::a).forEach(interestList::add);
        nbt.a("Bukkit.InterestList", interestList);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(nbt.q("IsBaby"));
        this.z(nbt.q("CannotHunt"));
        this.a(nbt, this.dQ());
        this.allowedBarterItems = nbt.c("Bukkit.BarterList", 8).stream().map(NBTBase::s_).map(MinecraftKey::c).map(BuiltInRegistries.g::a).collect(Collectors.toCollection(HashSet::new));
        this.interestItems = nbt.c("Bukkit.InterestList", 8).stream().map(NBTBase::s_).map(MinecraftKey::c).map(BuiltInRegistries.g::a).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    @VisibleForDebug
    public InventorySubcontainer x() {
        return this.cq;
    }

    @Override
    protected void a(WorldServer world, DamageSource source, boolean causedByPlayer) {
        EntityCreeper entitycreeper;
        super.a(world, source, causedByPlayer);
        Entity entity = source.d();
        if (entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).gl()) {
            ItemStack itemstack = new ItemStack(Items.ur);
            entitycreeper.gm();
            this.b(itemstack);
        }
        this.cq.f().forEach(this::b);
    }

    protected ItemStack n(ItemStack stack) {
        return this.cq.b(stack);
    }

    protected boolean o(ItemStack stack) {
        return this.cq.c(stack);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cd, false);
        builder.a(ce, false);
        builder.a(cf, false);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (cd.equals(data)) {
            this.i_();
        }
    }

    public static AttributeProvider.Builder gr() {
        return EntityMonster.gq().a(GenericAttributes.s, 16.0).a(GenericAttributes.v, 0.35f).a(GenericAttributes.c, 5.0);
    }

    public static boolean b(EntityTypes<EntityPiglin> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return !world.a_(pos.e()).a(Blocks.kK);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData) {
        RandomSource randomsource = world.E_();
        if (spawnReason != EnumMobSpawn.d) {
            if (randomsource.i() < 0.2f) {
                this.a(true);
            } else if (this.gl()) {
                this.a(EnumItemSlot.a, this.gt());
            }
        }
        PiglinAI.a(this, world.E_());
        this.a(randomsource, difficulty);
        this.a(world, randomsource, difficulty);
        return super.a(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected boolean Z() {
        return false;
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.fT();
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        if (this.gl()) {
            this.a(EnumItemSlot.f, new ItemStack(Items.pO), random);
            this.a(EnumItemSlot.e, new ItemStack(Items.pP), random);
            this.a(EnumItemSlot.d, new ItemStack(Items.pQ), random);
            this.a(EnumItemSlot.c, new ItemStack(Items.pR), random);
        }
    }

    private void a(EnumItemSlot slot, ItemStack stack, RandomSource random) {
        if (random.i() < 0.1f) {
            this.a(slot, stack);
        }
    }

    protected BehaviorController.b<EntityPiglin> dU() {
        return BehaviorController.a(cc, e);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return PiglinAI.a(this, this.dU().a(dynamic));
    }

    public BehaviorController<EntityPiglin> dT() {
        return super.dT();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a()) {
            return enuminteractionresult;
        }
        if (!this.dO().B) {
            return PiglinAI.a(this, player, hand);
        }
        boolean flag = PiglinAI.b(this, player.b(hand)) && this.gm() != EntityPiglinArmPose.d;
        return flag ? EnumInteractionResult.a : EnumInteractionResult.e;
    }

    @Override
    public EntitySize e(EntityPose pose) {
        return this.o_() ? co : super.e(pose);
    }

    @Override
    public void a(boolean baby) {
        this.ar().a(cd, baby);
        if (!this.dO().B) {
            AttributeModifiable attributemodifiable = this.f(GenericAttributes.v);
            attributemodifiable.c(ch.b());
            if (baby) {
                attributemodifiable.b(ch);
            }
        }
    }

    @Override
    public boolean o_() {
        return this.ar().a(cd);
    }

    private void z(boolean cannotHunt) {
        this.cr = cannotHunt;
    }

    @Override
    protected boolean s() {
        return !this.cr;
    }

    @Override
    protected void ab() {
        this.dO().ag().a("piglinBrain");
        this.dT().a((WorldServer)this.dO(), this);
        this.dO().ag().c();
        PiglinAI.a(this);
        super.ab();
    }

    @Override
    protected int eg() {
        return this.bR;
    }

    @Override
    protected void a(WorldServer world) {
        PiglinAI.b(this);
        this.forceDrops = true;
        this.cq.f().forEach(this::b);
        this.forceDrops = false;
        super.a(world);
    }

    private ItemStack gt() {
        return (double)this.ah.i() < 0.5 ? new ItemStack(Items.vW) : new ItemStack(Items.oW);
    }

    public boolean gu() {
        return this.ao.a(ce);
    }

    @Override
    public void b(boolean charging) {
        this.ao.a(ce, charging);
    }

    @Override
    public void a() {
        this.bf = 0;
    }

    @Override
    public EntityPiglinArmPose gm() {
        return this.gs() ? EntityPiglinArmPose.e : (PiglinAI.a(this.eU()) ? EntityPiglinArmPose.d : (this.gb() && this.gn() ? EntityPiglinArmPose.a : (this.gu() ? EntityPiglinArmPose.c : (this.gb() && this.b(Items.vW) ? EntityPiglinArmPose.b : EntityPiglinArmPose.f))));
    }

    public boolean gs() {
        return this.ao.a(cf);
    }

    public void y(boolean dancing) {
        this.ao.a(cf, dancing);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag = super.a(source, amount);
        if (this.dO().B) {
            return false;
        }
        if (flag && source.d() instanceof EntityLiving) {
            PiglinAI.a(this, (EntityLiving)source.d());
        }
        return flag;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.b(this, 1.6f);
    }

    @Override
    public boolean a(ItemProjectileWeapon weapon) {
        return weapon == Items.vW;
    }

    protected void p(ItemStack stack) {
        this.b(EnumItemSlot.a, stack);
    }

    protected void q(ItemStack stack) {
        if (stack.a(PiglinAI.c) || this.allowedBarterItems.contains(stack.g())) {
            this.a(EnumItemSlot.b, stack);
            this.e(EnumItemSlot.b);
        } else {
            this.b(EnumItemSlot.b, stack);
        }
    }

    @Override
    public boolean k(ItemStack stack) {
        return this.dO().ab().b(GameRules.c) && this.fS() && PiglinAI.a(this, stack);
    }

    protected boolean r(ItemStack stack) {
        EnumItemSlot enumitemslot = this.h(stack);
        ItemStack itemstack1 = this.a(enumitemslot);
        return this.b(stack, itemstack1);
    }

    @Override
    protected boolean b(ItemStack newStack, ItemStack oldStack) {
        boolean flag1;
        if (EnchantmentManager.a(oldStack, EnchantmentEffectComponents.E)) {
            return false;
        }
        boolean flag = PiglinAI.isLovedItem(newStack, this) || newStack.a(Items.vW);
        boolean bl = flag1 = PiglinAI.isLovedItem(oldStack, this) || oldStack.a(Items.vW);
        return flag && !flag1 ? true : (!flag && flag1 ? false : (this.gl() && !newStack.a(Items.vW) && oldStack.a(Items.vW) ? false : super.b(newStack, oldStack)));
    }

    @Override
    protected void b(EntityItem item) {
        PiglinAI.a(this, item);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        if (this.o_() && entity.am() == EntityTypes.Z) {
            entity = this.b(entity, 3);
        }
        return super.a(entity, force);
    }

    private Entity b(Entity entity, int maxLevel) {
        List<Entity> list = entity.cS();
        return maxLevel != 1 && !list.isEmpty() ? this.b(list.get(0), maxLevel - 1) : entity;
    }

    @Override
    protected SoundEffect v() {
        return this.dO().B ? null : (SoundEffect)PiglinAI.c(this).orElse(null);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.tL;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.tJ;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.tN, 0.15f, 1.0f);
    }

    @Override
    protected void go() {
        this.b(SoundEffects.tO);
    }
}

