/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.player.EntityHuman;

public class AngerManagement {
    @VisibleForTesting
    protected static final int a = 2;
    @VisibleForTesting
    protected static final int b = 150;
    private static final int f = 1;
    private int g = MathHelper.b(RandomSource.a(), 0, 2);
    int h;
    private static final Codec<Pair<UUID, Integer>> i = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.a.fieldOf("uuid").forGetter(Pair::getFirst), (App)ExtraCodecs.k.fieldOf("anger").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    private final Predicate<Entity> j;
    @VisibleForTesting
    protected final ArrayList<Entity> c;
    private final a k;
    @VisibleForTesting
    protected final Object2IntMap<Entity> d;
    @VisibleForTesting
    protected final Object2IntMap<UUID> e;

    public static Codec<AngerManagement> a(Predicate<Entity> suspectPredicate) {
        return RecordCodecBuilder.create(instance -> instance.group((App)i.listOf().fieldOf("suspects").orElse(Collections.emptyList()).forGetter(AngerManagement::b)).apply((Applicative)instance, suspectUuidsToAngerLevel -> new AngerManagement(suspectPredicate, (List<Pair<UUID, Integer>>)suspectUuidsToAngerLevel)));
    }

    public AngerManagement(Predicate<Entity> suspectPredicate, List<Pair<UUID, Integer>> suspectUuidsToAngerLevel) {
        this.j = suspectPredicate;
        this.c = new ArrayList();
        this.k = new a(this);
        this.d = new Object2IntOpenHashMap();
        this.e = new Object2IntOpenHashMap(suspectUuidsToAngerLevel.size());
        suspectUuidsToAngerLevel.forEach(suspect -> this.e.put((Object)((UUID)suspect.getFirst()), (Integer)suspect.getSecond()));
    }

    private List<Pair<UUID, Integer>> b() {
        return Streams.concat((Stream[])new Stream[]{this.c.stream().map(suspect -> Pair.of((Object)suspect.cz(), (Object)this.d.getInt(suspect))), this.e.object2IntEntrySet().stream().map(suspect -> Pair.of((Object)((UUID)suspect.getKey()), (Object)suspect.getIntValue()))}).collect(Collectors.toList());
    }

    public void a(WorldServer world, Predicate<Entity> suspectPredicate) {
        --this.g;
        if (this.g <= 0) {
            this.a(world);
            this.g = 2;
        }
        ObjectIterator objectIterator = this.e.object2IntEntrySet().iterator();
        while (objectIterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)objectIterator.next();
            int i2 = entry.getIntValue();
            if (i2 <= 1) {
                objectIterator.remove();
                continue;
            }
            entry.setValue(i2 - 1);
        }
        ObjectIterator objectIterator2 = this.d.object2IntEntrySet().iterator();
        while (objectIterator2.hasNext()) {
            Object2IntMap.Entry entry2 = (Object2IntMap.Entry)objectIterator2.next();
            int j2 = entry2.getIntValue();
            Entity entity = (Entity)entry2.getKey();
            Entity.RemovalReason removalReason = entity.dK();
            if (j2 > 1 && suspectPredicate.test(entity) && removalReason == null) {
                entry2.setValue(j2 - 1);
                continue;
            }
            this.c.remove(entity);
            objectIterator2.remove();
            if (j2 <= 1 || removalReason == null) continue;
            switch (removalReason) {
                case e: 
                case c: 
                case d: {
                    this.e.put((Object)entity.cz(), j2 - 1);
                }
            }
        }
        this.c();
    }

    private void c() {
        this.h = 0;
        this.c.sort(this.k);
        if (this.c.size() == 1) {
            this.h = this.d.getInt((Object)this.c.get(0));
        }
    }

    private void a(WorldServer world) {
        ObjectIterator objectIterator = this.e.object2IntEntrySet().iterator();
        while (objectIterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)objectIterator.next();
            int i2 = entry.getIntValue();
            Entity entity = world.a((UUID)entry.getKey());
            if (entity == null) continue;
            this.d.put((Object)entity, i2);
            this.c.add(entity);
            objectIterator.remove();
        }
    }

    public int a(Entity entity, int amount) {
        boolean bl = !this.d.containsKey((Object)entity);
        int i2 = this.d.computeInt((Object)entity, (suspect, anger) -> Math.min(150, (anger == null ? 0 : anger) + amount));
        if (bl) {
            int j2 = this.e.removeInt((Object)entity.cz());
            this.d.put((Object)entity, i2 += j2);
            this.c.add(entity);
        }
        this.c();
        return i2;
    }

    public void a(Entity entity) {
        this.d.removeInt((Object)entity);
        this.c.remove(entity);
        this.c();
    }

    @Nullable
    private Entity d() {
        return this.c.stream().filter(this.j).findFirst().orElse(null);
    }

    public int b(@Nullable Entity entity) {
        return entity == null ? this.h : this.d.getInt((Object)entity);
    }

    public Optional<EntityLiving> a() {
        return Optional.ofNullable(this.d()).filter(suspect -> suspect instanceof EntityLiving).map(suspect -> (EntityLiving)suspect);
    }

    @VisibleForTesting
    protected record a(AngerManagement a) implements Comparator<Entity>
    {
        public int a(Entity entity, Entity entity2) {
            boolean bl2;
            if (entity.equals(entity2)) {
                return 0;
            }
            int i2 = this.a.d.getOrDefault((Object)entity, 0);
            int j2 = this.a.d.getOrDefault((Object)entity2, 0);
            this.a.h = Math.max(this.a.h, Math.max(i2, j2));
            boolean bl = AngerLevel.a(i2).d();
            if (bl != (bl2 = AngerLevel.a(j2).d())) {
                return bl ? -1 : 1;
            }
            boolean bl3 = entity instanceof EntityHuman;
            boolean bl4 = entity2 instanceof EntityHuman;
            if (bl3 != bl4) {
                return bl3 ? -1 : 1;
            }
            return Integer.compare(j2, i2);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "angerManagement", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "angerManagement", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "angerManagement", "a"}, this, o2);
        }
    }
}

