/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import io.papermc.paper.event.player.PlayerPurchaseEvent;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMerchantRecipe;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.slf4j.Logger;

public abstract class EntityVillagerAbstract
extends EntityAgeable
implements InventoryCarrier,
NPC,
IMerchant {
    private CraftMerchant craftMerchant;
    private static final DataWatcherObject<Integer> ce = DataWatcher.a(EntityVillagerAbstract.class, DataWatcherRegistry.b);
    private static final Logger cf = LogUtils.getLogger();
    public static final int cc = 300;
    private static final int cg = 8;
    @Nullable
    private EntityHuman ch;
    @Nullable
    protected MerchantRecipeList cd;
    private final InventorySubcontainer ci = new InventorySubcontainer(8, (CraftAbstractVillager)this.getBukkitEntity());

    @Override
    public CraftMerchant getCraftMerchant() {
        return this.craftMerchant == null ? (this.craftMerchant = new CraftMerchant(this)) : this.craftMerchant;
    }

    public EntityVillagerAbstract(EntityTypes<? extends EntityVillagerAbstract> type, World world) {
        super((EntityTypes<? extends EntityAgeable>)type, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(false);
        }
        return super.a(world, difficulty, spawnReason, entityData);
    }

    public int s() {
        return this.ao.a(ce);
    }

    public void s(int ticks) {
        this.ao.a(ce, ticks);
    }

    @Override
    public int t() {
        return 0;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(ce, 0);
    }

    @Override
    public void a(@Nullable EntityHuman customer) {
        this.ch = customer;
    }

    @Override
    @Nullable
    public EntityHuman gk() {
        return this.ch;
    }

    public boolean gl() {
        return this.ch != null;
    }

    public void resetOffers() {
        this.cd = new MerchantRecipeList();
        this.gr();
    }

    @Override
    public MerchantRecipeList gm() {
        if (this.dO().B) {
            throw new IllegalStateException("Cannot load Villager offers on the client");
        }
        if (this.cd == null) {
            this.cd = new MerchantRecipeList();
            this.gr();
        }
        return this.cd;
    }

    @Override
    public void a(@Nullable MerchantRecipeList offers) {
    }

    @Override
    public void t(int experience) {
    }

    @Override
    public void processTrade(MerchantRecipe recipe, @Nullable PlayerPurchaseEvent event) {
        if (event == null || event.willIncreaseTradeUses()) {
            recipe.l();
        }
        if (event == null || event.isRewardingExp()) {
            this.b(recipe);
        }
        this.a(recipe);
    }

    @Override
    public void a(MerchantRecipe offer) {
        this.bQ = -this.R();
        if (this.ch instanceof EntityPlayer) {
            CriterionTriggers.t.a((EntityPlayer)this.ch, this, offer.f());
        }
    }

    protected abstract void b(MerchantRecipe var1);

    @Override
    public boolean gn() {
        return true;
    }

    @Override
    public void n(ItemStack stack) {
        if (!this.dO().B && this.bQ > -this.R() + 20) {
            this.bQ = -this.R();
            this.b(this.x(!stack.e()));
        }
    }

    @Override
    public SoundEffect go() {
        return SoundEffects.AY;
    }

    protected SoundEffect x(boolean sold) {
        return sold ? SoundEffects.AY : SoundEffects.AW;
    }

    public void gp() {
        this.b(SoundEffects.AT);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        MerchantRecipeList merchantrecipelist;
        super.b(nbt);
        if (!this.dO().B && !(merchantrecipelist = this.gm()).isEmpty()) {
            nbt.a("Offers", (NBTBase)MerchantRecipeList.a.encodeStart(this.dQ().a(DynamicOpsNBT.a), (Object)merchantrecipelist).getOrThrow());
        }
        this.b(nbt, this.dQ());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.e("Offers")) {
            DataResult dataresult = MerchantRecipeList.a.parse(this.dQ().a(DynamicOpsNBT.a), (Object)nbt.c("Offers"));
            Logger logger = cf;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(SystemUtils.a("Failed to load offers: ", arg_0 -> ((Logger)logger).warn(arg_0))).ifPresent(merchantrecipelist -> {
                this.cd = merchantrecipelist;
            });
        }
        this.a(nbt, this.dQ());
    }

    @Override
    @Nullable
    public Entity a(DimensionTransition teleportTarget) {
        this.gq();
        return super.a(teleportTarget);
    }

    protected void gq() {
        this.a((EntityHuman)null);
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
        this.gq();
    }

    protected void a(ParticleParam parameters) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d0 = this.ah.k() * 0.02;
            double d1 = this.ah.k() * 0.02;
            double d2 = this.ah.k() * 0.02;
            this.dO().a(parameters, this.d(1.0), this.dw() + 1.0, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public boolean y() {
        return false;
    }

    @Override
    public InventorySubcontainer x() {
        return this.ci;
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        int j2 = mappedIndex - 300;
        return j2 >= 0 && j2 < this.ci.b() ? SlotAccess.a(this.ci, j2) : super.a_(mappedIndex);
    }

    protected abstract void gr();

    protected void a(MerchantRecipeList recipeList, VillagerTrades.IMerchantRecipeOption[] pool, int count) {
        ArrayList arraylist = Lists.newArrayList((Object[])pool);
        int j2 = 0;
        while (j2 < count && !arraylist.isEmpty()) {
            MerchantRecipe merchantrecipe = ((VillagerTrades.IMerchantRecipeOption)arraylist.remove(this.ah.a(arraylist.size()))).a(this, this.ah);
            if (merchantrecipe == null) continue;
            VillagerAcquireTradeEvent event = new VillagerAcquireTradeEvent((AbstractVillager)this.getBukkitEntity(), (org.bukkit.inventory.MerchantRecipe)merchantrecipe.asBukkit());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                CraftMerchantRecipe craftMerchantRecipe = CraftMerchantRecipe.fromBukkit(event.getRecipe());
                if (craftMerchantRecipe.getIngredients().isEmpty()) {
                    return;
                }
                recipeList.add(craftMerchantRecipe.toMinecraft());
            }
            ++j2;
        }
    }

    @Override
    public Vec3D s(float delta) {
        float f1 = MathHelper.i(delta, this.aZ, this.aY) * ((float)Math.PI / 180);
        Vec3D vec3d = new Vec3D(0.0, this.cK().c() - 1.0, 0.2);
        return this.m(delta).e(vec3d.b(-f1));
    }

    @Override
    public boolean gs() {
        return this.dO().B;
    }
}

