/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalInteract;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtTradingPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTradeWithPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalUseItem;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMerchantRecipe;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;

public class EntityVillagerTrader
extends EntityVillagerAbstract {
    private static final int ce = 5;
    @Nullable
    private BlockPosition cf;
    private int cg;
    public boolean canDrinkPotion = true;
    public boolean canDrinkMilk = true;

    public EntityVillagerTrader(EntityTypes<? extends EntityVillagerTrader> type, World world) {
        super((EntityTypes<? extends EntityVillagerAbstract>)type, world);
    }

    @Override
    protected void B() {
        this.bW.a(0, new PathfinderGoalFloat(this));
        this.bW.a(0, new PathfinderGoalUseItem<EntityVillagerTrader>(this, PotionContents.a(Items.sk, Potions.g), SoundEffects.By, entityvillagertrader -> this.canDrinkPotion && this.dO().S() && !entityvillagertrader.ci()));
        this.bW.a(0, new PathfinderGoalUseItem<EntityVillagerTrader>(this, new ItemStack(Items.qE), SoundEffects.BD, entityvillagertrader -> this.canDrinkMilk && this.dO().R() && entityvillagertrader.ci()));
        this.bW.a(1, new PathfinderGoalTradeWithPlayer(this));
        this.bW.a(1, new PathfinderGoalAvoidTarget<EntityZombie>(this, EntityZombie.class, 8.0f, 0.5, 0.5));
        this.bW.a(1, new PathfinderGoalAvoidTarget<EntityEvoker>(this, EntityEvoker.class, 12.0f, 0.5, 0.5));
        this.bW.a(1, new PathfinderGoalAvoidTarget<EntityVindicator>(this, EntityVindicator.class, 8.0f, 0.5, 0.5));
        this.bW.a(1, new PathfinderGoalAvoidTarget<EntityVex>(this, EntityVex.class, 8.0f, 0.5, 0.5));
        this.bW.a(1, new PathfinderGoalAvoidTarget<EntityPillager>(this, EntityPillager.class, 15.0f, 0.5, 0.5));
        this.bW.a(1, new PathfinderGoalAvoidTarget<EntityIllagerIllusioner>(this, EntityIllagerIllusioner.class, 12.0f, 0.5, 0.5));
        this.bW.a(1, new PathfinderGoalAvoidTarget<EntityZoglin>(this, EntityZoglin.class, 10.0f, 0.5, 0.5));
        this.bW.a(1, new PathfinderGoalPanic(this, 0.5));
        this.bW.a(1, new PathfinderGoalLookAtTradingPlayer(this));
        this.bW.a(2, new a(this, 2.0, 0.35));
        this.bW.a(4, new PathfinderGoalMoveTowardsRestriction(this, 0.35));
        this.bW.a(8, new PathfinderGoalRandomStrollLand(this, 0.35));
        this.bW.a(9, new PathfinderGoalInteract(this, EntityHuman.class, 3.0f, 1.0f));
        this.bW.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return null;
    }

    @Override
    public boolean gn() {
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!itemstack.a(Items.tJ) && this.bE() && !this.gl() && !this.o_()) {
            if (hand == EnumHand.a) {
                player.a(StatisticList.S);
            }
            if (!this.dO().B) {
                if (this.gm().isEmpty()) {
                    return EnumInteractionResult.c;
                }
                this.a(player);
                this.a(player, this.S_(), 1);
            }
            return EnumInteractionResult.a(this.dO().B);
        }
        return super.b(player, hand);
    }

    @Override
    protected void gr() {
        if (this.dO().J().b(FeatureFlags.c)) {
            this.gu();
        } else {
            VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption = (VillagerTrades.IMerchantRecipeOption[])VillagerTrades.b.get(1);
            VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption1 = (VillagerTrades.IMerchantRecipeOption[])VillagerTrades.b.get(2);
            if (avillagertrades_imerchantrecipeoption != null && avillagertrades_imerchantrecipeoption1 != null) {
                MerchantRecipeList merchantrecipelist = this.gm();
                this.a(merchantrecipelist, avillagertrades_imerchantrecipeoption, 5);
                int i2 = this.ah.a(avillagertrades_imerchantrecipeoption1.length);
                VillagerTrades.IMerchantRecipeOption villagertrades_imerchantrecipeoption = avillagertrades_imerchantrecipeoption1[i2];
                MerchantRecipe merchantrecipe = villagertrades_imerchantrecipeoption.a(this, this.ah);
                if (merchantrecipe != null) {
                    VillagerAcquireTradeEvent event = new VillagerAcquireTradeEvent((AbstractVillager)this.getBukkitEntity(), (org.bukkit.inventory.MerchantRecipe)merchantrecipe.asBukkit());
                    if (this.valid) {
                        Bukkit.getPluginManager().callEvent((Event)event);
                    }
                    if (!event.isCancelled()) {
                        merchantrecipelist.add(CraftMerchantRecipe.fromBukkit(event.getRecipe()).toMinecraft());
                    }
                }
            }
        }
    }

    private void gu() {
        MerchantRecipeList merchantrecipelist = this.gm();
        for (Pair<VillagerTrades.IMerchantRecipeOption[], Integer> pair : VillagerTrades.d) {
            VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption = (VillagerTrades.IMerchantRecipeOption[])pair.getLeft();
            this.a(merchantrecipelist, avillagertrades_imerchantrecipeoption, (int)((Integer)pair.getRight()));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("DespawnDelay", this.cg);
        if (this.cf != null) {
            nbt.a("wander_target", GameProfileSerializer.a(this.cf));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("DespawnDelay", 99)) {
            this.cg = nbt.h("DespawnDelay");
        }
        GameProfileSerializer.a(nbt, "wander_target").ifPresent(blockposition -> {
            this.cf = blockposition;
        });
        this.c_(Math.max(0, this.g()));
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    protected void b(MerchantRecipe offer) {
        if (offer.u()) {
            int i2 = 3 + this.ah.a(4);
            this.dO().b(new EntityExperienceOrb(this.dO(), this.dt(), this.dv() + 0.5, this.dz(), i2, ExperienceOrb.SpawnReason.VILLAGER_TRADE, this.gk(), this));
        }
    }

    @Override
    protected SoundEffect v() {
        return this.gl() ? SoundEffects.BE : SoundEffects.Bw;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.BB;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.Bx;
    }

    @Override
    protected SoundEffect c(ItemStack stack) {
        return stack.a(Items.qE) ? SoundEffects.Bz : SoundEffects.BA;
    }

    @Override
    protected SoundEffect x(boolean sold) {
        return sold ? SoundEffects.BF : SoundEffects.BC;
    }

    @Override
    public SoundEffect go() {
        return SoundEffects.BF;
    }

    public void u(int despawnDelay) {
        this.cg = despawnDelay;
    }

    public int gt() {
        return this.cg;
    }

    @Override
    public void m_() {
        super.m_();
        if (!this.dO().B) {
            this.gv();
        }
    }

    private void gv() {
        if (this.cg > 0 && !this.gl() && --this.cg == 0) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    public void h(@Nullable BlockPosition wanderTarget) {
        this.cf = wanderTarget;
    }

    @Nullable
    public BlockPosition gx() {
        return this.cf;
    }

    private class a
    extends PathfinderGoal {
        final EntityVillagerTrader a;
        final double b;
        final double c;

        a(EntityVillagerTrader entityvillagertrader, double d0, double d1) {
            this.a = entityvillagertrader;
            this.b = d0;
            this.c = d1;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public void e() {
            this.a.h((BlockPosition)null);
            EntityVillagerTrader.this.bV.n();
        }

        @Override
        public boolean b() {
            BlockPosition blockposition = this.a.gx();
            return blockposition != null && this.a(blockposition, this.b);
        }

        @Override
        public void a() {
            BlockPosition blockposition = this.a.gx();
            if (blockposition != null && EntityVillagerTrader.this.bV.l()) {
                if (this.a(blockposition, 10.0)) {
                    Vec3D vec3d = new Vec3D((double)blockposition.u() - this.a.dt(), (double)blockposition.v() - this.a.dv(), (double)blockposition.w() - this.a.dz()).d();
                    Vec3D vec3d1 = vec3d.a(10.0).b(this.a.dt(), this.a.dv(), this.a.dz());
                    EntityVillagerTrader.this.bV.a(vec3d1.c, vec3d1.d, vec3d1.e, this.c);
                } else {
                    EntityVillagerTrader.this.bV.a((double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w(), this.c);
                }
            }
        }

        private boolean a(BlockPosition pos, double proximityDistance) {
            return !pos.a(this.a.dm(), proximityDistance);
        }
    }
}

