/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.collect.Lists;
import io.papermc.paper.inventory.recipe.StackedContentsExtraMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeItemStack;

public class AutoRecipeStackManager {
    private static final int b = 0;
    public final Int2IntMap a = new Int2IntOpenHashMap();
    @Nullable
    public StackedContentsExtraMap extrasMap = null;

    public void a(ItemStack stack) {
        if (this.extrasMap != null && !stack.d().d() && this.extrasMap.accountStack(stack, Math.min(64, stack.H()))) {
            return;
        }
        if (!(stack.m() || stack.A() || stack.b(DataComponents.g))) {
            this.b(stack);
        }
    }

    public void b(ItemStack stack) {
        this.a(stack, stack.j());
    }

    public void a(ItemStack stack, int maxCount) {
        if (!stack.e()) {
            int i2 = AutoRecipeStackManager.c(stack);
            int j2 = Math.min(maxCount, stack.H());
            if (this.extrasMap != null && !stack.d().d() && this.extrasMap.accountStack(stack, j2)) {
                return;
            }
            this.b(i2, j2);
        }
    }

    public static int c(ItemStack stack) {
        return BuiltInRegistries.g.a(stack.g());
    }

    boolean b(int itemId) {
        return this.a.get(itemId) > 0;
    }

    public int a(int itemId, int count) {
        int i2 = this.a.get(itemId);
        if (i2 >= count) {
            this.a.put(itemId, i2 - count);
            return itemId;
        }
        return 0;
    }

    public void b(int itemId, int count) {
        this.a.put(itemId, this.a.get(itemId) + count);
    }

    public boolean a(IRecipe<?> recipe, @Nullable IntList output) {
        return this.a(recipe, output, 1);
    }

    public boolean a(IRecipe<?> recipe, @Nullable IntList output, int multiplier) {
        return new a(recipe).a(multiplier, output);
    }

    public int a(RecipeHolder<?> recipe, @Nullable IntList output) {
        return this.a(recipe, Integer.MAX_VALUE, output);
    }

    public int a(RecipeHolder<?> recipe, int limit, @Nullable IntList output) {
        return new a((IRecipe<?>)recipe.b()).b(limit, output);
    }

    public static ItemStack a(int itemId) {
        return itemId == 0 ? ItemStack.l : new ItemStack(Item.b(itemId));
    }

    public void initializeExtras(IRecipe<?> recipe, @Nullable CraftingInput input) {
        this.extrasMap = new StackedContentsExtraMap(this, recipe);
        if (input != null) {
            this.extrasMap.accountInput(input);
        }
    }

    public void resetExtras() {
        if (this.extrasMap != null && !this.a.isEmpty()) {
            this.extrasMap.resetExtras();
        }
        this.extrasMap = null;
    }

    public static ItemStack fromStackingIndexWithExtras(int itemId, @Nullable AutoRecipeStackManager contents) {
        if (contents != null && contents.extrasMap != null && itemId >= BuiltInRegistries.g.c()) {
            return AutoRecipeStackManager.fromStackingIndexExtras(itemId, contents.extrasMap);
        }
        return AutoRecipeStackManager.a(itemId);
    }

    public static ItemStack fromStackingIndexExtras(int itemId, StackedContentsExtraMap extrasMap) {
        return extrasMap.getById(itemId).s();
    }

    public void a() {
        this.a.clear();
    }

    class a {
        private final IRecipe<?> b;
        private final List<RecipeItemStack> c = Lists.newArrayList();
        private final int d;
        private final int[] e;
        private final int f;
        private final BitSet g;
        private final IntList h = new IntArrayList();

        public a(IRecipe<?> recipe) {
            this.b = recipe;
            this.c.addAll(recipe.a());
            this.c.removeIf(RecipeItemStack::c);
            this.d = this.c.size();
            this.e = this.a();
            this.f = this.e.length;
            this.g = new BitSet(this.d + this.f + this.d + this.d * this.f);
            for (int i2 = 0; i2 < this.c.size(); ++i2) {
                IntList intList = this.getStackingIds(this.c.get(i2));
                for (int j2 = 0; j2 < this.f; ++j2) {
                    if (!intList.contains(this.e[j2])) continue;
                    this.g.set(this.d(true, j2, i2));
                }
            }
        }

        public boolean a(int multiplier, @Nullable IntList output) {
            boolean bl2;
            if (multiplier <= 0) {
                return true;
            }
            int i2 = 0;
            while (this.a(multiplier)) {
                AutoRecipeStackManager.this.a(this.e[this.h.getInt(0)], multiplier);
                int j2 = this.h.size() - 1;
                this.c(this.h.getInt(j2));
                for (int k2 = 0; k2 < j2; ++k2) {
                    this.c((k2 & 1) == 0, this.h.get(k2), this.h.get(k2 + 1));
                }
                this.h.clear();
                this.g.clear(0, this.d + this.f);
                ++i2;
            }
            boolean bl = i2 == this.d;
            boolean bl3 = bl2 = bl && output != null;
            if (bl2) {
                output.clear();
            }
            this.g.clear(0, this.d + this.f + this.d);
            int l2 = 0;
            for (RecipeItemStack ingredient : this.b.a()) {
                if (bl2 && ingredient.c()) {
                    output.add(0);
                    continue;
                }
                for (int m2 = 0; m2 < this.f; ++m2) {
                    if (!this.b(false, l2, m2)) continue;
                    this.c(true, m2, l2);
                    AutoRecipeStackManager.this.b(this.e[m2], multiplier);
                    if (!bl2) continue;
                    output.add(this.e[m2]);
                }
                ++l2;
            }
            return bl;
        }

        private int[] a() {
            IntAVLTreeSet intCollection = new IntAVLTreeSet();
            for (RecipeItemStack ingredient : this.c) {
                intCollection.addAll((IntCollection)this.getStackingIds(ingredient));
            }
            IntIterator intIterator = intCollection.iterator();
            while (intIterator.hasNext()) {
                if (AutoRecipeStackManager.this.b(intIterator.nextInt())) continue;
                intIterator.remove();
            }
            return intCollection.toIntArray();
        }

        private boolean a(int multiplier) {
            int i2 = this.f;
            for (int j2 = 0; j2 < i2; ++j2) {
                if (AutoRecipeStackManager.this.a.get(this.e[j2]) < multiplier) continue;
                this.a(false, j2);
                while (!this.h.isEmpty()) {
                    int n2;
                    int k2 = this.h.size();
                    boolean bl = (k2 & 1) == 1;
                    int l2 = this.h.getInt(k2 - 1);
                    if (!bl && !this.b(l2)) break;
                    int m2 = bl ? this.d : i2;
                    for (n2 = 0; n2 < m2; ++n2) {
                        if (this.b(bl, n2) || !this.a(bl, l2, n2) || !this.b(bl, l2, n2)) {
                            continue;
                        }
                        this.a(bl, n2);
                        break;
                    }
                    if ((n2 = this.h.size()) != k2) continue;
                    this.h.removeInt(n2 - 1);
                }
                if (this.h.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private boolean b(int itemId) {
            return this.g.get(this.d(itemId));
        }

        private void c(int itemId) {
            this.g.set(this.d(itemId));
        }

        private int d(int itemId) {
            return this.d + this.f + itemId;
        }

        private boolean a(boolean reversed, int itemIndex, int ingredientIndex) {
            return this.g.get(this.d(reversed, itemIndex, ingredientIndex));
        }

        private boolean b(boolean reversed, int itemIndex, int ingredientIndex) {
            return reversed != this.g.get(1 + this.d(reversed, itemIndex, ingredientIndex));
        }

        private void c(boolean reversed, int itemIndex, int ingredientIndex) {
            this.g.flip(1 + this.d(reversed, itemIndex, ingredientIndex));
        }

        private int d(boolean reversed, int itemIndex, int ingredientIndex) {
            int i2 = reversed ? itemIndex * this.d + ingredientIndex : ingredientIndex * this.d + itemIndex;
            return this.d + this.f + this.d + 2 * i2;
        }

        private void a(boolean reversed, int itemId) {
            this.g.set(this.c(reversed, itemId));
            this.h.add(itemId);
        }

        private boolean b(boolean reversed, int itemId) {
            return this.g.get(this.c(reversed, itemId));
        }

        private int c(boolean reversed, int itemId) {
            return (reversed ? 0 : this.d) + itemId;
        }

        public int b(int minimum, @Nullable IntList output) {
            int i2 = 0;
            int j2 = Math.min(minimum, this.b()) + 1;
            while (true) {
                int k2;
                if (this.a(k2 = (i2 + j2) / 2, null)) {
                    if (j2 - i2 <= 1) {
                        if (k2 > 0) {
                            this.a(k2, output);
                        }
                        return k2;
                    }
                    i2 = k2;
                    continue;
                }
                j2 = k2;
            }
        }

        private int b() {
            int i2 = Integer.MAX_VALUE;
            for (RecipeItemStack ingredient : this.c) {
                int j2 = 0;
                IntListIterator intListIterator = this.getStackingIds(ingredient).iterator();
                while (intListIterator.hasNext()) {
                    int k2 = (Integer)intListIterator.next();
                    j2 = Math.max(j2, AutoRecipeStackManager.this.a.get(k2));
                }
                if (i2 <= 0) continue;
                i2 = Math.min(i2, j2);
            }
            return i2;
        }

        private IntList getStackingIds(RecipeItemStack ingredient) {
            IntList ids;
            if (AutoRecipeStackManager.this.extrasMap != null && (ids = AutoRecipeStackManager.this.extrasMap.extraStackingIds.get(ingredient)) != null) {
                return ids;
            }
            return ingredient.b();
        }
    }
}

