/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class Item
implements FeatureElement,
IMaterial {
    private static final Logger a = LogUtils.getLogger();
    public static final Map<Block, Item> d = Maps.newHashMap();
    public static final MinecraftKey e = MinecraftKey.b("base_attack_damage");
    public static final MinecraftKey f = MinecraftKey.b("base_attack_speed");
    public static final int g = 64;
    public static final int h = 99;
    public static final int i = 13;
    private final Holder.c<Item> b = BuiltInRegistries.g.f(this);
    private final DataComponentMap c;
    @Nullable
    private final Item j;
    @Nullable
    private String k;
    private final FeatureFlagSet l;

    public static int a(Item item) {
        return item == null ? 0 : BuiltInRegistries.g.a(item);
    }

    public static Item b(int id) {
        return BuiltInRegistries.g.a(id);
    }

    @Deprecated
    public static Item a(Block block) {
        return d.getOrDefault(block, Items.a);
    }

    public Item(Info settings) {
        String string;
        this.c = settings.b();
        this.j = settings.c;
        this.l = settings.d;
        if (SharedConstants.aV && !(string = this.getClass().getSimpleName()).endsWith("Item")) {
            a.error("Item classes should end with Item and {} doesn't.", (Object)string);
        }
    }

    @Deprecated
    public Holder.c<Item> o() {
        return this.b;
    }

    public DataComponentMap p() {
        return this.c;
    }

    public int q() {
        return this.c.a(DataComponents.c, 1);
    }

    public void a(World world, EntityLiving user, ItemStack stack, int remainingUseTicks) {
    }

    public void a(EntityItem entity) {
    }

    public void m(ItemStack stack) {
    }

    public boolean a(IBlockData state, World world, BlockPosition pos, EntityHuman miner) {
        return true;
    }

    @Override
    @Override
    public Item r() {
        return this;
    }

    public EnumInteractionResult a(ItemActionContext context) {
        return EnumInteractionResult.e;
    }

    public float a(ItemStack stack, IBlockData state) {
        Tool tool = stack.a(DataComponents.x);
        return tool != null ? tool.a(state) : 1.0f;
    }

    public InteractionResultWrapper<ItemStack> a(World world, EntityHuman user, EnumHand hand) {
        ItemStack itemStack = user.b(hand);
        FoodInfo foodProperties = itemStack.a(DataComponents.v);
        if (foodProperties != null) {
            if (user.u(foodProperties.d())) {
                user.c(hand);
                return InteractionResultWrapper.b(itemStack);
            }
            return InteractionResultWrapper.d(itemStack);
        }
        return InteractionResultWrapper.c(user.b(hand));
    }

    public ItemStack a(ItemStack stack, World world, EntityLiving user) {
        FoodInfo foodProperties = stack.a(DataComponents.v);
        if (foodProperties != null) {
            return user.a(world, stack, foodProperties);
        }
        return stack;
    }

    public boolean d(ItemStack stack) {
        return stack.m();
    }

    public int e(ItemStack stack) {
        return MathHelper.a(Math.round(13.0f - (float)stack.n() * 13.0f / (float)stack.o()), 0, 13);
    }

    public int f(ItemStack stack) {
        int i2 = stack.o();
        float f2 = Math.max(0.0f, ((float)i2 - (float)stack.n()) / (float)i2);
        return MathHelper.h(f2 / 3.0f, 1.0f, 1.0f);
    }

    public boolean a(ItemStack stack, Slot slot, ClickAction clickType, EntityHuman player) {
        return false;
    }

    public boolean a(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, EntityHuman player, SlotAccess cursorStackReference) {
        return false;
    }

    public float a(Entity target, float baseAttackDamage, DamageSource damageSource) {
        return 0.0f;
    }

    public boolean a(ItemStack stack, EntityLiving target, EntityLiving attacker) {
        return false;
    }

    public void b(ItemStack stack, EntityLiving target, EntityLiving attacker) {
    }

    public boolean a(ItemStack stack, World world, IBlockData state, BlockPosition pos, EntityLiving miner) {
        Tool tool = stack.a(DataComponents.x);
        if (tool == null) {
            return false;
        }
        if (!world.B && state.h(world, pos) != 0.0f && tool.c() > 0) {
            stack.a(tool.c(), miner, EnumItemSlot.a);
        }
        return true;
    }

    public boolean b(ItemStack stack, IBlockData state) {
        Tool tool = stack.a(DataComponents.x);
        return tool != null && tool.b(state);
    }

    public EnumInteractionResult a(ItemStack stack, EntityHuman user, EntityLiving entity, EnumHand hand) {
        return EnumInteractionResult.e;
    }

    public IChatBaseComponent s() {
        return IChatBaseComponent.c(this.a());
    }

    @Override
    public String toString() {
        return BuiltInRegistries.g.e(this).g();
    }

    protected String t() {
        if (this.k == null) {
            this.k = SystemUtils.a("item", BuiltInRegistries.g.b(this));
        }
        return this.k;
    }

    public String a() {
        return this.t();
    }

    public String h(ItemStack stack) {
        return this.a();
    }

    @Nullable
    public final Item u() {
        return this.j;
    }

    public boolean v() {
        return this.j != null;
    }

    public void a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
    }

    public void b(ItemStack stack, World world, EntityHuman player) {
        this.a(stack, world);
    }

    public void a(ItemStack stack, World world) {
    }

    public boolean ao_() {
        return false;
    }

    public EnumAnimation b(ItemStack stack) {
        return stack.b(DataComponents.v) ? EnumAnimation.b : EnumAnimation.a;
    }

    public int a(ItemStack stack, EntityLiving user) {
        FoodInfo foodProperties = stack.a(DataComponents.v);
        if (foodProperties != null) {
            return foodProperties.a();
        }
        return 0;
    }

    public void a(ItemStack stack, World world, EntityLiving user, int remainingUseTicks) {
    }

    public void a(ItemStack stack, b context, List<IChatBaseComponent> tooltip, TooltipFlag type) {
    }

    public Optional<TooltipComponent> g(ItemStack stack) {
        return Optional.empty();
    }

    public IChatBaseComponent n(ItemStack stack) {
        return IChatBaseComponent.c(this.h(stack));
    }

    public boolean d_(ItemStack stack) {
        return stack.A();
    }

    public boolean a(ItemStack stack) {
        return stack.j() == 1 && stack.b(DataComponents.d);
    }

    protected static MovingObjectPositionBlock a(World world, EntityHuman player, RayTrace.FluidCollisionOption fluidHandling) {
        Vec3D vec3 = player.by();
        Vec3D vec32 = vec3.e(player.c(player.dG(), player.dE()).a(player.gy()));
        return world.a(new RayTrace(vec3, vec32, RayTrace.BlockCollisionOption.b, fluidHandling, player));
    }

    public int g() {
        return 0;
    }

    public boolean a(ItemStack stack, ItemStack ingredient) {
        return false;
    }

    @Deprecated
    public ItemAttributeModifiers j() {
        return ItemAttributeModifiers.a;
    }

    public boolean l(ItemStack stack) {
        return false;
    }

    public ItemStack w() {
        return new ItemStack(this);
    }

    public SoundEffect ap_() {
        return SoundEffects.kc;
    }

    public SoundEffect aq_() {
        return SoundEffects.kd;
    }

    public SoundEffect e() {
        return SoundEffects.nB;
    }

    public boolean ar_() {
        return true;
    }

    @Override
    @Override
    public FeatureFlagSet i() {
        return this.l;
    }

    public static class Info {
        private static final Interner<DataComponentMap> a = Interners.newStrongInterner();
        @Nullable
        private DataComponentMap.a b;
        @Nullable
        Item c;
        FeatureFlagSet d = FeatureFlags.f;

        public Info a(FoodInfo foodComponent) {
            return this.a(DataComponents.v, foodComponent);
        }

        public Info a(int maxCount) {
            return this.a(DataComponents.c, maxCount);
        }

        public Info b(int maxDamage) {
            this.a(DataComponents.d, maxDamage);
            this.a(DataComponents.c, 1);
            this.a(DataComponents.e, 0);
            return this;
        }

        public Info a(Item recipeRemainder) {
            this.c = recipeRemainder;
            return this;
        }

        public Info a(EnumItemRarity rarity) {
            return this.a(DataComponents.j, rarity);
        }

        public Info a() {
            return this.a(DataComponents.w, Unit.a);
        }

        public Info a(ResourceKey<JukeboxSong> songKey) {
            return this.a(DataComponents.R, new JukeboxPlayable(new EitherHolder<JukeboxSong>(songKey), true));
        }

        public Info a(FeatureFlag ... features) {
            this.d = FeatureFlags.d.a(features);
            return this;
        }

        public <T> Info a(DataComponentType<T> type, T value) {
            if (this.b == null) {
                this.b = DataComponentMap.a().a(DataComponents.ag);
            }
            this.b.a(type, value);
            return this;
        }

        public Info a(ItemAttributeModifiers attributeModifiersComponent) {
            return this.a(DataComponents.n, attributeModifiersComponent);
        }

        DataComponentMap b() {
            DataComponentMap dataComponentMap = this.c();
            if (dataComponentMap.b(DataComponents.e) && dataComponentMap.a(DataComponents.c, 1) > 1) {
                throw new IllegalStateException("Item cannot have both durability and be stackable");
            }
            return dataComponentMap;
        }

        private DataComponentMap c() {
            if (this.b == null) {
                return DataComponents.ag;
            }
            return (DataComponentMap)a.intern((Object)this.b.a());
        }
    }

    public static interface b {
        public static final b a = new b(){

            @Override
            @Nullable
            @Override
            public HolderLookup.a a() {
                return null;
            }

            @Override
            @Override
            public float b() {
                return 20.0f;
            }

            @Override
            @Nullable
            @Override
            public WorldMap a(MapId mapIdComponent) {
                return null;
            }
        };

        @Nullable
        public HolderLookup.a a();

        public float b();

        @Nullable
        public WorldMap a(MapId var1);

        public static b a(final @Nullable World world) {
            if (world == null) {
                return a;
            }
            return new b(){

                @Override
                @Override
                public HolderLookup.a a() {
                    return world.H_();
                }

                @Override
                @Override
                public float b() {
                    return world.s().f();
                }

                @Override
                @Override
                public WorldMap a(MapId mapIdComponent) {
                    return world.a(mapIdComponent);
                }
            };
        }

        public static b a(final HolderLookup.a registryLookup) {
            return new b(){

                @Override
                @Override
                public HolderLookup.a a() {
                    return registryLookup;
                }

                @Override
                @Override
                public float b() {
                    return 20.0f;
                }

                @Override
                @Nullable
                @Override
                public WorldMap a(MapId mapIdComponent) {
                    return null;
                }
            };
        }
    }
}

