/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ColorUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public record PotionContents(Optional<Holder<PotionRegistry>> d, Optional<Integer> e, List<MobEffect> f) {
    private final Optional<Holder<PotionRegistry>> d;
    private final Optional<Integer> e;
    private final List<MobEffect> f;
    public static final PotionContents a = new PotionContents(Optional.empty(), Optional.empty(), List.of());
    private static final IChatBaseComponent g = IChatBaseComponent.c("effect.none").a(EnumChatFormat.h);
    private static final int h = -13083194;
    private static final Codec<PotionContents> i = RecordCodecBuilder.create(instance -> instance.group((App)PotionRegistry.a.optionalFieldOf("potion").forGetter(PotionContents::e), (App)Codec.INT.optionalFieldOf("custom_color").forGetter(PotionContents::f), (App)MobEffect.d.listOf().optionalFieldOf("custom_effects", List.of()).forGetter(PotionContents::d)).apply((Applicative)instance, PotionContents::new));
    public static final Codec<PotionContents> b = Codec.withAlternative(i, PotionRegistry.a, PotionContents::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, PotionContents> c = StreamCodec.a(PotionRegistry.b.a(ByteBufCodecs::a), PotionContents::e, ByteBufCodecs.f.a(ByteBufCodecs::a), PotionContents::f, MobEffect.e.a(ByteBufCodecs.a()), PotionContents::d, PotionContents::new);

    public PotionContents(Holder<PotionRegistry> potion) {
        this(Optional.of(potion), Optional.empty(), List.of());
    }

    public static ItemStack a(Item item, Holder<PotionRegistry> potion) {
        ItemStack itemStack = new ItemStack(item);
        itemStack.b(DataComponents.G, new PotionContents(potion));
        return itemStack;
    }

    public boolean a(Holder<PotionRegistry> potion) {
        return this.d.isPresent() && this.d.get().a(potion) && this.f.isEmpty();
    }

    public Iterable<MobEffect> a() {
        if (this.d.isEmpty()) {
            return this.f;
        }
        if (this.f.isEmpty()) {
            return this.d.get().a().a();
        }
        return Iterables.concat(this.d.get().a().a(), this.f);
    }

    public void a(Consumer<MobEffect> effectConsumer) {
        if (this.d.isPresent()) {
            for (MobEffect mobEffectInstance : this.d.get().a().a()) {
                effectConsumer.accept(new MobEffect(mobEffectInstance));
            }
        }
        for (MobEffect mobEffectInstance2 : this.f) {
            effectConsumer.accept(new MobEffect(mobEffectInstance2));
        }
    }

    public PotionContents b(Holder<PotionRegistry> potion) {
        return new PotionContents(Optional.of(potion), this.e, this.f);
    }

    public PotionContents a(MobEffect customEffect) {
        return new PotionContents(this.d, this.e, SystemUtils.a(this.f, customEffect));
    }

    public int b() {
        if (this.e.isPresent()) {
            return this.e.get();
        }
        return PotionContents.a(this.a());
    }

    public static int c(Holder<PotionRegistry> potion) {
        return PotionContents.a(potion.a().a());
    }

    public static int a(Iterable<MobEffect> effects) {
        return PotionContents.b(effects).orElse(-13083194);
    }

    public static OptionalInt b(Iterable<MobEffect> effects) {
        int i2 = 0;
        int j2 = 0;
        int k2 = 0;
        int l2 = 0;
        for (MobEffect mobEffectInstance : effects) {
            if (!mobEffectInstance.g()) continue;
            int m2 = mobEffectInstance.c().a().g();
            int n2 = mobEffectInstance.e() + 1;
            i2 += n2 * ColorUtil.b.b(m2);
            j2 += n2 * ColorUtil.b.c(m2);
            k2 += n2 * ColorUtil.b.d(m2);
            l2 += n2;
        }
        if (l2 == 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(ColorUtil.b.a(i2 / l2, j2 / l2, k2 / l2));
    }

    public boolean c() {
        if (!this.f.isEmpty()) {
            return true;
        }
        return this.d.isPresent() && !this.d.get().a().a().isEmpty();
    }

    public List<MobEffect> d() {
        return Lists.transform(this.f, MobEffect::new);
    }

    public void a(Consumer<IChatBaseComponent> textConsumer, float durationMultiplier, float tickRate) {
        PotionContents.a(this.a(), textConsumer, durationMultiplier, tickRate);
    }

    public static void a(Iterable<MobEffect> effects, Consumer<IChatBaseComponent> textConsumer, float durationMultiplier, float tickRate) {
        ArrayList list = Lists.newArrayList();
        boolean bl = true;
        for (MobEffect mobEffectInstance : effects) {
            bl = false;
            IChatMutableComponent mutableComponent = IChatBaseComponent.c(mobEffectInstance.i());
            Holder<MobEffectList> holder = mobEffectInstance.c();
            holder.a().a(mobEffectInstance.e(), (attribute, modifier) -> list.add(new Pair(attribute, modifier)));
            if (mobEffectInstance.e() > 0) {
                mutableComponent = IChatBaseComponent.a("potion.withAmplifier", mutableComponent, IChatBaseComponent.c("potion.potency." + mobEffectInstance.e()));
            }
            if (!mobEffectInstance.a(20)) {
                mutableComponent = IChatBaseComponent.a("potion.withDuration", mutableComponent, MobEffectUtil.a(mobEffectInstance, durationMultiplier, tickRate));
            }
            textConsumer.accept(mutableComponent.a(holder.a().f().a()));
        }
        if (bl) {
            textConsumer.accept(g);
        }
        if (!list.isEmpty()) {
            textConsumer.accept(CommonComponents.a);
            textConsumer.accept(IChatBaseComponent.c("potion.whenDrank").a(EnumChatFormat.f));
            for (Pair pair : list) {
                double f2;
                AttributeModifier attributeModifier = (AttributeModifier)pair.getSecond();
                double d2 = attributeModifier.c();
                if (attributeModifier.d() == AttributeModifier.Operation.b || attributeModifier.d() == AttributeModifier.Operation.c) {
                    double e2 = attributeModifier.c() * 100.0;
                } else {
                    f2 = attributeModifier.c();
                }
                if (d2 > 0.0) {
                    textConsumer.accept(IChatBaseComponent.a("attribute.modifier.plus." + attributeModifier.d().a(), new Object[]{ItemAttributeModifiers.d.format(f2), IChatBaseComponent.c(((AttributeBase)((Holder)pair.getFirst()).a()).c())}).a(EnumChatFormat.j));
                    continue;
                }
                if (!(d2 < 0.0)) continue;
                textConsumer.accept(IChatBaseComponent.a("attribute.modifier.take." + attributeModifier.d().a(), new Object[]{ItemAttributeModifiers.d.format(f2 *= -1.0), IChatBaseComponent.c(((AttributeBase)((Holder)pair.getFirst()).a()).c())}).a(EnumChatFormat.m));
            }
        }
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{PotionContents.class, "potion;customColor;customEffects", "d", "e", "f"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PotionContents.class, "potion;customColor;customEffects", "d", "e", "f"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PotionContents.class, "potion;customColor;customEffects", "d", "e", "f"}, this, object);
    }

    public Optional<Holder<PotionRegistry>> e() {
        return this.d;
    }

    public Optional<Integer> f() {
        return this.e;
    }
}

