/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeItemStack;

public final class ShapedRecipePattern {
    private static final int c = 3;
    public static final MapCodec<ShapedRecipePattern> a = net.minecraft.world.item.crafting.ShapedRecipePattern$a.a.flatXmap(ShapedRecipePattern::a, recipe -> recipe.g.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShapedRecipePattern> b = StreamCodec.a(ShapedRecipePattern::a, ShapedRecipePattern::b);
    private final int d;
    private final int e;
    private final NonNullList<RecipeItemStack> f;
    private final Optional<a> g;
    private final int h;
    private final boolean i;

    public ShapedRecipePattern(int width, int height, NonNullList<RecipeItemStack> ingredients, Optional<a> data) {
        this.d = width;
        this.e = height;
        this.f = ingredients;
        this.g = data;
        int i2 = 0;
        for (RecipeItemStack ingredient : ingredients) {
            if (ingredient.c()) continue;
            ++i2;
        }
        this.h = i2;
        this.i = SystemUtils.a(width, height, ingredients);
    }

    public static ShapedRecipePattern a(Map<Character, RecipeItemStack> key, String ... pattern) {
        return ShapedRecipePattern.a(key, List.of(pattern));
    }

    public static ShapedRecipePattern a(Map<Character, RecipeItemStack> key, List<String> pattern) {
        a data = new a(key, pattern);
        return (ShapedRecipePattern)ShapedRecipePattern.a(data).getOrThrow();
    }

    private static DataResult<ShapedRecipePattern> a(a data) {
        String[] strings = ShapedRecipePattern.a(data.c);
        int i2 = strings[0].length();
        int j2 = strings.length;
        NonNullList<RecipeItemStack> nonNullList = NonNullList.a(i2 * j2, RecipeItemStack.a);
        CharArraySet charSet = new CharArraySet(data.b.keySet());
        for (int k2 = 0; k2 < strings.length; ++k2) {
            String string = strings[k2];
            for (int l2 = 0; l2 < string.length(); ++l2) {
                RecipeItemStack ingredient;
                char c2 = string.charAt(l2);
                RecipeItemStack recipeItemStack = ingredient = c2 == ' ' ? RecipeItemStack.a : data.b.get(Character.valueOf(c2));
                if (ingredient == null) {
                    return DataResult.error(() -> "Pattern references symbol '" + c2 + "' but it's not defined in the key");
                }
                charSet.remove(c2);
                nonNullList.set(l2 + i2 * k2, ingredient);
            }
        }
        if (!charSet.isEmpty()) {
            return DataResult.error(() -> ShapedRecipePattern.a((CharSet)charSet));
        }
        return DataResult.success((Object)new ShapedRecipePattern(i2, j2, nonNullList, Optional.of(data)));
    }

    @VisibleForTesting
    static String[] a(List<String> pattern) {
        int i2 = Integer.MAX_VALUE;
        int j2 = 0;
        int k2 = 0;
        int l2 = 0;
        for (int m2 = 0; m2 < pattern.size(); ++m2) {
            String string = pattern.get(m2);
            i2 = Math.min(i2, ShapedRecipePattern.a(string));
            int n2 = ShapedRecipePattern.b(string);
            j2 = Math.max(j2, n2);
            if (n2 < 0) {
                if (k2 == m2) {
                    ++k2;
                }
                ++l2;
                continue;
            }
            l2 = 0;
        }
        if (pattern.size() == l2) {
            return new String[0];
        }
        String[] strings = new String[pattern.size() - l2 - k2];
        for (int o2 = 0; o2 < strings.length; ++o2) {
            strings[o2] = pattern.get(o2 + k2).substring(i2, j2 + 1);
        }
        return strings;
    }

    private static int a(String line) {
        int i2;
        for (i2 = 0; i2 < line.length() && line.charAt(i2) == ' '; ++i2) {
        }
        return i2;
    }

    private static int b(String line) {
        int i2;
        for (i2 = line.length() - 1; i2 >= 0 && line.charAt(i2) == ' '; --i2) {
        }
        return i2;
    }

    public boolean a(CraftingInput input) {
        if (input.e() != this.h) {
            return false;
        }
        if (input.f() == this.d && input.g() == this.e) {
            if (!this.i && this.a(input, true)) {
                return true;
            }
            if (this.a(input, false)) {
                return true;
            }
        }
        return false;
    }

    private boolean a(CraftingInput input, boolean mirrored) {
        for (int i2 = 0; i2 < this.e; ++i2) {
            for (int j2 = 0; j2 < this.d; ++j2) {
                RecipeItemStack ingredient2;
                if (mirrored) {
                    RecipeItemStack ingredient = this.f.get(this.d - j2 - 1 + i2 * this.d);
                } else {
                    ingredient2 = this.f.get(j2 + i2 * this.d);
                }
                ItemStack itemStack = input.a(j2, i2);
                if (ingredient2.a(itemStack)) continue;
                return false;
            }
        }
        return true;
    }

    private void a(RegistryFriendlyByteBuf buf) {
        buf.c(this.d);
        buf.c(this.e);
        for (RecipeItemStack ingredient : this.f) {
            RecipeItemStack.b.encode(buf, ingredient);
        }
    }

    private static ShapedRecipePattern b(RegistryFriendlyByteBuf buf) {
        int i2 = buf.l();
        int j2 = buf.l();
        NonNullList<RecipeItemStack> nonNullList = NonNullList.a(i2 * j2, RecipeItemStack.a);
        nonNullList.replaceAll(ingredient -> (RecipeItemStack)RecipeItemStack.b.decode(buf));
        return new ShapedRecipePattern(i2, j2, nonNullList, Optional.empty());
    }

    public int a() {
        return this.d;
    }

    public int b() {
        return this.e;
    }

    public NonNullList<RecipeItemStack> c() {
        return this.f;
    }

    private static /* synthetic */ String a(CharSet charSet) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(charSet);
    }

    public static final class a
    extends Record {
        private final Map<Character, RecipeItemStack> b;
        private final List<String> c;
        private static final Codec<List<String>> d = Codec.STRING.listOf().comapFlatMap(pattern -> {
            if (pattern.size() > 3) {
                return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
            }
            if (pattern.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int i2 = ((String)pattern.getFirst()).length();
            for (String string : pattern) {
                if (string.length() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                }
                if (i2 == string.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)pattern);
        }, Function.identity());
        private static final Codec<Character> e = Codec.STRING.comapFlatMap(keyEntry -> {
            if (keyEntry.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + keyEntry + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(keyEntry)) {
                return DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.");
            }
            return DataResult.success((Object)Character.valueOf(keyEntry.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<a> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.b(e, RecipeItemStack.d).fieldOf("key").forGetter(data -> data.b), (App)d.fieldOf("pattern").forGetter(data -> data.c)).apply((Applicative)instance, a::new));

        public a(Map<Character, RecipeItemStack> map, List<String> list) {
            this.b = map;
            this.c = list;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "key;pattern", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "key;pattern", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "key;pattern", "b", "c"}, this, object);
        }

        public Map<Character, RecipeItemStack> a() {
            return this.b;
        }

        public List<String> b() {
            return this.c;
        }
    }
}

