/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom2;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;

public class EnchantmentManager {
    public static int a(Holder<Enchantment> enchantment, ItemStack stack) {
        ItemEnchantments itemEnchantments = stack.a(DataComponents.k, ItemEnchantments.a);
        return itemEnchantments.a(enchantment);
    }

    public static ItemEnchantments a(ItemStack stack, Consumer<ItemEnchantments.a> applier) {
        DataComponentType<ItemEnchantments> dataComponentType = EnchantmentManager.d(stack);
        ItemEnchantments itemEnchantments = stack.a(dataComponentType);
        if (itemEnchantments == null) {
            return ItemEnchantments.a;
        }
        ItemEnchantments.a mutable = new ItemEnchantments.a(itemEnchantments);
        applier.accept(mutable);
        ItemEnchantments itemEnchantments2 = mutable.b();
        stack.b(dataComponentType, itemEnchantments2);
        return itemEnchantments2;
    }

    public static boolean a(ItemStack stack) {
        return stack.b(EnchantmentManager.d(stack));
    }

    public static void a(ItemStack stack, ItemEnchantments enchantments) {
        stack.b(EnchantmentManager.d(stack), enchantments);
    }

    public static ItemEnchantments b(ItemStack stack) {
        return stack.a(EnchantmentManager.d(stack), ItemEnchantments.a);
    }

    private static DataComponentType<ItemEnchantments> d(ItemStack stack) {
        return stack.a(Items.uw) ? DataComponents.y : DataComponents.k;
    }

    public static boolean c(ItemStack stack) {
        return !stack.a(DataComponents.k, ItemEnchantments.a).d() || !stack.a(DataComponents.y, ItemEnchantments.a).d();
    }

    public static int a(WorldServer world, ItemStack stack, int baseItemDamage) {
        MutableFloat mutableFloat = new MutableFloat((float)baseItemDamage);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).a(world, level, stack, mutableFloat));
        return mutableFloat.intValue();
    }

    public static int a(WorldServer world, ItemStack rangedWeaponStack, ItemStack projectileStack, int baseAmmoUse) {
        MutableFloat mutableFloat = new MutableFloat((float)baseAmmoUse);
        EnchantmentManager.a(rangedWeaponStack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).b(world, level, projectileStack, mutableFloat));
        return mutableFloat.intValue();
    }

    public static int b(WorldServer world, ItemStack stack, int baseBlockExperience) {
        MutableFloat mutableFloat = new MutableFloat((float)baseBlockExperience);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).d(world, level, stack, mutableFloat));
        return mutableFloat.intValue();
    }

    public static int a(WorldServer world, @Nullable Entity attacker, Entity mob, int baseMobExperience) {
        if (attacker instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)attacker;
            MutableFloat mutableFloat = new MutableFloat((float)baseMobExperience);
            EnchantmentManager.a(livingEntity, (Holder<Enchantment> enchantment, int level, EnchantedItemInUse context) -> ((Enchantment)enchantment.a()).a(world, level, context.a(), mob, mutableFloat));
            return mutableFloat.intValue();
        }
        return baseMobExperience;
    }

    private static void a(ItemStack stack, b consumer) {
        ItemEnchantments itemEnchantments = stack.a(DataComponents.k, ItemEnchantments.a);
        for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemEnchantments.b()) {
            consumer.accept((Holder)entry.getKey(), entry.getIntValue());
        }
    }

    private static void a(ItemStack stack, EnumItemSlot slot, EntityLiving entity, a contextAwareConsumer) {
        if (stack.e()) {
            return;
        }
        ItemEnchantments itemEnchantments = stack.a(DataComponents.k);
        if (itemEnchantments == null || itemEnchantments.d()) {
            return;
        }
        EnchantedItemInUse enchantedItemInUse = new EnchantedItemInUse(stack, slot, entity);
        for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemEnchantments.b()) {
            Holder holder = (Holder)entry.getKey();
            if (!((Enchantment)holder.a()).a(slot)) continue;
            contextAwareConsumer.accept(holder, entry.getIntValue(), enchantedItemInUse);
        }
    }

    private static void a(EntityLiving entity, a contextAwareConsumer) {
        for (EnumItemSlot equipmentSlot : EnumItemSlot.values()) {
            EnchantmentManager.a(entity.a(equipmentSlot), equipmentSlot, entity, contextAwareConsumer);
        }
    }

    public static boolean a(WorldServer world, EntityLiving user, DamageSource damageSource) {
        MutableBoolean mutableBoolean = new MutableBoolean();
        EnchantmentManager.a(user, (Holder<Enchantment> enchantment, int level, EnchantedItemInUse context) -> mutableBoolean.setValue(mutableBoolean.isTrue() || ((Enchantment)enchantment.a()).a(world, level, user, damageSource)));
        return mutableBoolean.isTrue();
    }

    public static float b(WorldServer world, EntityLiving user, DamageSource damageSource) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentManager.a(user, (Holder<Enchantment> enchantment, int level, EnchantedItemInUse context) -> ((Enchantment)enchantment.a()).a(world, level, context.a(), (Entity)user, damageSource, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float a(WorldServer world, ItemStack stack, Entity target, DamageSource damageSource, float baseDamage) {
        MutableFloat mutableFloat = new MutableFloat(baseDamage);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).b(world, level, stack, target, damageSource, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float b(WorldServer world, ItemStack stack, Entity target, DamageSource damageSource, float baseSmashDamagePerFallenBlock) {
        MutableFloat mutableFloat = new MutableFloat(baseSmashDamagePerFallenBlock);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).c(world, level, stack, target, damageSource, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float c(WorldServer world, ItemStack stack, Entity user, DamageSource damageSource, float baseArmorEffectiveness) {
        MutableFloat mutableFloat = new MutableFloat(baseArmorEffectiveness);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).e(world, level, stack, user, damageSource, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float d(WorldServer world, ItemStack stack, Entity target, DamageSource damageSource, float baseKnockback) {
        MutableFloat mutableFloat = new MutableFloat(baseKnockback);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).d(world, level, stack, target, damageSource, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static void a(WorldServer world, Entity target, DamageSource damageSource) {
        Entity entity = damageSource.d();
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            EnchantmentManager.a(world, target, damageSource, livingEntity.dS());
        } else {
            EnchantmentManager.a(world, target, damageSource, null);
        }
    }

    public static void a(WorldServer world, Entity target, DamageSource damageSource, @Nullable ItemStack weapon) {
        Entity entity;
        if (target instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)target;
            EnchantmentManager.a(livingEntity, (Holder<Enchantment> enchantment, int level, EnchantedItemInUse context) -> ((Enchantment)enchantment.a()).a(world, level, context, EnchantmentTarget.c, target, damageSource));
        }
        if (weapon != null && (entity = damageSource.d()) instanceof EntityLiving) {
            EntityLiving livingEntity2 = (EntityLiving)entity;
            EnchantmentManager.a(weapon, EnumItemSlot.a, livingEntity2, (Holder<Enchantment> enchantment, int level, EnchantedItemInUse context) -> ((Enchantment)enchantment.a()).a(world, level, context, EnchantmentTarget.a, target, damageSource));
        }
    }

    public static void a(WorldServer world, EntityLiving user) {
        EnchantmentManager.a(user, (Holder<Enchantment> enchantment, int level, EnchantedItemInUse context) -> ((Enchantment)enchantment.a()).a(world, level, context, user));
    }

    public static void a(WorldServer world, ItemStack stack, EntityLiving user, EnumItemSlot slot) {
        EnchantmentManager.a(stack, slot, user, (Holder<Enchantment> enchantment, int level, EnchantedItemInUse context) -> ((Enchantment)enchantment.a()).a(world, level, context, user));
    }

    public static void a(EntityLiving user) {
        EnchantmentManager.a(user, (Holder<Enchantment> enchantment, int level, EnchantedItemInUse context) -> ((Enchantment)enchantment.a()).a(level, context, user));
    }

    public static void a(ItemStack stack, EntityLiving user, EnumItemSlot slot) {
        EnchantmentManager.a(stack, slot, user, (Holder<Enchantment> enchantment, int level, EnchantedItemInUse context) -> ((Enchantment)enchantment.a()).a(level, context, user));
    }

    public static void b(WorldServer world, EntityLiving user) {
        EnchantmentManager.a(user, (Holder<Enchantment> enchantment, int level, EnchantedItemInUse context) -> ((Enchantment)enchantment.a()).a(world, level, context, (Entity)user));
    }

    public static int a(Holder<Enchantment> enchantment, EntityLiving entity) {
        Collection<ItemStack> iterable = enchantment.a().a(entity).values();
        int i2 = 0;
        for (ItemStack itemStack : iterable) {
            int j2 = EnchantmentManager.a(enchantment, itemStack);
            if (j2 <= i2) continue;
            i2 = j2;
        }
        return i2;
    }

    public static int a(WorldServer world, ItemStack stack, Entity user, int baseProjectileCount) {
        MutableFloat mutableFloat = new MutableFloat((float)baseProjectileCount);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).e(world, level, stack, user, mutableFloat));
        return Math.max(0, mutableFloat.intValue());
    }

    public static float a(WorldServer world, ItemStack stack, Entity user, float baseProjectileSpread) {
        MutableFloat mutableFloat = new MutableFloat(baseProjectileSpread);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).f(world, level, stack, user, mutableFloat));
        return Math.max(0.0f, mutableFloat.floatValue());
    }

    public static int a(WorldServer world, ItemStack weaponStack, ItemStack projectileStack) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentManager.a(weaponStack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).c(world, level, projectileStack, mutableFloat));
        return Math.max(0, mutableFloat.intValue());
    }

    public static void a(WorldServer world, ItemStack weaponStack, EntityArrow projectileEntity, Consumer<Item> onBreak) {
        EntityLiving livingEntity;
        Entity entity = projectileEntity.s();
        EntityLiving livingEntity2 = entity instanceof EntityLiving ? (livingEntity = (EntityLiving)entity) : null;
        EnchantedItemInUse enchantedItemInUse = new EnchantedItemInUse(weaponStack, null, livingEntity2, onBreak);
        EnchantmentManager.a(weaponStack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).b(world, level, enchantedItemInUse, projectileEntity));
    }

    public static void a(WorldServer world, ItemStack stack, @Nullable EntityLiving user, Entity enchantedEntity, @Nullable EnumItemSlot slot, Vec3D pos, IBlockData state, Consumer<Item> onBreak) {
        EnchantedItemInUse enchantedItemInUse = new EnchantedItemInUse(stack, slot, user, onBreak);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).a(world, level, enchantedItemInUse, enchantedEntity, pos, state));
    }

    public static int c(WorldServer world, ItemStack stack, int baseRepairWithXp) {
        MutableFloat mutableFloat = new MutableFloat((float)baseRepairWithXp);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).e(world, level, stack, mutableFloat));
        return Math.max(0, mutableFloat.intValue());
    }

    public static float a(WorldServer world, EntityLiving attacker, DamageSource damageSource, float baseEquipmentDropChance) {
        MutableFloat mutableFloat = new MutableFloat(baseEquipmentDropChance);
        RandomSource randomSource = attacker.dR();
        EnchantmentManager.a(attacker, (Holder<Enchantment> enchantment, int level, EnchantedItemInUse context) -> {
            LootTableInfo lootContext = Enchantment.b(world, level, (Entity)attacker, damageSource);
            ((Enchantment)enchantment.a()).a(EnchantmentEffectComponents.m).forEach(effect -> {
                if (effect.a() == EnchantmentTarget.c && effect.b() == EnchantmentTarget.c && effect.a(lootContext)) {
                    mutableFloat.setValue(((EnchantmentValueEffect)effect.c()).a(level, randomSource, mutableFloat.floatValue()));
                }
            });
        });
        Entity entity = damageSource.d();
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            EnchantmentManager.a(livingEntity, (Holder<Enchantment> enchantment, int level, EnchantedItemInUse context) -> {
                LootTableInfo lootContext = Enchantment.b(world, level, (Entity)attacker, damageSource);
                ((Enchantment)enchantment.a()).a(EnchantmentEffectComponents.m).forEach(effect -> {
                    if (effect.a() == EnchantmentTarget.a && effect.b() == EnchantmentTarget.c && effect.a(lootContext)) {
                        mutableFloat.setValue(((EnchantmentValueEffect)effect.c()).a(level, randomSource, mutableFloat.floatValue()));
                    }
                });
            });
        }
        return mutableFloat.floatValue();
    }

    public static void a(ItemStack stack, EquipmentSlotGroup slot, BiConsumer<Holder<AttributeBase>, AttributeModifier> attributeModifierConsumer) {
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).a(EnchantmentEffectComponents.l).forEach(effect -> {
            if (((Enchantment)enchantment.a()).g().h().contains(slot)) {
                attributeModifierConsumer.accept(effect.c(), effect.a(level, slot));
            }
        }));
    }

    public static void a(ItemStack stack, EnumItemSlot slot, BiConsumer<Holder<AttributeBase>, AttributeModifier> attributeModifierConsumer) {
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).a(EnchantmentEffectComponents.l).forEach(effect -> {
            if (((Enchantment)enchantment.a()).a(slot)) {
                attributeModifierConsumer.accept(effect.c(), effect.a(level, (INamable)slot));
            }
        }));
    }

    public static int a(WorldServer world, ItemStack stack, Entity user) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).d(world, level, stack, user, mutableFloat));
        return Math.max(0, mutableFloat.intValue());
    }

    public static float b(WorldServer world, ItemStack stack, Entity user) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).c(world, level, stack, user, mutableFloat));
        return Math.max(0.0f, mutableFloat.floatValue());
    }

    public static int c(WorldServer world, ItemStack stack, Entity user) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).b(world, level, stack, user, mutableFloat));
        return Math.max(0, mutableFloat.intValue());
    }

    public static float a(ItemStack stack, EntityLiving user, float baseCrossbowChargeTime) {
        MutableFloat mutableFloat = new MutableFloat(baseCrossbowChargeTime);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).b(user.dR(), level, mutableFloat));
        return Math.max(0.0f, mutableFloat.floatValue());
    }

    public static float a(ItemStack stack, EntityLiving user) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> ((Enchantment)enchantment.a()).a(user.dR(), level, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static boolean a(ItemStack stack, TagKey<Enchantment> tag) {
        ItemEnchantments itemEnchantments = stack.a(DataComponents.k, ItemEnchantments.a);
        for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemEnchantments.b()) {
            Holder holder = (Holder)entry.getKey();
            if (!holder.a(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean a(ItemStack stack, DataComponentType<?> componentType) {
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> {
            if (((Enchantment)enchantment.a()).i().b(componentType)) {
                mutableBoolean.setTrue();
            }
        });
        return mutableBoolean.booleanValue();
    }

    public static <T> Optional<T> b(ItemStack stack, DataComponentType<List<T>> componentType) {
        Pair<List<T>, Integer> pair = EnchantmentManager.c(stack, componentType);
        if (pair != null) {
            List list = (List)pair.getFirst();
            int i2 = (Integer)pair.getSecond();
            return Optional.of(list.get(Math.min(i2, list.size()) - 1));
        }
        return Optional.empty();
    }

    @Nullable
    public static <T> Pair<T, Integer> c(ItemStack stack, DataComponentType<T> componentType) {
        MutableObject mutableObject = new MutableObject();
        EnchantmentManager.a(stack, (Holder<Enchantment> enchantment, int level) -> {
            Object object;
            if ((mutableObject.getValue() == null || (Integer)((Pair)mutableObject.getValue()).getSecond() < level) && (object = ((Enchantment)enchantment.a()).i().a(componentType)) != null) {
                mutableObject.setValue((Object)Pair.of(object, (Object)level));
            }
        });
        return (Pair)mutableObject.getValue();
    }

    public static Optional<EnchantedItemInUse> a(DataComponentType<?> componentType, EntityLiving entity, Predicate<ItemStack> stackPredicate) {
        ArrayList<EnchantedItemInUse> list = new ArrayList<EnchantedItemInUse>();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.values()) {
            ItemStack itemStack = entity.a(equipmentSlot);
            if (!stackPredicate.test(itemStack)) continue;
            ItemEnchantments itemEnchantments = itemStack.a(DataComponents.k, ItemEnchantments.a);
            for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemEnchantments.b()) {
                Holder holder = (Holder)entry.getKey();
                if (!((Enchantment)holder.a()).i().b(componentType) || !((Enchantment)holder.a()).a(equipmentSlot)) continue;
                list.add(new EnchantedItemInUse(itemStack, equipmentSlot, entity));
            }
        }
        return SystemUtils.b(list, entity.dR());
    }

    public static int a(RandomSource random, int slotIndex, int bookshelfCount, ItemStack stack) {
        Item item = stack.g();
        int i2 = item.g();
        if (i2 <= 0) {
            return 0;
        }
        if (bookshelfCount > 15) {
            bookshelfCount = 15;
        }
        int j2 = random.a(8) + 1 + (bookshelfCount >> 1) + random.a(bookshelfCount + 1);
        if (slotIndex == 0) {
            return Math.max(j2 / 3, 1);
        }
        if (slotIndex == 1) {
            return j2 * 2 / 3 + 1;
        }
        return Math.max(j2, bookshelfCount * 2);
    }

    public static ItemStack a(RandomSource random, ItemStack stack, int level, IRegistryCustom dynamicRegistryManager, Optional<? extends HolderSet<Enchantment>> enchantments) {
        return EnchantmentManager.a(random, stack, level, enchantments.map(HolderSet::a).orElseGet(() -> dynamicRegistryManager.d(Registries.aL).i().map(reference -> reference)));
    }

    public static ItemStack a(RandomSource random, ItemStack stack, int level, Stream<Holder<Enchantment>> possibleEnchantments) {
        List<WeightedRandomEnchant> list = EnchantmentManager.b(random, stack, level, possibleEnchantments);
        if (stack.a(Items.qP)) {
            stack = new ItemStack(Items.uw);
        }
        for (WeightedRandomEnchant enchantmentInstance : list) {
            stack.a(enchantmentInstance.a, enchantmentInstance.b);
        }
        return stack;
    }

    public static List<WeightedRandomEnchant> b(RandomSource random, ItemStack stack, int level, Stream<Holder<Enchantment>> possibleEnchantments) {
        ArrayList list = Lists.newArrayList();
        Item item = stack.g();
        int i2 = item.g();
        if (i2 <= 0) {
            return list;
        }
        level += 1 + random.a(i2 / 4 + 1) + random.a(i2 / 4 + 1);
        float f2 = (random.i() + random.i() - 1.0f) * 0.15f;
        List<WeightedRandomEnchant> list2 = EnchantmentManager.a(level = MathHelper.a(Math.round((float)level + (float)level * f2), 1, Integer.MAX_VALUE), stack, possibleEnchantments);
        if (!list2.isEmpty()) {
            WeightedRandom2.a(random, list2).ifPresent(list::add);
            while (random.a(50) <= level) {
                if (!list.isEmpty()) {
                    EnchantmentManager.a(list2, (WeightedRandomEnchant)SystemUtils.c(list));
                }
                if (list2.isEmpty()) break;
                WeightedRandom2.a(random, list2).ifPresent(list::add);
                level /= 2;
            }
        }
        return list;
    }

    public static void a(List<WeightedRandomEnchant> possibleEntries, WeightedRandomEnchant pickedEntry) {
        possibleEntries.removeIf(entry -> !Enchantment.a(enchantmentInstance.a, entry.a));
    }

    public static boolean a(Collection<Holder<Enchantment>> existing, Holder<Enchantment> candidate) {
        for (Holder<Enchantment> holder : existing) {
            if (Enchantment.a(holder, candidate)) continue;
            return false;
        }
        return true;
    }

    public static List<WeightedRandomEnchant> a(int level, ItemStack stack, Stream<Holder<Enchantment>> possibleEnchantments) {
        ArrayList list = Lists.newArrayList();
        boolean bl = stack.a(Items.qP);
        possibleEnchantments.filter(enchantment -> ((Enchantment)enchantment.a()).a(stack) || bl).forEach(enchantmentx -> {
            Enchantment enchantment = (Enchantment)enchantmentx.a();
            for (int j2 = enchantment.e(); j2 >= enchantment.d(); --j2) {
                if (level < enchantment.b(j2) || level > enchantment.c(j2)) continue;
                list.add(new WeightedRandomEnchant((Holder<Enchantment>)enchantmentx, j2));
                break;
            }
        });
        return list;
    }

    public static void a(ItemStack stack, IRegistryCustom registryManager, ResourceKey<EnchantmentProvider> providerKey, DifficultyDamageScaler localDifficulty, RandomSource random) {
        EnchantmentProvider enchantmentProvider = registryManager.d(Registries.aM).a(providerKey);
        if (enchantmentProvider != null) {
            EnchantmentManager.a(stack, (ItemEnchantments.a componentBuilder) -> enchantmentProvider.a(stack, (ItemEnchantments.a)componentBuilder, random, localDifficulty));
        }
    }

    @FunctionalInterface
    static interface b {
        public void accept(Holder<Enchantment> var1, int var2);
    }

    @FunctionalInterface
    static interface a {
        public void accept(Holder<Enchantment> var1, int var2, EnchantedItemInUse var3);
    }
}

