/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public final class ApplyMobEffect
extends Record
implements EnchantmentEntityEffect {
    private final HolderSet<MobEffectList> d;
    private final LevelBasedValue e;
    private final LevelBasedValue f;
    private final LevelBasedValue g;
    private final LevelBasedValue h;
    public static final MapCodec<ApplyMobEffect> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.a(Registries.W).fieldOf("to_apply").forGetter(ApplyMobEffect::b), (App)LevelBasedValue.b.fieldOf("min_duration").forGetter(ApplyMobEffect::c), (App)LevelBasedValue.b.fieldOf("max_duration").forGetter(ApplyMobEffect::d), (App)LevelBasedValue.b.fieldOf("min_amplifier").forGetter(ApplyMobEffect::e), (App)LevelBasedValue.b.fieldOf("max_amplifier").forGetter(ApplyMobEffect::f)).apply((Applicative)instance, ApplyMobEffect::new));

    public ApplyMobEffect(HolderSet<MobEffectList> toApply, LevelBasedValue minDuration, LevelBasedValue maxDuration, LevelBasedValue minAmplifier, LevelBasedValue maxAmplifier) {
        this.d = toApply;
        this.e = minDuration;
        this.f = maxDuration;
        this.g = minAmplifier;
        this.h = maxAmplifier;
    }

    @Override
    public void a(WorldServer world, int level, EnchantedItemInUse context, Entity user, Vec3D pos) {
        EntityLiving entityliving;
        RandomSource randomsource;
        Optional<Holder<MobEffectList>> optional;
        if (user instanceof EntityLiving && (optional = this.d.a(randomsource = (entityliving = (EntityLiving)user).dR())).isPresent()) {
            int j2 = Math.round(MathHelper.b(randomsource, this.e.a(level), this.f.a(level)) * 20.0f);
            int k2 = Math.max(0, Math.round(MathHelper.b(randomsource, this.g.a(level), this.h.a(level))));
            entityliving.addEffect(new MobEffect(optional.get(), j2, k2), EntityPotionEffectEvent.Cause.ATTACK);
        }
    }

    public MapCodec<ApplyMobEffect> a() {
        return a;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ApplyMobEffect.class, "toApply;minDuration;maxDuration;minAmplifier;maxAmplifier", "d", "e", "f", "g", "h"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ApplyMobEffect.class, "toApply;minDuration;maxDuration;minAmplifier;maxAmplifier", "d", "e", "f", "g", "h"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ApplyMobEffect.class, "toApply;minDuration;maxDuration;minAmplifier;maxAmplifier", "d", "e", "f", "g", "h"}, this, o2);
    }

    public HolderSet<MobEffectList> b() {
        return this.d;
    }

    public LevelBasedValue c() {
        return this.e;
    }

    public LevelBasedValue d() {
        return this.f;
    }

    public LevelBasedValue e() {
        return this.g;
    }

    public LevelBasedValue f() {
        return this.h;
    }
}

