/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.Graph;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;

public class FeatureSorter {
    public static <T> List<b> a(List<T> biomes, Function<T, List<HolderSet<PlacedFeature>>> biomesToPlacedFeaturesList, boolean listInvolvedBiomesOnFailure) {
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        MutableInt mutableInt = new MutableInt(0);
        record A(int a, int b, PlacedFeature c) {
            @Override
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "featureIndex;step;feature", "a", "b", "c"}, this);
            }

            @Override
            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "featureIndex;step;feature", "a", "b", "c"}, this);
            }

            @Override
            @Override
            public final boolean equals(Object object) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "featureIndex;step;feature", "a", "b", "c"}, this, object);
            }
        }
        Comparator<A> comparator = Comparator.comparingInt(A::b).thenComparingInt(A::a);
        TreeMap<A, Set> map = new TreeMap<A, Set>(comparator);
        int i2 = 0;
        for (T object : biomes) {
            ArrayList list = Lists.newArrayList();
            List<HolderSet<PlacedFeature>> list2 = biomesToPlacedFeaturesList.apply(object);
            i2 = Math.max(i2, list2.size());
            for (int j2 = 0; j2 < list2.size(); ++j2) {
                for (Holder holder : (HolderSet)list2.get(j2)) {
                    PlacedFeature placedFeature = (PlacedFeature)holder.a();
                    list.add(new A(object2IntMap.computeIfAbsent((Object)placedFeature, feature -> mutableInt.getAndIncrement()), j2, placedFeature));
                }
            }
            for (int k2 = 0; k2 < list.size(); ++k2) {
                Set set = map.computeIfAbsent((A)list.get(k2), feature -> new TreeSet(comparator));
                if (k2 >= list.size() - 1) continue;
                set.add((A)list.get(k2 + 1));
            }
        }
        TreeSet<A> set2 = new TreeSet<A>(comparator);
        TreeSet<A> set3 = new TreeSet<A>(comparator);
        ArrayList list3 = Lists.newArrayList();
        for (A lv : map.keySet()) {
            if (!set3.isEmpty()) {
                throw new IllegalStateException("You somehow broke the universe; DFS bork (iteration finished with non-empty in-progress vertex set");
            }
            if (set2.contains(lv) || !Graph.a(map, set2, set3, list3::add, lv)) continue;
            if (listInvolvedBiomesOnFailure) {
                int l2;
                ArrayList<T> list4 = new ArrayList<T>(biomes);
                do {
                    l2 = list4.size();
                    ListIterator listIterator = list4.listIterator();
                    while (listIterator.hasNext()) {
                        Object object2 = listIterator.next();
                        listIterator.remove();
                        try {
                            FeatureSorter.a(list4, biomesToPlacedFeaturesList, false);
                        }
                        catch (IllegalStateException illegalStateException) {
                            continue;
                        }
                        listIterator.add(object2);
                    }
                } while (l2 != list4.size());
                throw new IllegalStateException("Feature order cycle found, involved sources: " + String.valueOf(list4));
            }
            throw new IllegalStateException("Feature order cycle found");
        }
        Collections.reverse(list3);
        ImmutableList.Builder builder = ImmutableList.builder();
        int m2 = 0;
        while (m2 < i2) {
            int n2 = m2++;
            List<PlacedFeature> list5 = list3.stream().filter(feature -> feature.b() == n2).map(A::c).collect(Collectors.toList());
            builder.add((Object)new b(list5));
        }
        return builder.build();
    }

    public record b(List<PlacedFeature> a, ToIntFunction<PlacedFeature> b) {
        b(List<PlacedFeature> features) {
            this(features, SystemUtils.h(features));
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "features;indexMapping", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "features;indexMapping", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "features;indexMapping", "a", "b"}, this, object);
        }
    }
}

