/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.levelgen.NoiseRouterData;

public class WorldChunkManagerMultiNoise
extends WorldChunkManager {
    private static final MapCodec<Holder<BiomeBase>> d = BiomeBase.c.fieldOf("biome");
    public static final MapCodec<Climate.c<Holder<BiomeBase>>> b = Climate.c.a(d).fieldOf("biomes");
    private static final MapCodec<Holder<MultiNoiseBiomeSourceParameterList>> e = MultiNoiseBiomeSourceParameterList.b.fieldOf("preset").withLifecycle(Lifecycle.stable());
    public static final MapCodec<WorldChunkManagerMultiNoise> c = Codec.mapEither(b, e).xmap(WorldChunkManagerMultiNoise::new, source -> source.f);
    private final Either<Climate.c<Holder<BiomeBase>>, Holder<MultiNoiseBiomeSourceParameterList>> f;

    private WorldChunkManagerMultiNoise(Either<Climate.c<Holder<BiomeBase>>, Holder<MultiNoiseBiomeSourceParameterList>> biomeEntries) {
        this.f = biomeEntries;
    }

    public static WorldChunkManagerMultiNoise a(Climate.c<Holder<BiomeBase>> biomeEntries) {
        return new WorldChunkManagerMultiNoise(Either.left(biomeEntries));
    }

    public static WorldChunkManagerMultiNoise a(Holder<MultiNoiseBiomeSourceParameterList> biomeEntries) {
        return new WorldChunkManagerMultiNoise(Either.right(biomeEntries));
    }

    private Climate.c<Holder<BiomeBase>> d() {
        return this.f.map(entries -> entries, parameterListEntry -> ((MultiNoiseBiomeSourceParameterList)parameterListEntry.a()).a());
    }

    @Override
    @Override
    protected Stream<Holder<BiomeBase>> b() {
        return this.d().a().stream().map(Pair::getSecond);
    }

    @Override
    @Override
    protected MapCodec<? extends WorldChunkManager> a() {
        return c;
    }

    public boolean a(ResourceKey<MultiNoiseBiomeSourceParameterList> parameterList) {
        Optional<Holder<MultiNoiseBiomeSourceParameterList>> optional = this.f.right();
        return optional.isPresent() && optional.get().a(parameterList);
    }

    @Override
    @Override
    public Holder<BiomeBase> getNoiseBiome(int x2, int y2, int z2, Climate.Sampler noise) {
        return this.a(noise.a(x2, y2, z2));
    }

    @VisibleForDebug
    public Holder<BiomeBase> a(Climate.h point) {
        return this.d().a(point);
    }

    @Override
    @Override
    public void a(List<String> info, BlockPosition pos, Climate.Sampler noiseSampler) {
        int i2 = QuartPos.a(pos.u());
        int j2 = QuartPos.a(pos.v());
        int k2 = QuartPos.a(pos.w());
        Climate.h targetPoint = noiseSampler.a(i2, j2, k2);
        float f2 = Climate.a(targetPoint.d());
        float g2 = Climate.a(targetPoint.e());
        float h2 = Climate.a(targetPoint.b());
        float l2 = Climate.a(targetPoint.c());
        float m2 = Climate.a(targetPoint.g());
        double d2 = NoiseRouterData.a(m2);
        OverworldBiomeBuilder overworldBiomeBuilder = new OverworldBiomeBuilder();
        info.add("Biome builder PV: " + OverworldBiomeBuilder.a(d2) + " C: " + overworldBiomeBuilder.b(f2) + " E: " + overworldBiomeBuilder.c(g2) + " T: " + overworldBiomeBuilder.d(h2) + " H: " + overworldBiomeBuilder.e(l2));
    }
}

