/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class AmethystClusterBlock
extends AmethystBlock
implements IBlockWaterlogged {
    public static final MapCodec<AmethystClusterBlock> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("height").forGetter(block -> Float.valueOf(block.k)), (App)Codec.FLOAT.fieldOf("aabb_offset").forGetter(block -> Float.valueOf(block.l)), AmethystClusterBlock.u()).apply((Applicative)instance, AmethystClusterBlock::new));
    public static final BlockStateBoolean c = BlockProperties.C;
    public static final BlockStateDirection d = BlockProperties.P;
    private final float k;
    private final float l;
    protected final VoxelShape e;
    protected final VoxelShape f;
    protected final VoxelShape g;
    protected final VoxelShape h;
    protected final VoxelShape i;
    protected final VoxelShape j;

    @Override
    public MapCodec<AmethystClusterBlock> a() {
        return b;
    }

    public AmethystClusterBlock(float height, float xzOffset, BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)this.o().a(c, false)).a(d, EnumDirection.b));
        this.i = Block.a(xzOffset, 0.0, xzOffset, 16.0f - xzOffset, height, 16.0f - xzOffset);
        this.j = Block.a(xzOffset, 16.0f - height, xzOffset, 16.0f - xzOffset, 16.0, 16.0f - xzOffset);
        this.e = Block.a(xzOffset, xzOffset, 16.0f - height, 16.0f - xzOffset, 16.0f - xzOffset, 16.0);
        this.f = Block.a(xzOffset, xzOffset, 0.0, 16.0f - xzOffset, 16.0f - xzOffset, height);
        this.g = Block.a(0.0, xzOffset, xzOffset, height, 16.0f - xzOffset, 16.0f - xzOffset);
        this.h = Block.a(16.0f - height, xzOffset, xzOffset, 16.0, 16.0f - xzOffset, 16.0f - xzOffset);
        this.k = height;
        this.l = xzOffset;
    }

    @Override
    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        EnumDirection direction = state.c(d);
        switch (direction) {
            case c: {
                return this.e;
            }
            case d: {
                return this.f;
            }
            case f: {
                return this.g;
            }
            case e: {
                return this.h;
            }
            case a: {
                return this.j;
            }
        }
        return this.i;
    }

    @Override
    @Override
    protected boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        EnumDirection direction = state.c(d);
        BlockPosition blockPos = pos.a(direction.g());
        return world.a_(blockPos).d(world, blockPos, direction);
    }

    @Override
    @Override
    protected IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(c).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        if (direction == state.c(d).g() && !state.a(world, pos)) {
            return Blocks.a.o();
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    @Nullable
    @Override
    public IBlockData a(BlockActionContext ctx) {
        World levelAccessor = ctx.q();
        BlockPosition blockPos = ctx.a();
        return (IBlockData)((IBlockData)this.o().a(c, levelAccessor.b_(blockPos).a() == FluidTypes.c)).a(d, ctx.k());
    }

    @Override
    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(d, rotation.a(state.c(d)));
    }

    @Override
    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(d)));
    }

    @Override
    @Override
    protected Fluid b_(IBlockData state) {
        if (state.c(c).booleanValue()) {
            return FluidTypes.c.a(false);
        }
        return super.b_(state);
    }

    @Override
    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, d);
    }
}

