/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.MinecartTrackLogic;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public abstract class BlockMinecartTrackAbstract
extends Block
implements IBlockWaterlogged {
    protected static final VoxelShape a = Block.a(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    protected static final VoxelShape b = Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    public static final BlockStateBoolean c = BlockProperties.C;
    private final boolean d;

    public static boolean a(World world, BlockPosition pos) {
        return BlockMinecartTrackAbstract.g(world.a_(pos));
    }

    public static boolean g(IBlockData state) {
        return state.a(TagsBlock.O) && state.b() instanceof BlockMinecartTrackAbstract;
    }

    protected BlockMinecartTrackAbstract(boolean forbidCurves, BlockBase.Info settings) {
        super(settings);
        this.d = forbidCurves;
    }

    protected abstract MapCodec<? extends BlockMinecartTrackAbstract> a();

    public boolean b() {
        return this.d;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        BlockPropertyTrackPosition railShape = state.a(this) ? state.c(this.c()) : null;
        return railShape != null && railShape.b() ? b : a;
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        return BlockMinecartTrackAbstract.c(world, pos.e());
    }

    @Override
    protected void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (!oldState.a(state.b())) {
            this.a(state, world, pos, notify);
        }
    }

    protected IBlockData a(IBlockData state, World world, BlockPosition pos, boolean notify) {
        state = this.a(world, pos, state, true);
        if (this.d) {
            world.a(state, pos, this, pos, notify);
            state = world.a_(pos);
        }
        return state;
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        if (!world.B && world.a_(pos).a(this)) {
            BlockPropertyTrackPosition railShape = state.c(this.c());
            if (BlockMinecartTrackAbstract.a(pos, world, railShape)) {
                BlockMinecartTrackAbstract.c(state, world, pos);
                world.a(pos, notify);
            } else {
                this.a(state, world, pos, sourceBlock);
            }
        }
    }

    private static boolean a(BlockPosition pos, World world, BlockPropertyTrackPosition shape) {
        if (!BlockMinecartTrackAbstract.c(world, pos.e())) {
            return true;
        }
        switch (shape) {
            case c: {
                return !BlockMinecartTrackAbstract.c(world, pos.i());
            }
            case d: {
                return !BlockMinecartTrackAbstract.c(world, pos.h());
            }
            case e: {
                return !BlockMinecartTrackAbstract.c(world, pos.f());
            }
            case f: {
                return !BlockMinecartTrackAbstract.c(world, pos.g());
            }
        }
        return false;
    }

    protected void a(IBlockData state, World world, BlockPosition pos, Block neighbor) {
    }

    protected IBlockData a(World world, BlockPosition pos, IBlockData state, boolean forceUpdate) {
        if (world.B) {
            return state;
        }
        BlockPropertyTrackPosition railShape = state.c(this.c());
        return new MinecartTrackLogic(world, pos, state).a(world.C(pos), forceUpdate, railShape).c();
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!moved) {
            super.a(state, world, pos, newState, moved);
            if (state.c(this.c()).b()) {
                world.a(pos.d(), this);
            }
            if (this.d) {
                world.a(pos, this);
                world.a(pos.e(), this);
            }
        }
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        Fluid fluidState = ctx.q().b_(ctx.a());
        boolean bl = fluidState.a() == FluidTypes.c;
        IBlockData blockState = super.o();
        EnumDirection direction = ctx.g();
        boolean bl2 = direction == EnumDirection.f || direction == EnumDirection.e;
        return (IBlockData)((IBlockData)blockState.a(this.c(), bl2 ? BlockPropertyTrackPosition.b : BlockPropertyTrackPosition.a)).a(c, bl);
    }

    public abstract IBlockState<BlockPropertyTrackPosition> c();

    @Override
    protected IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(c).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(c) != false ? FluidTypes.c.a(false) : super.b_(state);
    }
}

