/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockStem
extends BlockPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockStem> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.a(Registries.f).fieldOf("fruit").forGetter(blockstem -> blockstem.f), (App)ResourceKey.a(Registries.f).fieldOf("attached_stem").forGetter(blockstem -> blockstem.g), (App)ResourceKey.a(Registries.K).fieldOf("seed").forGetter(blockstem -> blockstem.h), BlockStem.u()).apply((Applicative)instance, BlockStem::new));
    public static final int b = 7;
    public static final BlockStateInteger c = BlockProperties.av;
    protected static final float d = 1.0f;
    protected static final VoxelShape[] e = new VoxelShape[]{Block.a(7.0, 0.0, 7.0, 9.0, 2.0, 9.0), Block.a(7.0, 0.0, 7.0, 9.0, 4.0, 9.0), Block.a(7.0, 0.0, 7.0, 9.0, 6.0, 9.0), Block.a(7.0, 0.0, 7.0, 9.0, 8.0, 9.0), Block.a(7.0, 0.0, 7.0, 9.0, 10.0, 9.0), Block.a(7.0, 0.0, 7.0, 9.0, 12.0, 9.0), Block.a(7.0, 0.0, 7.0, 9.0, 14.0, 9.0), Block.a(7.0, 0.0, 7.0, 9.0, 16.0, 9.0)};
    private final ResourceKey<Block> f;
    private final ResourceKey<Block> g;
    private final ResourceKey<Item> h;

    public MapCodec<BlockStem> a() {
        return a;
    }

    protected BlockStem(ResourceKey<Block> gourdBlock, ResourceKey<Block> attachedStemBlock, ResourceKey<Item> pickBlockItem, BlockBase.Info settings) {
        super(settings);
        this.f = gourdBlock;
        this.g = attachedStemBlock;
        this.h = pickBlockItem;
        this.k((IBlockData)this.E.b().a(c, 0));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return e[state.c(c)];
    }

    @Override
    protected boolean b(IBlockData floor, IBlockAccess world, BlockPosition pos) {
        return floor.a(Blocks.cC);
    }

    @Override
    protected void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (world.b(pos, 0) >= 9) {
            float f2 = BlockCrops.a(this, world, pos);
            double d2 = random.i();
            int n2 = this == Blocks.fd ? world.spigotConfig.pumpkinModifier : world.spigotConfig.melonModifier;
            if (d2 < (double)n2 / (100.0 * Math.floor(25.0f / f2 + 1.0f))) {
                int i2 = state.c(c);
                if (i2 < 7) {
                    state = (IBlockData)state.a(c, i2 + 1);
                    CraftEventFactory.handleBlockGrowEvent(world, pos, state, 2);
                } else {
                    EnumDirection enumdirection = EnumDirection.EnumDirectionLimit.a.a(random);
                    BlockPosition blockposition1 = pos.a(enumdirection);
                    IBlockData iblockdata1 = world.a_(blockposition1.e());
                    if (world.a_(blockposition1).i() && (iblockdata1.a(Blocks.cC) || iblockdata1.a(TagsBlock.ag))) {
                        IRegistry<Block> iregistry = world.H_().d(Registries.f);
                        Optional<Block> optional = iregistry.e(this.f);
                        Optional<Block> optional1 = iregistry.e(this.g);
                        if (optional.isPresent() && optional1.isPresent()) {
                            if (!CraftEventFactory.handleBlockGrowEvent(world, blockposition1, optional.get().o())) {
                                return;
                            }
                            world.b(pos, (IBlockData)optional1.get().o().a(BlockFacingHorizontal.aE, enumdirection));
                        }
                    }
                }
            }
        }
    }

    @Override
    public ItemStack a(IWorldReader world, BlockPosition pos, IBlockData state) {
        return new ItemStack((IMaterial)DataFixUtils.orElse(world.H_().d(Registries.K).e(this.h), (Object)this));
    }

    @Override
    public boolean b(IWorldReader world, BlockPosition pos, IBlockData state) {
        return state.c(c) != 7;
    }

    @Override
    public boolean a(World world, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer world, RandomSource random, BlockPosition pos, IBlockData state) {
        int i2 = Math.min(7, state.c(c) + MathHelper.a(world.z, 2, 5));
        IBlockData iblockdata1 = (IBlockData)state.a(c, i2);
        CraftEventFactory.handleBlockGrowEvent(world, pos, iblockdata1, 2);
        if (i2 == 7) {
            iblockdata1.b(world, pos, world.z);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{c});
    }
}

