/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.block.TNTPrimeEvent;

public class BlockTNT
extends Block {
    public static final MapCodec<BlockTNT> a = BlockTNT.b(BlockTNT::new);
    public static final BlockStateBoolean b = BlockProperties.B;

    public MapCodec<BlockTNT> a() {
        return a;
    }

    public BlockTNT(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)this.o().a(b, false));
    }

    @Override
    protected void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (!oldState.a(state.b()) && world.C(pos) && CraftEventFactory.callTNTPrimeEvent(world, pos, TNTPrimeEvent.PrimeCause.REDSTONE, null, null)) {
            CraftBlock tntBlock = CraftBlock.at(world, pos);
            if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.REDSTONE, null).callEvent()) {
                return;
            }
            BlockTNT.a(world, pos);
            world.a(pos, false);
        }
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        if (world.C(pos) && CraftEventFactory.callTNTPrimeEvent(world, pos, TNTPrimeEvent.PrimeCause.REDSTONE, null, sourcePos)) {
            CraftBlock tntBlock = CraftBlock.at(world, pos);
            if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.REDSTONE, null).callEvent()) {
                return;
            }
            BlockTNT.a(world, pos);
            world.a(pos, false);
        }
    }

    @Override
    public IBlockData a(World world, BlockPosition pos, IBlockData state, EntityHuman player) {
        if (!world.x_() && !player.f() && state.c(b).booleanValue() && CraftEventFactory.callTNTPrimeEvent(world, pos, TNTPrimeEvent.PrimeCause.BLOCK_BREAK, player, null)) {
            BlockTNT.a(world, pos);
        }
        return super.a(world, pos, state, player);
    }

    @Override
    public void a(World world, BlockPosition pos, Explosion explosion) {
        if (!world.B) {
            CraftEntity source;
            CraftBlock tntBlock = CraftBlock.at(world, pos);
            CraftEntity craftEntity = source = explosion.j != null ? explosion.j.getBukkitEntity() : null;
            if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.EXPLOSION, (Entity)source).callEvent()) {
                return;
            }
            EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, explosion.f());
            int i2 = entitytntprimed.t();
            entitytntprimed.b((short)(world.z.a(i2 / 4) + i2 / 8));
            world.b(entitytntprimed);
        }
    }

    public static void a(World world, BlockPosition pos) {
        BlockTNT.a(world, pos, (EntityLiving)null);
    }

    private static void a(World world, BlockPosition pos, @Nullable EntityLiving igniter) {
        if (!world.B) {
            EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, igniter);
            world.b(entitytntprimed);
            world.a((EntityHuman)null, entitytntprimed.dt(), entitytntprimed.dv(), entitytntprimed.dz(), SoundEffects.zy, SoundCategory.e, 1.0f, 1.0f);
            world.a((net.minecraft.world.entity.Entity)igniter, GameEvent.I, pos);
        }
    }

    @Override
    protected ItemInteractionResult a(ItemStack stack, IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        if (!stack.a(Items.os) && !stack.a(Items.tX)) {
            return super.a(stack, state, world, pos, player, hand, hit);
        }
        if (!CraftEventFactory.callTNTPrimeEvent(world, pos, TNTPrimeEvent.PrimeCause.PLAYER, player, null)) {
            return ItemInteractionResult.b;
        }
        CraftBlock tntBlock = CraftBlock.at(world, pos);
        if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.ITEM, (Entity)player.getBukkitEntity()).callEvent()) {
            return ItemInteractionResult.f;
        }
        BlockTNT.a(world, pos, player);
        world.a(pos, Blocks.a.o(), 11);
        Item item = stack.g();
        if (stack.a(Items.os)) {
            stack.a(1, (EntityLiving)player, EntityLiving.d(hand));
        } else {
            stack.a(1, (EntityLiving)player);
        }
        player.b(StatisticList.c.b(item));
        return ItemInteractionResult.a(world.B);
    }

    @Override
    protected void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        if (!world.B) {
            BlockPosition blockposition = hit.a();
            net.minecraft.world.entity.Entity entity = projectile.s();
            if (projectile.bR() && projectile.a(world, blockposition)) {
                if (!CraftEventFactory.callEntityChangeBlockEvent(projectile, blockposition, state.u().g()) || !CraftEventFactory.callTNTPrimeEvent(world, blockposition, TNTPrimeEvent.PrimeCause.PROJECTILE, projectile, null)) {
                    return;
                }
                CraftBlock tntBlock = CraftBlock.at(world, blockposition);
                if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.PROJECTILE, (Entity)projectile.getBukkitEntity()).callEvent()) {
                    return;
                }
                BlockTNT.a(world, blockposition, entity instanceof EntityLiving ? (EntityLiving)entity : null);
                world.a(blockposition, false);
            }
        }
    }

    @Override
    public boolean a(Explosion explosion) {
        return false;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }
}

