/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.block.TargetHitEvent;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.entity.Projectile;

public class BlockTarget
extends Block {
    public static final MapCodec<BlockTarget> a = BlockTarget.b(BlockTarget::new);
    private static final BlockStateInteger b = BlockProperties.aT;
    private static final int c = 20;
    private static final int d = 8;

    public MapCodec<BlockTarget> a() {
        return a;
    }

    public BlockTarget(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)this.E.b().a(b, 0));
    }

    @Override
    protected void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        int i2 = BlockTarget.a((GeneratorAccess)world, state, hit, projectile);
    }

    private static void awardTargetHitCriteria(IProjectile projectile, MovingObjectPositionBlock hit, int i2) {
        Entity entity = projectile.s();
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            serverPlayer.a(StatisticList.aE);
            CriterionTriggers.M.a(serverPlayer, projectile, hit.e(), i2);
        }
    }

    private static int a(GeneratorAccess world, IBlockData state, MovingObjectPositionBlock hitResult, Entity entity) {
        int i2 = BlockTarget.a(hitResult, hitResult.e());
        int j2 = entity instanceof EntityArrow ? 20 : 8;
        boolean shouldAward = false;
        if (entity instanceof IProjectile) {
            IProjectile projectile = (IProjectile)entity;
            CraftBlock craftBlock = CraftBlock.at(world, hitResult.a());
            BlockFace blockFace = CraftBlock.notchToBlockFace(hitResult.b());
            TargetHitEvent targetHitEvent = new TargetHitEvent((Projectile)projectile.getBukkitEntity(), (org.bukkit.block.Block)craftBlock, blockFace, i2);
            if (targetHitEvent.callEvent()) {
                i2 = targetHitEvent.getSignalStrength();
                shouldAward = true;
            } else {
                return i2;
            }
        }
        if (!world.P().a(hitResult.a(), state.b())) {
            BlockTarget.a(world, state, i2, hitResult.a(), j2);
        }
        if (shouldAward) {
            BlockTarget.awardTargetHitCriteria((IProjectile)entity, hitResult, i2);
        }
        return i2;
    }

    private static int a(MovingObjectPositionBlock hitResult, Vec3D pos) {
        EnumDirection direction = hitResult.b();
        double d2 = Math.abs(MathHelper.e(pos.c) - 0.5);
        double e2 = Math.abs(MathHelper.e(pos.d) - 0.5);
        double f2 = Math.abs(MathHelper.e(pos.e) - 0.5);
        EnumDirection.EnumAxis axis = direction.o();
        double g2 = axis == EnumDirection.EnumAxis.b ? Math.max(d2, f2) : (axis == EnumDirection.EnumAxis.c ? Math.max(d2, e2) : Math.max(e2, f2));
        return Math.max(1, MathHelper.c(15.0 * MathHelper.a((0.5 - g2) / 0.5, 0.0, 1.0)));
    }

    private static void a(GeneratorAccess world, IBlockData state, int power, BlockPosition pos, int delay) {
        world.a(pos, (IBlockData)state.a(b, power), 3);
        world.a(pos, state.b(), delay);
    }

    @Override
    protected void a(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        if (state.c(b) != 0) {
            world.a(pos, (IBlockData)state.a(b, 0), 3);
        }
    }

    @Override
    protected int a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        return state.c(b);
    }

    @Override
    protected boolean e_(IBlockData state) {
        return true;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }

    @Override
    protected void b(IBlockData state, World world, BlockPosition pos, IBlockData oldState, boolean notify) {
        if (!(world.x_() || state.a(oldState.b()) || state.c(b) <= 0 || world.P().a(pos, this))) {
            world.a(pos, (IBlockData)state.a(b, 0), 18);
        }
    }
}

