/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class DecoratedPotBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<DecoratedPotBlock> a = DecoratedPotBlock.b(DecoratedPotBlock::new);
    public static final MinecraftKey b = MinecraftKey.b("sherds");
    private static final VoxelShape d = Block.a(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);
    private static final BlockStateDirection e = BlockProperties.R;
    public static final BlockStateBoolean c = BlockProperties.bw;
    private static final BlockStateBoolean f = BlockProperties.C;

    public MapCodec<DecoratedPotBlock> a() {
        return a;
    }

    protected DecoratedPotBlock(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.E.b().a(e, EnumDirection.c)).a(f, false)).a(c, false));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(f).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        Fluid fluid = ctx.q().b_(ctx.a());
        return (IBlockData)((IBlockData)((IBlockData)this.o().a(e, ctx.g())).a(f, fluid.a() == FluidTypes.c)).a(c, false);
    }

    @Override
    protected ItemInteractionResult a(ItemStack stack, IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            if (world.B) {
                return ItemInteractionResult.b;
            }
            ItemStack itemstack1 = decoratedpotblockentity.f();
            if (!stack.e() && (itemstack1.e() || ItemStack.c(itemstack1, stack) && itemstack1.H() < itemstack1.j())) {
                float f2;
                decoratedpotblockentity.a(DecoratedPotBlockEntity.a.a);
                player.b(StatisticList.c.b(stack.g()));
                ItemStack itemstack2 = stack.b(1, (EntityLiving)player);
                if (decoratedpotblockentity.c()) {
                    decoratedpotblockentity.b(itemstack2);
                    f2 = (float)itemstack2.H() / (float)itemstack2.j();
                } else {
                    itemstack1.g(1);
                    f2 = (float)itemstack1.H() / (float)itemstack1.j();
                }
                world.a((EntityHuman)null, pos, SoundEffects.gy, SoundCategory.e, 1.0f, 0.7f + 0.5f * f2);
                if (world instanceof WorldServer) {
                    WorldServer worldserver = (WorldServer)world;
                    worldserver.a(Particles.aX, (double)pos.u() + 0.5, (double)pos.v() + 1.2, (double)pos.w() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
                }
                decoratedpotblockentity.e();
                world.a((Entity)player, GameEvent.c, pos);
                return ItemInteractionResult.a;
            }
            return ItemInteractionResult.d;
        }
        return ItemInteractionResult.e;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hit) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            world.a((EntityHuman)null, pos, SoundEffects.gz, SoundCategory.e, 1.0f, 1.0f);
            decoratedpotblockentity.a(DecoratedPotBlockEntity.a.b);
            world.a((Entity)player, GameEvent.c, pos);
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    protected boolean a(IBlockData state, PathMode type) {
        return false;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return d;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(e, f, c);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new DecoratedPotBlockEntity(pos, state);
    }

    @Override
    protected void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        InventoryUtils.a(state, newState, world, pos);
        super.a(state, world, pos, newState, moved);
    }

    @Override
    protected List<ItemStack> a(IBlockData state, LootParams.a builder) {
        TileEntity tileentity = builder.b(LootContextParameters.h);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            builder.a(b, (Consumer<ItemStack> consumer) -> {
                for (Item item : decoratedpotblockentity.l().a()) {
                    consumer.accept(item.w());
                }
            });
        }
        return super.a(state, builder);
    }

    @Override
    public IBlockData a(World world, BlockPosition pos, IBlockData state, EntityHuman player) {
        ItemStack itemstack = player.eT();
        IBlockData iblockdata1 = state;
        if (itemstack.a(TagsItem.bv) && !EnchantmentManager.a(itemstack, EnchantmentTags.r)) {
            iblockdata1 = (IBlockData)state.a(c, true);
            world.a(pos, iblockdata1, 4);
        }
        return super.a(world, pos, iblockdata1, player);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(f) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected SoundEffectType g_(IBlockData state) {
        return state.c(c) != false ? SoundEffectType.bc : SoundEffectType.bb;
    }

    @Override
    public void a(ItemStack stack, Item.b context, List<IChatBaseComponent> tooltip, TooltipFlag options) {
        super.a(stack, context, tooltip, options);
        PotDecorations potdecorations = stack.a(DataComponents.aa, PotDecorations.a);
        if (!potdecorations.equals(PotDecorations.a)) {
            tooltip.add(CommonComponents.a);
            Stream.of(potdecorations.e(), potdecorations.c(), potdecorations.d(), potdecorations.b()).forEach(optional -> tooltip.add(new ItemStack(optional.orElse(Items.qL), 1).w().e().a(EnumChatFormat.h)));
        }
    }

    @Override
    protected void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        BlockPosition blockposition = hit.a();
        if (!world.B && projectile.a(world, blockposition) && projectile.b(world)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(projectile, blockposition, this.b_(state).g())) {
                return;
            }
            world.a(blockposition, (IBlockData)state.a(c, true), 4);
            world.a(blockposition, true, projectile);
        }
    }

    @Override
    public ItemStack a(IWorldReader world, BlockPosition pos, IBlockData state) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            return decoratedpotblockentity.u();
        }
        return super.a(world, pos, state);
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World world, BlockPosition pos) {
        return Container.a(world.c_(pos));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(e, rotation.a(state.c(e)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(e)));
    }
}

