/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;

public abstract class TileEntityFurnace
extends TileEntityContainer
implements IWorldInventory,
RecipeCraftingHolder,
AutoRecipeOutput {
    protected static final int b = 0;
    protected static final int c = 1;
    protected static final int d = 2;
    public static final int e = 0;
    private static final int[] q = new int[]{0};
    private static final int[] r = new int[]{2, 1};
    private static final int[] s = new int[]{1};
    public static final int f = 1;
    public static final int g = 2;
    public static final int h = 3;
    public static final int i = 4;
    public static final int j = 200;
    public static final int k = 2;
    protected NonNullList<net.minecraft.world.item.ItemStack> l;
    public int t;
    int u;
    public double cookSpeedMultiplier = 1.0;
    public int v;
    public int w;
    @Nullable
    private static volatile Map<Item, Integer> x;
    protected final IContainerProperties m;
    public final Object2IntOpenHashMap<MinecraftKey> y;
    private final CraftingManager.a<SingleRecipeInput, ? extends RecipeCooking> z;
    public final Recipes<? extends RecipeCooking> recipeType;
    private int maxStack = 99;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    protected TileEntityFurnace(TileEntityTypes<?> blockEntityType, BlockPosition pos, IBlockData state, Recipes<? extends RecipeCooking> recipeType) {
        super(blockEntityType, pos, state);
        this.l = NonNullList.a(3, net.minecraft.world.item.ItemStack.l);
        this.m = new IContainerProperties(){

            @Override
            public int a(int index) {
                switch (index) {
                    case 0: {
                        return TileEntityFurnace.this.t;
                    }
                    case 1: {
                        return TileEntityFurnace.this.u;
                    }
                    case 2: {
                        return TileEntityFurnace.this.v;
                    }
                    case 3: {
                        return TileEntityFurnace.this.w;
                    }
                }
                return 0;
            }

            @Override
            public void a(int index, int value) {
                switch (index) {
                    case 0: {
                        TileEntityFurnace.this.t = value;
                        break;
                    }
                    case 1: {
                        TileEntityFurnace.this.u = value;
                        break;
                    }
                    case 2: {
                        TileEntityFurnace.this.v = value;
                        break;
                    }
                    case 3: {
                        TileEntityFurnace.this.w = value;
                    }
                }
            }

            @Override
            public int a() {
                return 4;
            }
        };
        this.y = new Object2IntOpenHashMap();
        this.z = CraftingManager.b(recipeType);
        this.recipeType = recipeType;
    }

    public static void f() {
        x = null;
    }

    public static Map<Item, Integer> g() {
        Map<Item, Integer> map = x;
        if (map != null) {
            return map;
        }
        LinkedHashMap map1 = Maps.newLinkedHashMap();
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.qA, 20000);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.iB, 16000);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.sg, 2400);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.ox, 1600);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.oy, 1600);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.r, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.C, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.b, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.w, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.i, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.hU, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.j, 150);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.jC, 150);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.n, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.m, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.k, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.l, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.aY, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.cl, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.cm, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.oa, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.dT, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.cv, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.gV, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.cA, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.gZ, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.E, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.ov, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.qV, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.cO, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.aQ, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.bd, 800);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.oN, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.oM, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.oQ, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.oP, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.oO, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.h, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.aN, 1200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.a, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.d, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.pq, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.p, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.ot, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.g, 67);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.me, 4001);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.vW, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.mZ, 50);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.bv, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.nS, 50);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.nT, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.nU, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.nX, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.nY, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.ob, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.pc, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.sy, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.sz, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.ac, 300);
        x = map1;
        return map1;
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.l;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int al_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public Object2IntOpenHashMap<MinecraftKey> getRecipesUsed() {
        return this.y;
    }

    private static boolean b(Item item) {
        return item.o().a(TagsItem.aH);
    }

    private static void a(Map<Item, Integer> fuelTimes, TagKey<Item> tag, int fuelTime) {
        for (Holder<Item> holder : BuiltInRegistries.g.c(tag)) {
            if (TileEntityFurnace.b(holder.a())) continue;
            fuelTimes.put(holder.a(), fuelTime);
        }
    }

    private static void a(Map<Item, Integer> fuelTimes, IMaterial item, int fuelTime) {
        Item item1 = item.r();
        if (TileEntityFurnace.b(item1)) {
            if (SharedConstants.aV) {
                throw SystemUtils.b(new IllegalStateException("A developer tried to explicitly make fire resistant item " + item1.n(null).getString() + " a furnace fuel. That will not work!"));
            }
        } else {
            fuelTimes.put(item1, fuelTime);
        }
    }

    private boolean l() {
        return this.t > 0;
    }

    @Override
    protected void a(NBTTagCompound nbt, HolderLookup.a registryLookup) {
        super.a(nbt, registryLookup);
        this.l = NonNullList.a(this.b(), net.minecraft.world.item.ItemStack.l);
        ContainerUtil.b(nbt, this.l, registryLookup);
        this.t = nbt.g("BurnTime");
        this.v = nbt.g("CookTime");
        this.w = nbt.g("CookTimeTotal");
        this.u = this.b(this.l.get(1));
        NBTTagCompound nbttagcompound1 = nbt.p("RecipesUsed");
        for (String s2 : nbttagcompound1.e()) {
            MinecraftKey resourceLocation = MinecraftKey.c(s2);
            if (resourceLocation == null) continue;
            this.y.put((Object)resourceLocation, nbttagcompound1.h(s2));
        }
        if (nbt.e("Paper.CookSpeedMultiplier")) {
            this.cookSpeedMultiplier = nbt.k("Paper.CookSpeedMultiplier");
        }
    }

    @Override
    protected void b(NBTTagCompound nbt, HolderLookup.a registryLookup) {
        super.b(nbt, registryLookup);
        nbt.a("BurnTime", (short)this.t);
        nbt.a("CookTime", (short)this.v);
        nbt.a("CookTimeTotal", (short)this.w);
        nbt.a("Paper.CookSpeedMultiplier", this.cookSpeedMultiplier);
        ContainerUtil.a(nbt, this.l, registryLookup);
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        this.y.forEach((minecraftkey, integer) -> nbttagcompound1.a(minecraftkey.toString(), (int)integer));
        nbt.a("RecipesUsed", nbttagcompound1);
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntityFurnace blockEntity) {
        boolean flag3;
        boolean flag = blockEntity.l();
        boolean flag1 = false;
        if (blockEntity.l()) {
            --blockEntity.t;
        }
        net.minecraft.world.item.ItemStack itemstack = blockEntity.l.get(1);
        net.minecraft.world.item.ItemStack itemstack1 = blockEntity.l.get(0);
        boolean flag2 = !itemstack1.e();
        boolean bl = flag3 = !itemstack.e();
        if (!(blockEntity.l() || flag3 && flag2)) {
            if (!blockEntity.l() && blockEntity.v > 0) {
                blockEntity.v = MathHelper.a(blockEntity.v - 2, 0, blockEntity.w);
            }
        } else {
            RecipeHolder recipeholder = flag2 ? (RecipeHolder)blockEntity.z.a(new SingleRecipeInput(itemstack1), world).orElse(null) : null;
            int i2 = blockEntity.al_();
            if (!blockEntity.l() && TileEntityFurnace.a(world.H_(), recipeholder, blockEntity.l, i2)) {
                CraftItemStack fuel = CraftItemStack.asCraftMirror(itemstack);
                FurnaceBurnEvent furnaceBurnEvent = new FurnaceBurnEvent((Block)CraftBlock.at(world, pos), (ItemStack)fuel, blockEntity.b(itemstack));
                world.getCraftServer().getPluginManager().callEvent((Event)furnaceBurnEvent);
                if (furnaceBurnEvent.isCancelled()) {
                    return;
                }
                blockEntity.u = blockEntity.t = furnaceBurnEvent.getBurnTime();
                if (blockEntity.l() && furnaceBurnEvent.isBurning()) {
                    flag1 = true;
                    if (flag3 && furnaceBurnEvent.willConsumeFuel()) {
                        Item item = itemstack.g();
                        itemstack.h(1);
                        if (itemstack.e()) {
                            Item item1 = item.u();
                            blockEntity.l.set(1, item1 == null ? net.minecraft.world.item.ItemStack.l : new net.minecraft.world.item.ItemStack(item1));
                        }
                    }
                }
            }
            if (blockEntity.l() && TileEntityFurnace.a(world.H_(), recipeholder, blockEntity.l, i2)) {
                if (recipeholder != null && blockEntity.v == 0) {
                    CraftItemStack source = CraftItemStack.asCraftMirror(blockEntity.l.get(0));
                    CookingRecipe recipe = (CookingRecipe)recipeholder.toBukkitRecipe();
                    FurnaceStartSmeltEvent event = new FurnaceStartSmeltEvent((Block)CraftBlock.at(world, pos), (ItemStack)source, recipe, TileEntityFurnace.getTotalCookTime(world, blockEntity.recipeType, blockEntity, blockEntity.cookSpeedMultiplier));
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    blockEntity.w = event.getTotalCookTime();
                }
                ++blockEntity.v;
                if (blockEntity.v >= blockEntity.w) {
                    blockEntity.v = 0;
                    blockEntity.w = TileEntityFurnace.getTotalCookTime(world, blockEntity.recipeType, blockEntity, blockEntity.cookSpeedMultiplier);
                    if (TileEntityFurnace.burn(blockEntity.n, blockEntity.o, world.H_(), recipeholder, blockEntity.l, i2)) {
                        blockEntity.a(recipeholder);
                    }
                    flag1 = true;
                }
            } else {
                blockEntity.v = 0;
            }
        }
        if (flag != blockEntity.l()) {
            flag1 = true;
            state = (IBlockData)state.a(BlockFurnace.b, blockEntity.l());
            world.a(pos, state, 3);
        }
        if (flag1) {
            TileEntityFurnace.a(world, pos, state);
        }
    }

    private static boolean a(IRegistryCustom registryManager, @Nullable RecipeHolder<?> recipe, NonNullList<net.minecraft.world.item.ItemStack> slots, int count) {
        if (!slots.get(0).e() && recipe != null) {
            net.minecraft.world.item.ItemStack itemstack = recipe.b().a(registryManager);
            if (itemstack.e()) {
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack1 = slots.get(2);
            return itemstack1.e() ? true : (!net.minecraft.world.item.ItemStack.c(itemstack1, itemstack) ? false : (itemstack1.H() < count && itemstack1.H() < itemstack1.j() ? true : itemstack1.H() < itemstack.j()));
        }
        return false;
    }

    private static boolean burn(World world, BlockPosition blockposition, IRegistryCustom iregistrycustom, @Nullable RecipeHolder<?> recipeholder, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, int i2) {
        if (recipeholder != null && TileEntityFurnace.a(iregistrycustom, recipeholder, nonnulllist, i2)) {
            net.minecraft.world.item.ItemStack itemstack = nonnulllist.get(0);
            net.minecraft.world.item.ItemStack itemstack1 = recipeholder.b().a(iregistrycustom);
            net.minecraft.world.item.ItemStack itemstack2 = nonnulllist.get(2);
            CraftItemStack source = CraftItemStack.asCraftMirror(itemstack);
            ItemStack result = CraftItemStack.asBukkitCopy(itemstack1);
            FurnaceSmeltEvent furnaceSmeltEvent = new FurnaceSmeltEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)source, result, (CookingRecipe)recipeholder.toBukkitRecipe());
            world.getCraftServer().getPluginManager().callEvent((Event)furnaceSmeltEvent);
            if (furnaceSmeltEvent.isCancelled()) {
                return false;
            }
            result = furnaceSmeltEvent.getResult();
            itemstack1 = CraftItemStack.asNMSCopy(result);
            if (!itemstack1.e()) {
                if (itemstack2.e()) {
                    nonnulllist.set(2, itemstack1.s());
                } else if (CraftItemStack.asCraftMirror(itemstack2).isSimilar(result)) {
                    itemstack2.g(itemstack1.H());
                } else {
                    return false;
                }
            }
            if (itemstack.a(Blocks.aP.r()) && !nonnulllist.get(1).e() && nonnulllist.get(1).a(Items.qy)) {
                nonnulllist.set(1, new net.minecraft.world.item.ItemStack(Items.qz));
            }
            itemstack.h(1);
            return true;
        }
        return false;
    }

    protected int b(net.minecraft.world.item.ItemStack fuel) {
        if (fuel.e()) {
            return 0;
        }
        Item item = fuel.g();
        return TileEntityFurnace.g().getOrDefault(item, 0);
    }

    public static int getTotalCookTime(@Nullable World world, Recipes<? extends RecipeCooking> recipeType, TileEntityFurnace furnace, double cookSpeedMultiplier) {
        SingleRecipeInput singlerecipeinput = new SingleRecipeInput(furnace.a(0));
        int cookTime = world != null ? furnace.z.a(singlerecipeinput, world).map(holder -> ((RecipeCooking)holder.b()).d()).orElse(200) : MinecraftServer.getServer().aJ().a(recipeType, singlerecipeinput, world).map(holder -> ((RecipeCooking)holder.b()).d()).orElse(200);
        return (int)Math.ceil((double)cookTime / cookSpeedMultiplier);
    }

    public static boolean c(net.minecraft.world.item.ItemStack stack) {
        return TileEntityFurnace.g().containsKey(stack.g());
    }

    @Override
    public int[] a(EnumDirection side) {
        return side == EnumDirection.a ? r : (side == EnumDirection.b ? q : s);
    }

    @Override
    public boolean a(int slot, net.minecraft.world.item.ItemStack stack, @Nullable EnumDirection dir) {
        return this.b(slot, stack);
    }

    @Override
    public boolean b(int slot, net.minecraft.world.item.ItemStack stack, EnumDirection dir) {
        return dir == EnumDirection.a && slot == 1 ? stack.a(Items.qz) || stack.a(Items.qy) : true;
    }

    @Override
    public int b() {
        return this.l.size();
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> j() {
        return this.l;
    }

    @Override
    protected void a(NonNullList<net.minecraft.world.item.ItemStack> inventory) {
        this.l = inventory;
    }

    @Override
    public void a(int slot, net.minecraft.world.item.ItemStack stack) {
        net.minecraft.world.item.ItemStack itemstack1 = this.l.get(slot);
        boolean flag = !stack.e() && net.minecraft.world.item.ItemStack.c(itemstack1, stack);
        this.l.set(slot, stack);
        stack.f(this.e_(stack));
        if (slot == 0 && !flag) {
            this.w = TileEntityFurnace.getTotalCookTime(this.n, this.recipeType, this, this.cookSpeedMultiplier);
            this.v = 0;
            this.e();
        }
    }

    @Override
    public boolean b(int slot, net.minecraft.world.item.ItemStack stack) {
        if (slot == 2) {
            return false;
        }
        if (slot != 1) {
            return true;
        }
        net.minecraft.world.item.ItemStack itemstack1 = this.l.get(1);
        return TileEntityFurnace.c(stack) || stack.a(Items.qy) && !itemstack1.a(Items.qy);
    }

    @Override
    public void a(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            MinecraftKey minecraftkey = recipe.a();
            this.y.addTo((Object)minecraftkey, 1);
        }
    }

    @Override
    @Nullable
    public RecipeHolder<?> d() {
        return null;
    }

    @Override
    public void a(EntityHuman player, List<net.minecraft.world.item.ItemStack> ingredients) {
    }

    public void awardUsedRecipesAndPopExperience(EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(entityplayer.A(), entityplayer.dm(), this.o, entityplayer, itemstack, amount);
        entityplayer.a((Collection<RecipeHolder<?>>)list);
        for (RecipeHolder<?> recipeholder : list) {
            if (recipeholder == null) continue;
            entityplayer.a(recipeholder, this.l);
        }
        this.y.clear();
    }

    public List<RecipeHolder<?>> a(WorldServer world, Vec3D pos) {
        return this.getRecipesToAwardAndPopExperience(world, pos, this.o, null, null, 0);
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(WorldServer worldserver, Vec3D vec3d, BlockPosition blockposition, EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.y.object2IntEntrySet()) {
            worldserver.r().a((MinecraftKey)entry.getKey()).ifPresent(recipeholder -> {
                if (!(recipeholder.b() instanceof RecipeCooking)) {
                    return;
                }
                list.add(recipeholder);
                TileEntityFurnace.createExperience(worldserver, vec3d, entry.getIntValue(), ((RecipeCooking)recipeholder.b()).b(), blockposition, entityplayer, itemstack, amount);
            });
        }
        return list;
    }

    private static void createExperience(WorldServer worldserver, Vec3D vec3d, int i2, float f2, BlockPosition blockposition, EntityHuman entityhuman, net.minecraft.world.item.ItemStack itemstack, int amount) {
        int j2 = MathHelper.d((float)i2 * f2);
        float f1 = MathHelper.h((float)i2 * f2);
        if (f1 != 0.0f && Math.random() < (double)f1) {
            ++j2;
        }
        Object event = amount != 0 ? new FurnaceExtractEvent((Player)entityhuman.getBukkitEntity(), (Block)CraftBlock.at(worldserver, blockposition), CraftItemType.minecraftToBukkit(itemstack.g()), amount, j2) : new BlockExpEvent((Block)CraftBlock.at(worldserver, blockposition), j2);
        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        j2 = event.getExpToDrop();
        EntityExperienceOrb.award(worldserver, vec3d, j2, ExperienceOrb.SpawnReason.FURNACE, entityhuman);
    }

    @Override
    public void a(AutoRecipeStackManager finder) {
        finder.b(this.l.get(0));
        finder.b(this.l.get(2));
    }
}

