/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;

public final class TrialSpawner {
    public static final String a = "normal_config";
    public static final String b = "ominous_config";
    public static final int c = 40;
    private static final int d = 36000;
    private static final int e = 14;
    private static final int f = 47;
    private static final int g = MathHelper.h(47);
    private static final float h = 0.02f;
    public TrialSpawnerConfig i;
    public TrialSpawnerConfig j;
    private final TrialSpawnerData k;
    public int l;
    public int m;
    public final b n;
    private PlayerDetector o;
    private final PlayerDetector.a p;
    private boolean q;
    public boolean r;

    public Codec<TrialSpawner> a() {
        return RecordCodecBuilder.create(instance -> instance.group((App)TrialSpawnerConfig.b.optionalFieldOf(a, (Object)TrialSpawnerConfig.a).forGetter(TrialSpawner::c), (App)TrialSpawnerConfig.b.optionalFieldOf(b, (Object)TrialSpawnerConfig.a).forGetter(TrialSpawner::n), (App)TrialSpawnerData.b.forGetter(TrialSpawner::f), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(TrialSpawner::g), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(TrialSpawner::h)).apply((Applicative)instance, (trialspawnerconfig, trialspawnerconfig1, trialspawnerdata, integer, integer1) -> new TrialSpawner((TrialSpawnerConfig)trialspawnerconfig, (TrialSpawnerConfig)trialspawnerconfig1, (TrialSpawnerData)trialspawnerdata, (int)integer, (int)integer1, this.n, this.o, this.p)));
    }

    public TrialSpawner(b trialSpawner, PlayerDetector entityDetector, PlayerDetector.a entitySelector) {
        this(TrialSpawnerConfig.a, TrialSpawnerConfig.a, new TrialSpawnerData(), 36000, 14, trialSpawner, entityDetector, entitySelector);
    }

    public TrialSpawner(TrialSpawnerConfig normalConfig, TrialSpawnerConfig ominousConfig, TrialSpawnerData data, int cooldownLength, int entityDetectionRange, b trialSpawner, PlayerDetector entityDetector, PlayerDetector.a entitySelector) {
        this.i = normalConfig;
        this.j = ominousConfig;
        this.k = data;
        this.m = cooldownLength;
        this.l = entityDetectionRange;
        this.n = trialSpawner;
        this.o = entityDetector;
        this.p = entitySelector;
    }

    public TrialSpawnerConfig b() {
        return this.r ? this.j : this.i;
    }

    @VisibleForTesting
    public TrialSpawnerConfig c() {
        return this.i;
    }

    @VisibleForTesting
    public TrialSpawnerConfig d() {
        return this.j;
    }

    private TrialSpawnerConfig n() {
        return !this.j.equals(this.i) ? this.j : TrialSpawnerConfig.a;
    }

    public void a(WorldServer world, BlockPosition pos) {
        world.a(pos, (IBlockData)world.a_(pos).a(TrialSpawnerBlock.c, true), 3);
        world.c(3020, pos, 1);
        this.r = true;
        this.k.a(this, world);
    }

    public void b(WorldServer world, BlockPosition pos) {
        world.a(pos, (IBlockData)world.a_(pos).a(TrialSpawnerBlock.c, false), 3);
        this.r = false;
    }

    public boolean e() {
        return this.r;
    }

    public TrialSpawnerData f() {
        return this.k;
    }

    public int g() {
        return this.m;
    }

    public int h() {
        return this.l;
    }

    public TrialSpawnerState i() {
        return this.n.d();
    }

    public void a(World world, TrialSpawnerState spawnerState) {
        this.n.a(world, spawnerState);
    }

    public void j() {
        this.n.f();
    }

    public PlayerDetector k() {
        return this.o;
    }

    public PlayerDetector.a l() {
        return this.p;
    }

    public boolean a(World world) {
        return this.q ? true : (world.al() == EnumDifficulty.a ? false : world.ab().b(GameRules.e));
    }

    public Optional<UUID> c(WorldServer world, BlockPosition pos) {
        MobSpawnerData.a mobspawnerdata_a;
        double d2;
        RandomSource randomsource = world.E_();
        MobSpawnerData mobspawnerdata = this.k.b(this, world.E_());
        NBTTagCompound nbttagcompound = mobspawnerdata.d();
        NBTTagList nbttaglist = nbttagcompound.c("Pos", 6);
        Optional<EntityTypes<?>> optional = EntityTypes.a(nbttagcompound);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        int i2 = nbttaglist.size();
        double d0 = i2 >= 1 ? nbttaglist.h(0) : (double)pos.u() + (randomsource.j() - randomsource.j()) * (double)this.b().b() + 0.5;
        double d1 = i2 >= 2 ? nbttaglist.h(1) : (double)(pos.v() + randomsource.a(3) - 1);
        double d3 = d2 = i2 >= 3 ? nbttaglist.h(2) : (double)pos.w() + (randomsource.j() - randomsource.j()) * (double)this.b().b() + 0.5;
        if (!world.b(optional.get().a(d0, d1, d2))) {
            return Optional.empty();
        }
        Vec3D vec3d = new Vec3D(d0, d1, d2);
        if (!TrialSpawner.a((World)world, pos.b(), vec3d)) {
            return Optional.empty();
        }
        BlockPosition blockposition1 = BlockPosition.a(vec3d);
        if (!EntityPositionTypes.a(optional.get(), world, EnumMobSpawn.q, blockposition1, world.E_())) {
            return Optional.empty();
        }
        if (mobspawnerdata.b().isPresent() && !(mobspawnerdata_a = mobspawnerdata.b().get()).a(blockposition1, world)) {
            return Optional.empty();
        }
        Entity entity = EntityTypes.a(nbttagcompound, world, (Entity entity1) -> {
            entity1.b(d0, d1, d2, randomsource.i() * 360.0f, 0.0f);
            return entity1;
        });
        if (entity == null) {
            return Optional.empty();
        }
        if (entity instanceof EntityInsentient) {
            boolean flag;
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            if (!entityinsentient.a((IWorldReader)world)) {
                return Optional.empty();
            }
            boolean bl = flag = mobspawnerdata.a().f() == 1 && mobspawnerdata.a().b("id", 8);
            if (flag) {
                entityinsentient.a((WorldAccess)world, world.d_(entityinsentient.do()), EnumMobSpawn.q, (GroupDataEntity)null);
            }
            entityinsentient.fR();
            Optional<EquipmentTable> optional1 = mobspawnerdata.c();
            Objects.requireNonNull(entityinsentient);
            optional1.ifPresent(entityinsentient::a);
        }
        if (CraftEventFactory.callTrialSpawnerSpawnEvent(entity, pos).isCancelled()) {
            return Optional.empty();
        }
        if (!world.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.TRIAL_SPAWNER)) {
            return Optional.empty();
        }
        a trialspawner_a = this.r ? net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.b : net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.a;
        world.c(3011, pos, trialspawner_a.a());
        world.c(3012, blockposition1, trialspawner_a.a());
        world.a(entity, GameEvent.t, blockposition1);
        return Optional.of(entity.cz());
    }

    public void a(WorldServer world, BlockPosition pos, ResourceKey<LootTable> lootTable) {
        LootParams lootparams;
        LootTable loottable = world.o().be().b(lootTable);
        ObjectArrayList<ItemStack> objectarraylist = loottable.a(lootparams = new LootParams.a(world).a(LootContextParameterSets.b));
        if (!objectarraylist.isEmpty()) {
            for (ItemStack itemstack : objectarraylist) {
                DispenseBehaviorItem.a(world, itemstack, 2, EnumDirection.b, Vec3D.c(pos).a(EnumDirection.b, 1.2));
            }
            world.c(3014, pos, 0);
        }
    }

    public void a(World world, BlockPosition pos, boolean ominous) {
        RandomSource randomsource;
        TrialSpawnerState trialspawnerstate = this.i();
        trialspawnerstate.a(world, pos, ominous);
        if (trialspawnerstate.d()) {
            double d0 = Math.max(0L, this.k.f - world.Z());
            this.k.l = this.k.k;
            this.k.k = (this.k.k + trialspawnerstate.b() / (d0 + 200.0)) % 360.0;
        }
        if (trialspawnerstate.e() && (randomsource = world.E_()).i() <= 0.02f) {
            SoundEffect soundeffect = ominous ? SoundEffects.mj : SoundEffects.mi;
            world.a(pos, soundeffect, SoundCategory.e, randomsource.i() * 0.25f + 0.75f, randomsource.i() + 0.5f, false);
        }
    }

    public void a(WorldServer world, BlockPosition pos, boolean ominous) {
        TrialSpawnerState trialspawnerstate1;
        this.r = ominous;
        TrialSpawnerState trialspawnerstate = this.i();
        if (this.k.d.removeIf(uuid -> TrialSpawner.a(world, pos, uuid))) {
            this.k.f = world.Z() + (long)this.b().g();
        }
        if ((trialspawnerstate1 = trialspawnerstate.a(pos, this, world)) != trialspawnerstate) {
            this.a((World)world, trialspawnerstate1);
        }
    }

    private static boolean a(WorldServer world, BlockPosition pos, UUID uuid) {
        Entity entity = world.a(uuid);
        return entity == null || !entity.bE() || !entity.dO().af().equals(world.af()) || entity.do().j(pos) > (double)g;
    }

    private static boolean a(World world, Vec3D spawnerPos, Vec3D spawnPos) {
        MovingObjectPositionBlock movingobjectpositionblock = world.a(new RayTrace(spawnPos, spawnerPos, RayTrace.BlockCollisionOption.c, RayTrace.FluidCollisionOption.a, VoxelShapeCollision.a()));
        return movingobjectpositionblock.a().equals(BlockPosition.a(spawnerPos)) || movingobjectpositionblock.c() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public static void a(World world, BlockPosition pos, RandomSource random, ParticleType particle) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = (double)pos.u() + 0.5 + (random.j() - 0.5) * 2.0;
            double d1 = (double)pos.v() + 0.5 + (random.j() - 0.5) * 2.0;
            double d2 = (double)pos.w() + 0.5 + (random.j() - 0.5) * 2.0;
            world.a(Particles.ae, d0, d1, d2, 0.0, 0.0, 0.0);
            world.a(particle, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static void a(World world, BlockPosition pos, RandomSource random) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = (double)pos.u() + 0.5 + (random.j() - 0.5) * 2.0;
            double d1 = (double)pos.v() + 0.5 + (random.j() - 0.5) * 2.0;
            double d2 = (double)pos.w() + 0.5 + (random.j() - 0.5) * 2.0;
            double d3 = random.k() * 0.02;
            double d4 = random.k() * 0.02;
            double d5 = random.k() * 0.02;
            world.a(Particles.be, d0, d1, d2, d3, d4, d5);
            world.a(Particles.L, d0, d1, d2, d3, d4, d5);
        }
    }

    public static void a(World world, BlockPosition pos, RandomSource random, int playerCount, ParticleParam particle) {
        for (int j2 = 0; j2 < 30 + Math.min(playerCount, 10) * 5; ++j2) {
            double d0 = (double)(2.0f * random.i() - 1.0f) * 0.65;
            double d1 = (double)(2.0f * random.i() - 1.0f) * 0.65;
            double d2 = (double)pos.u() + 0.5 + d0;
            double d3 = (double)pos.v() + 0.1 + (double)random.i() * 0.8;
            double d4 = (double)pos.w() + 0.5 + d1;
            world.a(particle, d2, d3, d4, 0.0, 0.0, 0.0);
        }
    }

    public static void b(World world, BlockPosition pos, RandomSource random) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d0 = (double)pos.u() + 0.4 + random.j() * 0.2;
            double d1 = (double)pos.v() + 0.4 + random.j() * 0.2;
            double d2 = (double)pos.w() + 0.4 + random.j() * 0.2;
            double d3 = random.k() * 0.02;
            double d4 = random.k() * 0.02;
            double d5 = random.k() * 0.02;
            world.a(Particles.aJ, d0, d1, d2, d3, d4, d5 * 0.25);
            world.a(Particles.ae, d0, d1, d2, d3, d4, d5);
        }
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void a(PlayerDetector detector) {
        this.o = detector;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void m() {
        this.q = true;
    }

    public static interface b {
        public void a(World var1, TrialSpawnerState var2);

        public TrialSpawnerState d();

        public void f();
    }

    public static enum a {
        a(Particles.F),
        b(Particles.L);

        public final ParticleType c;

        private a(ParticleType particletype) {
            this.c = particletype;
        }

        public static a a(int index) {
            a[] atrialspawner_a = net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.values();
            return index <= atrialspawner_a.length && index >= 0 ? atrialspawner_a[index] : a;
        }

        public int a() {
            return this.ordinal();
        }
    }
}

