/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class RandomSpreadStructurePlacement
extends StructurePlacement {
    public static final MapCodec<RandomSpreadStructurePlacement> a = RecordCodecBuilder.mapCodec(instance -> RandomSpreadStructurePlacement.a(instance).and(instance.group((App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::a), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(RandomSpreadStructurePlacement::b), (App)RandomSpreadType.c.optionalFieldOf("spread_type", (Object)RandomSpreadType.a).forGetter(RandomSpreadStructurePlacement::c))).apply((Applicative)instance, RandomSpreadStructurePlacement::new)).validate(RandomSpreadStructurePlacement::a);
    private final int c;
    private final int d;
    private final RandomSpreadType e;

    private static DataResult<RandomSpreadStructurePlacement> a(RandomSpreadStructurePlacement structurePlacement) {
        if (structurePlacement.c <= structurePlacement.d) {
            return DataResult.error(() -> "Spacing has to be larger than separation");
        }
        return DataResult.success((Object)structurePlacement);
    }

    public RandomSpreadStructurePlacement(BaseBlockPosition locateOffset, StructurePlacement.c frequencyReductionMethod, float frequency, int salt, Optional<StructurePlacement.a> exclusionZone, int spacing, int separation, RandomSpreadType spreadType) {
        super(locateOffset, frequencyReductionMethod, frequency, salt, exclusionZone);
        this.c = spacing;
        this.d = separation;
        this.e = spreadType;
    }

    public RandomSpreadStructurePlacement(int spacing, int separation, RandomSpreadType spreadType, int salt) {
        this(BaseBlockPosition.g, StructurePlacement.c.a, 1.0f, salt, Optional.empty(), spacing, separation, spreadType);
    }

    public int a() {
        return this.c;
    }

    public int b() {
        return this.d;
    }

    public RandomSpreadType c() {
        return this.e;
    }

    public ChunkCoordIntPair a(long seed, int chunkX, int chunkZ) {
        int i2 = Math.floorDiv(chunkX, this.c);
        int j2 = Math.floorDiv(chunkZ, this.c);
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
        worldgenRandom.a(seed, i2, j2, this.i());
        int k2 = this.c - this.d;
        int l2 = this.e.a(worldgenRandom, k2);
        int m2 = this.e.a(worldgenRandom, k2);
        return new ChunkCoordIntPair(i2 * this.c + l2, j2 * this.c + m2);
    }

    @Override
    @Override
    protected boolean a(ChunkGeneratorStructureState calculator, int chunkX, int chunkZ) {
        ChunkCoordIntPair chunkPos = this.a(calculator.d(), chunkX, chunkZ);
        return chunkPos.e == chunkX && chunkPos.f == chunkZ;
    }

    @Override
    @Override
    public StructurePlacementType<?> e() {
        return StructurePlacementType.a;
    }
}

