/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.pathfinder.PathfindingContext;

public class PathfinderWater
extends PathfinderAbstract {
    private final boolean k;
    private final Long2ObjectMap<PathType> l = new Long2ObjectOpenHashMap();

    public PathfinderWater(boolean canJumpOutOfWater) {
        this.k = canJumpOutOfWater;
    }

    @Override
    @Override
    public void a(ChunkCache cachedWorld, EntityInsentient entity) {
        super.a(cachedWorld, entity);
        this.l.clear();
    }

    @Override
    @Override
    public void b() {
        super.b();
        this.l.clear();
    }

    @Override
    @Override
    public PathPoint a() {
        return this.c(MathHelper.a(this.b.cK().a), MathHelper.a(this.b.cK().b + 0.5), MathHelper.a(this.b.cK().c));
    }

    @Override
    @Override
    public PathDestination a(double x2, double y2, double z2) {
        return this.b(x2, y2, z2);
    }

    @Override
    @Override
    public int a(PathPoint[] successors, PathPoint node) {
        int i2 = 0;
        EnumMap map = Maps.newEnumMap(EnumDirection.class);
        for (EnumDirection direction : EnumDirection.values()) {
            PathPoint node2 = this.a(node.a + direction.j(), node.b + direction.k(), node.c + direction.l());
            map.put(direction, node2);
            if (!this.a(node2)) continue;
            successors[i2++] = node2;
        }
        for (EnumDirection direction2 : EnumDirection.EnumDirectionLimit.a) {
            PathPoint node3;
            EnumDirection direction3 = direction2.h();
            if (!PathfinderWater.b((PathPoint)map.get(direction2)) || !PathfinderWater.b((PathPoint)map.get(direction3)) || !this.a(node3 = this.a(node.a + direction2.j() + direction3.j(), node.b, node.c + direction2.l() + direction3.l()))) continue;
            successors[i2++] = node3;
        }
        return i2;
    }

    protected boolean a(@Nullable PathPoint node) {
        return node != null && !node.i;
    }

    private static boolean b(@Nullable PathPoint node) {
        return node != null && node.k >= 0.0f;
    }

    @Nullable
    protected PathPoint a(int x2, int y2, int z2) {
        float f2;
        PathPoint node = null;
        PathType pathType = this.b(x2, y2, z2);
        if ((this.k && pathType == PathType.u || pathType == PathType.j) && (f2 = this.b.a(pathType)) >= 0.0f) {
            node = this.c(x2, y2, z2);
            node.l = pathType;
            node.k = Math.max(node.k, f2);
            if (this.a.a().b_(new BlockPosition(x2, y2, z2)).c()) {
                node.k += 8.0f;
            }
        }
        return node;
    }

    protected PathType b(int x2, int y2, int z2) {
        return (PathType)((Object)this.l.computeIfAbsent(BlockPosition.a(x2, y2, z2), pos -> this.a(this.a, x2, y2, z2)));
    }

    @Override
    @Override
    public PathType a(PathfindingContext context, int x2, int y2, int z2) {
        return this.a(context, x2, y2, z2, this.b);
    }

    @Override
    @Override
    public PathType a(PathfindingContext context, int x2, int y2, int z2, EntityInsentient mob) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = x2; i2 < x2 + this.d; ++i2) {
            for (int j2 = y2; j2 < y2 + this.e; ++j2) {
                for (int k2 = z2; k2 < z2 + this.f; ++k2) {
                    IBlockData blockState = context.a(mutableBlockPos.d(i2, j2, k2));
                    Fluid fluidState = blockState.u();
                    if (fluidState.c() && blockState.a(PathMode.b) && blockState.i()) {
                        return PathType.u;
                    }
                    if (fluidState.a(TagsFluid.a)) continue;
                    return PathType.a;
                }
            }
        }
        IBlockData blockState2 = context.a(mutableBlockPos);
        if (blockState2.a(PathMode.b)) {
            return PathType.j;
        }
        return PathType.a;
    }
}

