/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class LootItemFunctionSetAttribute
extends LootItemFunctionConditional {
    public static final MapCodec<LootItemFunctionSetAttribute> a = RecordCodecBuilder.mapCodec(instance -> LootItemFunctionSetAttribute.a(instance).and(instance.group((App)net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetAttribute$b.a.listOf().fieldOf("modifiers").forGetter(function -> function.b), (App)Codec.BOOL.optionalFieldOf("replace", (Object)true).forGetter(lootFunction -> lootFunction.c))).apply((Applicative)instance, LootItemFunctionSetAttribute::new));
    private final List<b> b;
    private final boolean c;

    LootItemFunctionSetAttribute(List<LootItemCondition> conditions, List<b> attributes, boolean replace) {
        super(conditions);
        this.b = List.copyOf(attributes);
        this.c = replace;
    }

    @Override
    public LootItemFunctionType<LootItemFunctionSetAttribute> b() {
        return LootItemFunctions.o;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> a() {
        return (Set)this.b.stream().flatMap(attribute -> attribute.e.a().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        if (this.c) {
            stack.b(DataComponents.n, this.a(context, ItemAttributeModifiers.a));
        } else {
            stack.a(DataComponents.n, ItemAttributeModifiers.a, component -> {
                if (component.b().isEmpty()) {
                    return this.a(context, stack.g().j());
                }
                return this.a(context, (ItemAttributeModifiers)component);
            });
        }
        return stack;
    }

    private ItemAttributeModifiers a(LootTableInfo context, ItemAttributeModifiers attributeModifiersComponent) {
        RandomSource randomSource = context.b();
        for (b modifier : this.b) {
            EquipmentSlotGroup equipmentSlotGroup = SystemUtils.a(modifier.f, randomSource);
            attributeModifiersComponent = attributeModifiersComponent.a(modifier.c, new AttributeModifier(modifier.b, modifier.e.b(context), modifier.d), equipmentSlotGroup);
        }
        return attributeModifiersComponent;
    }

    public static c a(MinecraftKey id, Holder<AttributeBase> attribute, AttributeModifier.Operation operation, NumberProvider amountRange) {
        return new c(id, attribute, operation, amountRange);
    }

    public static a c() {
        return new a();
    }

    static final class b
    extends Record {
        private final MinecraftKey b;
        private final Holder<AttributeBase> c;
        private final AttributeModifier.Operation d;
        private final NumberProvider e;
        private final List<EquipmentSlotGroup> f;
        private static final Codec<List<EquipmentSlotGroup>> g = ExtraCodecs.a(Codec.either(EquipmentSlotGroup.l, (Codec)EquipmentSlotGroup.l.listOf()).xmap(either -> either.map(List::of, Function.identity()), slots -> slots.size() == 1 ? Either.left((EquipmentSlotGroup)slots.getFirst()) : Either.right(slots)));
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)MinecraftKey.a.fieldOf("id").forGetter(b::a), (App)AttributeBase.a.fieldOf("attribute").forGetter(b::b), (App)AttributeModifier.Operation.f.fieldOf("operation").forGetter(b::c), (App)NumberProviders.a.fieldOf("amount").forGetter(b::d), (App)g.fieldOf("slot").forGetter(b::e)).apply((Applicative)instance, b::new));

        b(MinecraftKey resourceLocation, Holder<AttributeBase> holder, AttributeModifier.Operation operation, NumberProvider amount, List<EquipmentSlotGroup> list) {
            this.b = resourceLocation;
            this.c = holder;
            this.d = operation;
            this.e = amount;
            this.f = list;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "id;attribute;operation;amount;slots", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "id;attribute;operation;amount;slots", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "id;attribute;operation;amount;slots", "b", "c", "d", "e", "f"}, this, object);
        }

        public MinecraftKey a() {
            return this.b;
        }

        public Holder<AttributeBase> b() {
            return this.c;
        }

        public AttributeModifier.Operation c() {
            return this.d;
        }

        public NumberProvider d() {
            return this.e;
        }

        public List<EquipmentSlotGroup> e() {
            return this.f;
        }
    }

    public static class c {
        private final MinecraftKey a;
        private final Holder<AttributeBase> b;
        private final AttributeModifier.Operation c;
        private final NumberProvider d;
        private final Set<EquipmentSlotGroup> e = EnumSet.noneOf(EquipmentSlotGroup.class);

        public c(MinecraftKey id, Holder<AttributeBase> attribute, AttributeModifier.Operation operation, NumberProvider amount) {
            this.a = id;
            this.b = attribute;
            this.c = operation;
            this.d = amount;
        }

        public c a(EquipmentSlotGroup slot) {
            this.e.add(slot);
            return this;
        }

        public b a() {
            return new b(this.a, this.b, this.c, this.d, List.copyOf(this.e));
        }
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final boolean a;
        private final List<b> b = Lists.newArrayList();

        public a(boolean replace) {
            this.a = replace;
        }

        public a() {
            this(false);
        }

        @Override
        protected a a() {
            return this;
        }

        public a a(c attribute) {
            this.b.add(attribute.a());
            return this;
        }

        @Override
        @Override
        public LootItemFunction b() {
            return new LootItemFunctionSetAttribute(this.g(), this.b, this.a);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a c() {
            return this.a();
        }
    }
}

