/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.DecoratedPot;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryDecoratedPot;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.inventory.DecoratedPotInventory;
import org.bukkit.loot.LootTable;

public class CraftDecoratedPot
extends CraftBlockEntityState<DecoratedPotBlockEntity>
implements DecoratedPot {
    public CraftDecoratedPot(World world, DecoratedPotBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftDecoratedPot(CraftDecoratedPot state, Location location) {
        super(state, location);
    }

    public DecoratedPotInventory getSnapshotInventory() {
        return new CraftInventoryDecoratedPot((IInventory)this.getSnapshot());
    }

    public DecoratedPotInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryDecoratedPot((IInventory)this.getTileEntity());
    }

    public void setLootTable(LootTable table) {
        this.setLootTable(table, this.getSeed());
    }

    public void setLootTable(LootTable table, long seed) {
        ((DecoratedPotBlockEntity)this.getSnapshot()).a(CraftLootTable.bukkitToMinecraft(table), seed);
    }

    public LootTable getLootTable() {
        return CraftLootTable.minecraftToBukkit(((DecoratedPotBlockEntity)this.getSnapshot()).aB_());
    }

    public void setSeed(long seed) {
        ((DecoratedPotBlockEntity)this.getSnapshot()).a(seed);
    }

    public long getSeed() {
        return ((DecoratedPotBlockEntity)this.getSnapshot()).aC_();
    }

    public void setSherd(DecoratedPot.Side face, Material sherd) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        Preconditions.checkArgument((sherd == null || sherd == Material.BRICK || Tag.ITEMS_DECORATED_POT_SHERDS.isTagged((Keyed)sherd) ? 1 : 0) != 0, (String)"sherd is not a valid sherd material: %s", (Object)sherd);
        Optional<Item> sherdItem = sherd != null ? Optional.of(CraftItemType.bukkitToMinecraft(sherd)) : Optional.of(Items.qL);
        PotDecorations decorations = ((DecoratedPotBlockEntity)this.getSnapshot()).l();
        switch (face) {
            case BACK: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).k = new PotDecorations(sherdItem, decorations.c(), decorations.d(), decorations.e());
                break;
            }
            case LEFT: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).k = new PotDecorations(decorations.b(), sherdItem, decorations.d(), decorations.e());
                break;
            }
            case RIGHT: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).k = new PotDecorations(decorations.b(), decorations.c(), sherdItem, decorations.e());
                break;
            }
            case FRONT: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).k = new PotDecorations(decorations.b(), decorations.c(), decorations.d(), sherdItem);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(face));
            }
        }
    }

    public Material getSherd(DecoratedPot.Side face) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        PotDecorations decorations = ((DecoratedPotBlockEntity)this.getSnapshot()).l();
        Optional<Item> sherdItem = switch (face) {
            case DecoratedPot.Side.BACK -> decorations.b();
            case DecoratedPot.Side.LEFT -> decorations.c();
            case DecoratedPot.Side.RIGHT -> decorations.d();
            case DecoratedPot.Side.FRONT -> decorations.e();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(face));
        };
        return CraftItemType.minecraftToBukkit(sherdItem.orElse(Items.qL));
    }

    public Map<DecoratedPot.Side, Material> getSherds() {
        PotDecorations decorations = ((DecoratedPotBlockEntity)this.getSnapshot()).l();
        EnumMap<DecoratedPot.Side, Material> sherds = new EnumMap<DecoratedPot.Side, Material>(DecoratedPot.Side.class);
        sherds.put(DecoratedPot.Side.BACK, CraftItemType.minecraftToBukkit(decorations.b().orElse(Items.qL)));
        sherds.put(DecoratedPot.Side.LEFT, CraftItemType.minecraftToBukkit(decorations.c().orElse(Items.qL)));
        sherds.put(DecoratedPot.Side.RIGHT, CraftItemType.minecraftToBukkit(decorations.d().orElse(Items.qL)));
        sherds.put(DecoratedPot.Side.FRONT, CraftItemType.minecraftToBukkit(decorations.e().orElse(Items.qL)));
        return sherds;
    }

    public List<Material> getShards() {
        return ((DecoratedPotBlockEntity)this.getSnapshot()).l().a().stream().map(CraftItemType::minecraftToBukkit).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public CraftDecoratedPot copy() {
        return new CraftDecoratedPot(this, null);
    }

    @Override
    public CraftDecoratedPot copy(Location location) {
        return new CraftDecoratedPot(this, location);
    }
}

