/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.block.BlockComposter;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockType;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R1.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemMetas;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R1.util.Handleable;
import org.bukkit.inventory.CreativeCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftItemType<M extends ItemMeta>
implements ItemType.Typed<M>,
Handleable<Item> {
    private final NamespacedKey key;
    private final Item item;
    private final Supplier<CraftItemMetas.ItemMetaData<M>> itemMetaData;

    public static Material minecraftToBukkit(Item item) {
        return CraftMagicNumbers.getMaterial(item);
    }

    public static Item bukkitToMinecraft(Material material) {
        return CraftMagicNumbers.getItem(material);
    }

    public static ItemType minecraftToBukkitNew(Item minecraft) {
        return (ItemType)CraftRegistry.minecraftToBukkit(minecraft, Registries.K, Registry.ITEM);
    }

    public static Item bukkitToMinecraftNew(ItemType bukkit) {
        return (Item)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public CraftItemType(NamespacedKey key, Item item) {
        this.key = key;
        this.item = item;
        this.itemMetaData = Suppliers.memoize(() -> CraftItemMetas.getItemMetaData(this));
    }

    @NotNull
    public ItemType.Typed<ItemMeta> typed() {
        return this.typed(ItemMeta.class);
    }

    @NotNull
    public <Other extends ItemMeta> ItemType.Typed<Other> typed(@NotNull Class<Other> itemMetaType) {
        if (itemMetaType.isAssignableFrom(this.itemMetaData.get().metaClass())) {
            return this;
        }
        throw new IllegalArgumentException("Cannot type item type " + this.key.toString() + " to meta type " + itemMetaType.getSimpleName());
    }

    @NotNull
    public ItemStack createItemStack() {
        return this.createItemStack(1, null);
    }

    @NotNull
    public ItemStack createItemStack(int amount) {
        return this.createItemStack(amount, null);
    }

    @NotNull
    public ItemStack createItemStack(Consumer<? super M> metaConfigurator) {
        return this.createItemStack(1, metaConfigurator);
    }

    @NotNull
    public ItemStack createItemStack(int amount, @Nullable Consumer<? super M> metaConfigurator) {
        net.minecraft.world.item.ItemStack stack = new net.minecraft.world.item.ItemStack(this.item, amount);
        CraftItemStack mirror = CraftItemStack.asCraftMirror(stack);
        if (metaConfigurator != null) {
            mirror.editMeta(this.getItemMetaClass(), metaConfigurator);
        }
        return mirror;
    }

    @Override
    public Item getHandle() {
        return this.item;
    }

    public M getItemMeta(net.minecraft.world.item.ItemStack itemStack, Set<DataComponentType<?>> extraHandledDcts) {
        return (M)((ItemMeta)this.itemMetaData.get().fromItemStack().apply(itemStack, extraHandledDcts));
    }

    public M getItemMeta(ItemMeta itemMeta) {
        return (M)((ItemMeta)this.itemMetaData.get().fromItemMeta().apply(this, (CraftMetaItem)itemMeta));
    }

    public boolean hasBlockType() {
        return this.item instanceof ItemBlock;
    }

    @NotNull
    public BlockType getBlockType() {
        Item item = this.item;
        if (!(item instanceof ItemBlock)) {
            throw new IllegalStateException("The item type " + String.valueOf(this.getKey()) + " has no corresponding block type");
        }
        ItemBlock block = (ItemBlock)item;
        return CraftBlockType.minecraftToBukkitNew(block.d());
    }

    public Class<M> getItemMetaClass() {
        if (this == ItemType.AIR) {
            throw new UnsupportedOperationException("Air does not have ItemMeta");
        }
        return this.itemMetaData.get().metaClass();
    }

    public int getMaxStackSize() {
        if (this == AIR) {
            return 0;
        }
        return this.item.p().a(DataComponents.c, 64);
    }

    public short getMaxDurability() {
        return this.item.p().a(DataComponents.d, 0).shortValue();
    }

    public boolean isEdible() {
        return this.item.p().b(DataComponents.v);
    }

    public boolean isRecord() {
        return this.item.p().b(DataComponents.R);
    }

    public boolean isFuel() {
        return TileEntityFurnace.c(new net.minecraft.world.item.ItemStack(this.item));
    }

    public boolean isCompostable() {
        return BlockComposter.f.containsKey((Object)this.item);
    }

    public float getCompostChance() {
        Preconditions.checkArgument((boolean)this.isCompostable(), (Object)("The item type " + String.valueOf(this.getKey()) + " is not compostable"));
        return BlockComposter.f.getFloat((Object)this.item);
    }

    public ItemType getCraftingRemainingItem() {
        Item expectedItem = this.item.u();
        return expectedItem == null ? null : CraftItemType.minecraftToBukkitNew(expectedItem);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers() {
        return this.getDefaultAttributeModifiers((EquipmentSlotGroup sg) -> true);
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(EquipmentSlot slot) {
        EnumItemSlot nmsSlot = CraftEquipmentSlot.getNMS(slot);
        return this.getDefaultAttributeModifiers((EquipmentSlotGroup sg) -> sg.b(nmsSlot));
    }

    private Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(Predicate<EquipmentSlotGroup> slotPredicate) {
        ImmutableMultimap.Builder defaultAttributes = ImmutableMultimap.builder();
        ItemAttributeModifiers nmsDefaultAttributes = this.item.p().a(DataComponents.n, ItemAttributeModifiers.a);
        if (nmsDefaultAttributes.b().isEmpty()) {
            nmsDefaultAttributes = this.item.j();
        }
        for (ItemAttributeModifiers.b entry : nmsDefaultAttributes.b()) {
            if (!slotPredicate.test(entry.c())) continue;
            Attribute attribute = CraftAttribute.minecraftHolderToBukkit(entry.a());
            AttributeModifier modifier = CraftAttributeInstance.convert(entry.b(), entry.c());
            defaultAttributes.put((Object)attribute, (Object)modifier);
        }
        return defaultAttributes.build();
    }

    public CreativeCategory getCreativeCategory() {
        return CreativeCategory.BUILDING_BLOCKS;
    }

    public boolean isEnabledByFeature(@NotNull World world) {
        Preconditions.checkNotNull((Object)world, (Object)"World cannot be null");
        return this.getHandle().a(((CraftWorld)world).getHandle().J());
    }

    @NotNull
    public String getTranslationKey() {
        return this.item.a();
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public Material asMaterial() {
        return (Material)Registry.MATERIAL.get(this.key);
    }

    public String translationKey() {
        return this.item.a();
    }

    public ItemRarity getItemRarity() {
        EnumItemRarity rarity = this.item.p().a(DataComponents.j);
        return rarity == null ? null : ItemRarity.valueOf((String)rarity.name());
    }
}

