/*
 * Decompiled with CFR 0.152.
 */
package com.buildkillreign.base;

import com.buildkillreign.base.Main;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wither;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Functions {
    public static Main mainClass;
    public static Location emptyLocation;
    public static ProtocolManager pmBoard;
    public static Hashtable<UUID, String[]> listBoard;

    public static void initPlayer(Player player) {
        if (mainClass.getConfig().contains("players." + player.getUniqueId().toString())) {
            return;
        }
        mainClass.getConfig().set("players." + player.getUniqueId().toString() + ".name", (Object)player.getName());
        mainClass.getConfig().set("players." + player.getUniqueId().toString() + ".death", (Object)0);
        mainClass.getConfig().set("players." + player.getUniqueId().toString() + ".lvl", (Object)-1);
        mainClass.getConfig().set("players." + player.getUniqueId().toString() + ".exp", (Object)0);
        mainClass.getConfig().set("players." + player.getUniqueId().toString() + ".zone", (Object)1);
        mainClass.getConfig().set("players." + player.getUniqueId().toString() + ".gui", (Object)true);
    }

    public static boolean coreOldPlayer(Player player) {
        if (mainClass.getConfig().getString("players." + player.getUniqueId().toString() + ".name").charAt(0) == '+') {
            mainClass.getConfig().set("players." + player.getUniqueId().toString() + ".name", (Object)player.getName());
            return true;
        }
        return false;
    }

    public static void coreBackupPlayer(Player player) {
        Location location = player.getLocation();
        mainClass.getConfig().set("locs." + player.getUniqueId().toString() + ".w", (Object)location.getWorld().getName());
        mainClass.getConfig().set("locs." + player.getUniqueId().toString() + ".x", (Object)location.getX());
        mainClass.getConfig().set("locs." + player.getUniqueId().toString() + ".y", (Object)location.getY());
        mainClass.getConfig().set("locs." + player.getUniqueId().toString() + ".z", (Object)location.getZ());
    }

    public static Location coreRestorePlayer(Player player, boolean check) {
        if (!mainClass.getConfig().contains("locs." + player.getUniqueId().toString())) {
            return null;
        }
        if (check) {
            return emptyLocation;
        }
        World world = Bukkit.getServer().getWorld(mainClass.getConfig().getString("locs." + player.getUniqueId().toString() + ".w"));
        double x = mainClass.getConfig().getDouble("locs." + player.getUniqueId().toString() + ".x");
        double y = mainClass.getConfig().getDouble("locs." + player.getUniqueId().toString() + ".y");
        double z = mainClass.getConfig().getDouble("locs." + player.getUniqueId().toString() + ".z");
        mainClass.getConfig().set("locs." + player.getUniqueId().toString(), null);
        return new Location(world, x, y, z);
    }

    public static Location coreSpawnPlayer(Player player) {
        mainClass.getConfig().set("players." + player.getUniqueId().toString() + ".zone", (Object)1);
        Functions.updatePlayerScore(player);
        World overworld = (World)Bukkit.getServer().getWorlds().get(0);
        int x = (int)Math.floor(Math.random() * 256.0 - 128.0);
        int z = (int)Math.floor(Math.random() * 256.0 - 128.0);
        int y = overworld.getHighestBlockYAt(x, z) + 1;
        for (int i = 0; i < 160 && (overworld.getBlockAt(x, y - 1, z).isLiquid() || overworld.getBlockAt(x, y, z).getType() == Material.FIRE); ++i) {
            z = z > 0 ? ++z : --z;
            y = overworld.getHighestBlockYAt(x, z) + 1;
        }
        Location spawn = new Location(overworld, (double)x, (double)y, (double)z);
        return spawn;
    }

    public static Location respawnPlayer(Player player, int cornerN) {
        String corner;
        World overworld = (World)Bukkit.getServer().getWorlds().get(0);
        int x = 70937 + (int)Math.floor(Math.random() * 256.0);
        int z = 70937 + (int)Math.floor(Math.random() * 256.0);
        if (cornerN < 0) {
            cornerN = (int)Math.floor(Math.random() * 4.0);
        }
        switch (cornerN) {
            case 0: {
                corner = "South-West";
                x = -x;
                break;
            }
            case 1: {
                corner = "North-East";
                z = -z;
                break;
            }
            case 2: {
                corner = "North-West";
                x = -x;
                z = -z;
                break;
            }
            default: {
                corner = "South-East";
            }
        }
        int y = overworld.getHighestBlockYAt(x, z) + 1;
        for (int i = 0; i < 160 && (overworld.getBlockAt(x, y - 1, z).isLiquid() || overworld.getBlockAt(x, y, z).getType() == Material.FIRE); ++i) {
            z = z > 0 ? ++z : --z;
            y = overworld.getHighestBlockYAt(x, z) + 1;
        }
        Location spawn = new Location(overworld, (double)x, (double)y, (double)z);
        player.setBedSpawnLocation(spawn, true);
        player.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "You spawned near the " + String.valueOf(ChatColor.DARK_AQUA) + String.valueOf(ChatColor.BOLD) + corner + String.valueOf(ChatColor.DARK_GREEN) + " corner's end portal.");
        return spawn;
    }

    public static void createPlayerScore(Player player) {
        Functions.createBoard(player, String.valueOf(ChatColor.GRAY) + "-- Profile --", 6);
    }

    public static void updatePlayerScore(Player player) {
        int playerLvl = mainClass.getConfig().getInt("players." + player.getUniqueId().toString() + ".lvl");
        int playerExp = mainClass.getConfig().getInt("players." + player.getUniqueId().toString() + ".exp");
        int playerZone = mainClass.getConfig().getInt("players." + player.getUniqueId().toString() + ".zone");
        Functions.updateBoard(player, String.valueOf(ChatColor.DARK_RED) + "LVL  " + String.valueOf(ChatColor.WHITE) + playerLvl, 5);
        Functions.updateBoard(player, " ", 4);
        Functions.updateBoard(player, String.valueOf(ChatColor.YELLOW) + "EXP  " + String.valueOf(ChatColor.WHITE) + playerExp + " /", 3);
        Functions.updateBoard(player, String.valueOf(ChatColor.YELLOW) + "---  " + String.valueOf(ChatColor.WHITE) + Functions.getLvlExp(playerLvl + 1), 2);
        Functions.updateBoard(player, "  ", 1);
        Functions.updateBoard(player, String.valueOf(ChatColor.BLUE) + "ZONE " + String.valueOf(ChatColor.WHITE) + (51 - playerZone), 0);
        ChatColor lvlColor = playerLvl < 10 ? ChatColor.DARK_GRAY : (playerLvl < 20 ? ChatColor.GRAY : (playerLvl < 30 ? ChatColor.YELLOW : (playerLvl < 40 ? ChatColor.GOLD : (playerLvl < 50 ? ChatColor.RED : (playerLvl < 100 ? ChatColor.DARK_RED : ChatColor.DARK_PURPLE)))));
        ChatColor tierColor = mainClass.getConfig().contains("players." + player.getUniqueId().toString() + ".blue") && mainClass.getConfig().getInt("players." + player.getUniqueId().toString() + ".blue") + 3196800 > (int)(new Date().getTime() / 1000L) ? ChatColor.BLUE : (mainClass.getConfig().contains("players." + player.getUniqueId().toString() + ".aqua") && mainClass.getConfig().getInt("players." + player.getUniqueId().toString() + ".aqua") + 3196800 > (int)(new Date().getTime() / 1000L) ? ChatColor.AQUA : (mainClass.getConfig().contains("players." + player.getUniqueId().toString() + ".italic") && mainClass.getConfig().getInt("players." + player.getUniqueId().toString() + ".italic") + 3196800 > (int)(new Date().getTime() / 1000L) ? ChatColor.ITALIC : ChatColor.RESET));
        player.setDisplayName("[" + String.valueOf(lvlColor) + playerLvl + String.valueOf(ChatColor.RESET) + "] " + String.valueOf(tierColor) + player.getName() + String.valueOf(ChatColor.RESET));
        player.setPlayerListName(String.valueOf(lvlColor) + String.valueOf(ChatColor.ITALIC) + playerLvl + " " + String.valueOf(ChatColor.RESET) + String.valueOf(tierColor) + player.getName());
    }

    public static void removePlayerScore(Player player) {
        Functions.removeBoard(player.getUniqueId());
    }

    public static void addPlayerExp(Player player, int exp) {
        int lvl = mainClass.getConfig().getInt("players." + player.getUniqueId().toString() + ".lvl");
        exp += mainClass.getConfig().getInt("players." + player.getUniqueId().toString() + ".exp");
        while (exp >= Functions.getLvlExp(lvl + 1)) {
            exp -= Functions.getLvlExp(++lvl);
        }
        while (exp < 0 && lvl > 1) {
            exp += Functions.getLvlExp(lvl);
            --lvl;
        }
        mainClass.getConfig().set("players." + player.getUniqueId().toString() + ".lvl", (Object)lvl);
        mainClass.getConfig().set("players." + player.getUniqueId().toString() + ".exp", (Object)exp);
        Functions.updatePlayerScore(player);
    }

    public static int getPlayerExp(Player player) {
        int lvl = mainClass.getConfig().getInt("players." + player.getUniqueId().toString() + ".lvl");
        if (lvl < 0) {
            return -1;
        }
        int exp = mainClass.getConfig().getInt("players." + player.getUniqueId().toString() + ".exp");
        return Functions.getLvlExpTot(lvl) + exp;
    }

    public static void resetPlayerExp(Player player, boolean spawned) {
        if (spawned) {
            mainClass.getConfig().set("players." + player.getUniqueId().toString() + ".lvl", (Object)1);
        } else {
            mainClass.getConfig().set("players." + player.getUniqueId().toString() + ".lvl", (Object)-1);
        }
        mainClass.getConfig().set("players." + player.getUniqueId().toString() + ".exp", (Object)0);
        Functions.updatePlayerScore(player);
    }

    public static void updatePlayerZone(Player player) {
        int lastZone;
        int thisZone = Functions.getZone(player.getLocation());
        if (thisZone == (lastZone = mainClass.getConfig().getInt("players." + player.getUniqueId().toString() + ".zone"))) {
            return;
        }
        int lvl = mainClass.getConfig().getInt("players." + player.getUniqueId().toString() + ".lvl");
        if (lastZone > thisZone && 51 - thisZone > lvl && 51 - lastZone <= lvl) {
            player.sendTitle(String.valueOf(ChatColor.RED) + "Warning!", String.valueOf(ChatColor.RED) + "Leaving your zones! Walk back if lost.", 5, 120, 10);
        } else if (lastZone < thisZone && 51 - thisZone <= lvl && 51 - lastZone > lvl) {
            player.sendTitle(String.valueOf(ChatColor.GREEN) + "Good!", String.valueOf(ChatColor.GREEN) + "Leaving high zones! Come back leveled up.", 5, 120, 10);
        }
        mainClass.getConfig().set("players." + player.getUniqueId().toString() + ".zone", (Object)thisZone);
        Functions.updatePlayerScore(player);
    }

    public static boolean checkPlayerZone(Player player, Location location) {
        int playerLvl = mainClass.getConfig().getInt("players." + player.getUniqueId().toString() + ".lvl");
        return playerLvl >= 51 - Functions.getZone(location);
    }

    public static void updatePlayerDeath(UUID uuid, boolean dead) {
        int death = 0;
        if (dead) {
            death = (int)(new Date().getTime() / 1000L);
        }
        mainClass.getConfig().set("players." + uuid.toString() + ".death", (Object)death);
    }

    public static int checkPlayerDeath(UUID uuid) {
        int death = mainClass.getConfig().getInt("players." + uuid.toString() + ".death");
        if ((death -= (int)(new Date().getTime() / 1000L) - 72000) < 0) {
            return 0;
        }
        return death;
    }

    public static boolean togglePlayerCompass(Player player) {
        boolean playerGui = !mainClass.getConfig().getBoolean("players." + player.getUniqueId().toString() + ".gui");
        mainClass.getConfig().set("players." + player.getUniqueId().toString() + ".gui", (Object)playerGui);
        return playerGui;
    }

    public static void updatePlayerCompass(Player player) {
        if (!mainClass.getConfig().getBoolean("players." + player.getUniqueId().toString() + ".gui")) {
            return;
        }
        double rotation = (player.getEyeLocation().getYaw() - 180.0f) % 360.0f;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        String separator = " ---- ";
        Object data = " ---- W ---- N ---- E ---- S";
        int start = (int)Math.round(rotation * (double)((String)data).length() / 360.0);
        data = String.valueOf(ChatColor.GRAY) + "|" + ((String)data).substring(start) + ((String)data).substring(0, start) + "|";
        int spawn = 0;
        switch (player.getWorld().getEnvironment()) {
            case NORMAL: {
                spawn = (int)Math.floor(Math.sqrt(Math.pow(Math.abs(Math.abs(player.getLocation().getBlockX()) - 71065), 2.0) + Math.pow(Math.abs(Math.abs(player.getLocation().getBlockZ()) - 71065), 2.0)));
                break;
            }
            case NETHER: {
                spawn = (int)Math.floor(Math.sqrt(Math.pow(Math.abs(Math.abs(player.getLocation().getBlockX()) - 8883), 2.0) + Math.pow(Math.abs(Math.abs(player.getLocation().getBlockZ()) - 8883), 2.0)));
                break;
            }
            case THE_END: 
            case CUSTOM: {
                spawn = -1;
            }
        }
        data = String.valueOf(ChatColor.WHITE) + "Portal " + String.valueOf(ChatColor.DARK_AQUA) + spawn + "  " + (String)data;
        data = (String)data + String.valueOf(ChatColor.WHITE) + "  Core " + String.valueOf(ChatColor.DARK_AQUA) + (int)Math.floor(Math.sqrt(Math.pow(Math.abs(player.getLocation().getBlockX()), 2.0) + Math.pow(Math.abs(player.getLocation().getBlockZ()), 2.0)));
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)data));
    }

    public static void openPlayerTutorial(Player player) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta bookMeta = (BookMeta)book.getItemMeta();
        bookMeta.setTitle("Tutorial");
        bookMeta.setAuthor("MrTutorial");
        bookMeta.addPage(new String[]{"The center of the map is the " + String.valueOf(ChatColor.DARK_AQUA) + "core" + String.valueOf(ChatColor.BLACK) + " (x0, z0). Everyone initially spawns/respawns near the " + String.valueOf(ChatColor.DARK_AQUA) + "core" + String.valueOf(ChatColor.BLACK) + ". You can't do anything there if you don't first reach " + String.valueOf(ChatColor.DARK_RED) + "level" + String.valueOf(ChatColor.BLACK) + " 50. " + String.valueOf(ChatColor.DARK_RED) + "Level" + String.valueOf(ChatColor.BLACK) + " 50 is the max usefull " + String.valueOf(ChatColor.DARK_RED) + "level" + String.valueOf(ChatColor.BLACK) + " on the server: with it you unlock all the map (the maximum " + String.valueOf(ChatColor.DARK_BLUE) + "zone" + String.valueOf(ChatColor.BLACK) + " is 50).\n" + String.valueOf(ChatColor.GRAY) + "How do I level up? ->"});
        bookMeta.addPage(new String[]{"First, you must spawn at a " + String.valueOf(ChatColor.GOLD) + "spawn corner" + String.valueOf(ChatColor.BLACK) + ". Type " + String.valueOf(ChatColor.GOLD) + "/spawncorner" + String.valueOf(ChatColor.BLACK) + " and the corner you want to do so (it can only be done once per respawn). Then, you will be able to do everything, as they are in " + String.valueOf(ChatColor.DARK_BLUE) + "zone" + String.valueOf(ChatColor.BLACK) + " 1, far from the " + String.valueOf(ChatColor.DARK_AQUA) + "core" + String.valueOf(ChatColor.BLACK) + ". " + String.valueOf(ChatColor.DARK_RED) + "Level" + String.valueOf(ChatColor.BLACK) + " up by using lapis or quartzs via crafting.\n" + String.valueOf(ChatColor.GRAY) + "How do zones work? >"});
        bookMeta.addPage(new String[]{"The closer you get to the " + String.valueOf(ChatColor.DARK_AQUA) + "core" + String.valueOf(ChatColor.BLACK) + ", the higher the " + String.valueOf(ChatColor.DARK_BLUE) + "zone" + String.valueOf(ChatColor.BLACK) + ". The four " + String.valueOf(ChatColor.GOLD) + "spawn corners" + String.valueOf(ChatColor.BLACK) + " are situated near the border between " + String.valueOf(ChatColor.DARK_BLUE) + "zone" + String.valueOf(ChatColor.BLACK) + " 1 and " + String.valueOf(ChatColor.DARK_BLUE) + "zone" + String.valueOf(ChatColor.BLACK) + " 2. " + String.valueOf(ChatColor.DARK_BLUE) + "Zone" + String.valueOf(ChatColor.BLACK) + " 1 is the biggest one, as it extends from the 2nd to the end of the world. " + String.valueOf(ChatColor.DARK_RED) + "Level" + String.valueOf(ChatColor.BLACK) + " up to use higher " + String.valueOf(ChatColor.DARK_BLUE) + "zones" + String.valueOf(ChatColor.BLACK) + " or just visit/ignore them.\n" + String.valueOf(ChatColor.GRAY) + "Rules and more... >"});
        bookMeta.addPage(new String[]{"When you " + String.valueOf(ChatColor.DARK_PURPLE) + "die" + String.valueOf(ChatColor.BLACK) + ", you get " + String.valueOf(ChatColor.DARK_PURPLE) + "banned" + String.valueOf(ChatColor.BLACK) + " for 24h and lose your " + String.valueOf(ChatColor.DARK_RED) + "levels" + String.valueOf(ChatColor.BLACK) + ".\nType " + String.valueOf(ChatColor.GOLD) + "/help" + String.valueOf(ChatColor.BLACK) + " to read all the commands. You can safely " + String.valueOf(ChatColor.GOLD) + "/trade" + String.valueOf(ChatColor.BLACK) + " with anyone on the server, and you can " + String.valueOf(ChatColor.GOLD) + "/invite" + String.valueOf(ChatColor.BLACK) + " your friends to your location if you and them would be in a " + String.valueOf(ChatColor.DARK_BLUE) + "zone" + String.valueOf(ChatColor.BLACK) + " of your " + String.valueOf(ChatColor.DARK_RED) + "levels" + String.valueOf(ChatColor.BLACK) + ". Type " + String.valueOf(ChatColor.GOLD) + "/pillars" + String.valueOf(ChatColor.BLACK) + " or " + String.valueOf(ChatColor.GOLD) + "/rules" + String.valueOf(ChatColor.BLACK) + " for more."});
        book.setItemMeta((ItemMeta)bookMeta);
        player.openBook(book);
    }

    public static void givePlayerHead(Player player, OfflinePlayer head) {
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)playerHead.getItemMeta();
        meta.setOwningPlayer(head);
        meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.ITALIC) + LocalDate.now(ZoneId.of("GMT")).toString()));
        playerHead.setItemMeta((ItemMeta)meta);
        player.getWorld().dropItem(player.getLocation(), playerHead);
    }

    public static boolean renewPlayerTier(UUID uuid, int action) {
        if (!mainClass.getConfig().contains("players." + uuid.toString())) {
            return false;
        }
        switch (action) {
            case 1: {
                mainClass.getConfig().set("players." + uuid.toString() + ".italic", null);
                mainClass.getConfig().set("players." + uuid.toString() + ".aqua", null);
                mainClass.getConfig().set("players." + uuid.toString() + ".blue", null);
                break;
            }
            case 2: {
                mainClass.getConfig().set("players." + uuid.toString() + ".italic", (Object)((int)(new Date().getTime() / 1000L)));
                break;
            }
            case 3: {
                mainClass.getConfig().set("players." + uuid.toString() + ".aqua", (Object)((int)(new Date().getTime() / 1000L)));
                break;
            }
            case 4: {
                mainClass.getConfig().set("players." + uuid.toString() + ".blue", (Object)((int)(new Date().getTime() / 1000L)));
                break;
            }
            default: {
                return false;
            }
        }
        Player player = Bukkit.getServer().getPlayer(uuid);
        if (player != null) {
            Functions.updatePlayerScore(player);
        }
        return true;
    }

    public static void createBoard(Player player, String title, int size) {
    }

    public static void updateBoard(Player player, String content, int row) {
        String old;
        try {
            old = listBoard.get(player.getUniqueId())[row];
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            return;
        }
        if (old == content) {
            return;
        }
        if (old != null) {
            PacketContainer pkDel = pmBoard.createPacket(PacketType.Play.Server.SCOREBOARD_SCORE);
            pkDel.getStrings().write(0, (Object)old);
            pkDel.getStrings().write(1, (Object)"board");
            pkDel.getScoreboardActions().write(0, (Object)EnumWrappers.ScoreboardAction.REMOVE);
            pmBoard.sendServerPacket(player, pkDel);
        }
        PacketContainer pkAdd = pmBoard.createPacket(PacketType.Play.Server.SCOREBOARD_SCORE);
        pkAdd.getIntegers().write(0, (Object)row);
        pkAdd.getStrings().write(0, (Object)content);
        pkAdd.getStrings().write(1, (Object)"board");
        pkAdd.getScoreboardActions().write(0, (Object)EnumWrappers.ScoreboardAction.CHANGE);
        pmBoard.sendServerPacket(player, pkAdd);
        Functions.listBoard.get((Object)player.getUniqueId())[row] = content;
    }

    public static void removeBoard(UUID uuid) {
        listBoard.remove(uuid);
    }

    public static void initLvlExp() {
        for (int i = 1; i <= 100; ++i) {
            mainClass.getConfig().set("levels." + i, (Object)Functions.calcLvlExp(i));
        }
    }

    public static int calcLvlExp(int lvl) {
        if (lvl <= 1) {
            return 0;
        }
        return 90 * lvl;
    }

    public static int getLvlExp(int lvl) {
        if (lvl <= 0) {
            lvl = 1;
        }
        if (lvl > 100) {
            lvl = 100;
        }
        return mainClass.getConfig().getInt("levels." + lvl);
    }

    public static int getLvlExpTot(int lvl) {
        int tot = 0;
        for (int i = 1; i <= lvl; ++i) {
            tot += Functions.getLvlExp(i);
        }
        return tot;
    }

    public static void initExpBook() {
        ItemStack expBook = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta meta = expBook.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "+EXP");
        expBook.setItemMeta(meta);
        ShapelessRecipe recipe = new ShapelessRecipe(new NamespacedKey((Plugin)mainClass, "lapisexp"), expBook);
        recipe.addIngredient(Material.LAPIS_LAZULI);
        mainClass.getServer().addRecipe((Recipe)recipe);
        recipe = new ShapelessRecipe(new NamespacedKey((Plugin)mainClass, "quartzexp"), expBook);
        recipe.addIngredient(Material.QUARTZ);
        mainClass.getServer().addRecipe((Recipe)recipe);
    }

    public static void redeemExpBook(ShapelessRecipe recipe, CraftingInventory inventory, Player player) {
        Material material = Material.AIR;
        int multiplier = 0;
        switch (recipe.getKey().getKey()) {
            case "lapisexp": {
                material = Material.LAPIS_LAZULI;
                multiplier = 10;
                break;
            }
            case "quartzexp": {
                material = Material.QUARTZ;
                multiplier = 5;
                break;
            }
            default: {
                return;
            }
        }
        int amount = 0;
        for (int i = 1; i <= 9; ++i) {
            if (inventory.getItem(i) == null || inventory.getItem(i).getType() != material) continue;
            amount = inventory.getItem(i).getAmount();
            inventory.getItem(i).setAmount(0);
            inventory.getResult().setAmount(0);
            break;
        }
        if (amount == 0) {
            return;
        }
        Functions.addPlayerExp(player, multiplier * amount);
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 1.5f, 0.599f);
    }

    public static void initZoneRangeTot() {
        int tot = 0;
        for (int i = 1; i <= 49; ++i) {
            mainClass.getConfig().set("zones." + i, (Object)(tot += Functions.calcZoneRange(i)));
        }
    }

    public static int calcZoneRange(int zone) {
        if (zone < 1) {
            return 0;
        }
        if (zone > 49) {
            zone = 49;
        }
        int range = 3000;
        for (int i = 2; i <= zone; ++i) {
            range -= 40;
        }
        return range;
    }

    public static int getZoneRangeTot(int zone) {
        if (zone < 1) {
            zone = 1;
        }
        if (zone > 49) {
            zone = 49;
        }
        return mainClass.getConfig().getInt("zones." + zone);
    }

    public static int getZone(Location location) {
        int divider = 1;
        switch (location.getWorld().getEnvironment()) {
            case NORMAL: {
                divider = 1;
                break;
            }
            case NETHER: {
                divider = 8;
                break;
            }
            case THE_END: 
            case CUSTOM: {
                return 31;
            }
        }
        int distance = (int)Math.floor(Math.sqrt(Math.pow(Math.abs(location.getBlockX()), 2.0) + Math.pow(Math.abs(location.getBlockZ()), 2.0)));
        for (int i = 1; i <= 49; ++i) {
            int zoneRange = Functions.getZoneRangeTot(i) / divider;
            if (distance > zoneRange) continue;
            return i;
        }
        return 50;
    }

    public static void initDrop() {
        if (!mainClass.getConfig().contains("drop")) {
            mainClass.getConfig().set("drop", (Object)false);
        }
        Bukkit.getServer().getScheduler().runTaskTimer((Plugin)mainClass, new Runnable(){

            @Override
            public void run() {
                if (Math.random() < 0.03) {
                    mainClass.getConfig().set("drop", (Object)true);
                }
                if (!mainClass.getConfig().getBoolean("drop") || Bukkit.getOnlinePlayers().size() < 15) {
                    return;
                }
                Bukkit.getServer().getScheduler().runTaskLater((Plugin)mainClass, new Runnable(this){

                    @Override
                    public void run() {
                        mainClass.getConfig().set("drop", (Object)false);
                        Functions.doDrop();
                        Bukkit.getLogger().info("Core drop naturally occurred.");
                    }
                }, 6000L);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    player.playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_PREPARE_MIRROR, 3.0f, 0.5f);
                    player.playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_PREPARE_BLINDNESS, 3.0f, 0.5f);
                    player.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + String.valueOf(ChatColor.ITALIC) + "Something will happen on top of the core in 5 minutes...");
                }
            }
        }, 12000L, 24000L);
    }

    public static void doDrop() {
        World overworld = (World)Bukkit.getServer().getWorlds().get(0);
        for (int x = -127; x <= 127; ++x) {
            for (int z = -127; z <= 127; ++z) {
                for (int y = -63; y <= 319; ++y) {
                    Block b = overworld.getBlockAt(x, y, z);
                    if (b.getType() != Material.COBBLESTONE && b.getType() != Material.LAVA) continue;
                    b.setType(Material.AIR);
                }
            }
        }
        for (Entity entity : overworld.getNearbyEntities(new Location(overworld, 0.5, 128.0, 0.5), 191.0, 128.0, 191.0)) {
            if (!(entity instanceof Wither)) continue;
            Location rip = entity.getLocation();
            rip.setY(-319.0);
            entity.teleport(rip);
            entity.remove();
        }
        int top = overworld.getHighestBlockYAt(0, 0);
        if (top == 318 || top == 319) {
            overworld.getBlockAt(0, 318, 0).setType(Material.AIR);
            overworld.getBlockAt(0, 319, 0).setType(Material.AIR);
            top = overworld.getHighestBlockYAt(0, 0);
        }
        if (overworld.getBlockAt(0, top, 0).getType() != Material.LAPIS_BLOCK) {
            overworld.getBlockAt(0, ++top, 0).setType(Material.LAPIS_BLOCK);
        }
        ++top;
        ItemStack corePotion = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)corePotion.getItemMeta();
        double random = Math.random();
        if (random < 0.3) {
            meta.addCustomEffect(new PotionEffect(PotionEffectType.INSTANT_DAMAGE, 12000, 2), true);
            meta.setLore(Arrays.asList("", String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.ITALIC) + "Core Potion of Attack\u2122"));
        } else if (random < 0.6) {
            meta.addCustomEffect(new PotionEffect(PotionEffectType.RESISTANCE, 12000, 2), true);
            meta.setLore(Arrays.asList("", String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.ITALIC) + "Core Potion of Defense\u2122"));
        } else if (random < 0.9) {
            meta.addCustomEffect(new PotionEffect(PotionEffectType.HASTE, 12000, 2), true);
            meta.setLore(Arrays.asList("", String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.ITALIC) + "Core Potion of Grind\u2122"));
        } else {
            meta.addCustomEffect(new PotionEffect(PotionEffectType.INSTANT_DAMAGE, 12000, 2), true);
            meta.addCustomEffect(new PotionEffect(PotionEffectType.RESISTANCE, 12000, 2), true);
            meta.addCustomEffect(new PotionEffect(PotionEffectType.HASTE, 12000, 2), true);
            meta.setLore(Arrays.asList("", String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.ITALIC) + "Core Potion of GOD\u2122"));
        }
        corePotion.setItemMeta((ItemMeta)meta);
        for (Entity entity : overworld.getNearbyEntities(new Location(overworld, 0.5, (double)top, 0.5), 0.5, 0.5, 0.5)) {
            if (!(entity instanceof ItemFrame)) continue;
            ((ItemFrame)entity).setItem(corePotion);
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_PREPARE_MIRROR, 3.0f, 0.5f);
                player.playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_PREPARE_BLINDNESS, 3.0f, 0.5f);
                player.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + String.valueOf(ChatColor.ITALIC) + "The gods of waters purified the core and left something on it.");
            }
            return;
        }
        Material bodge = overworld.getBlockAt(1, top, 0).getType();
        overworld.getBlockAt(1, top, 0).setType(Material.DIRT);
        ItemFrame frame = (ItemFrame)overworld.spawn(new Location(overworld, 0.0, (double)top, 0.0), ItemFrame.class);
        frame.setFacingDirection(BlockFace.UP);
        frame.setItem(corePotion);
        overworld.getBlockAt(1, top, 0).setType(bodge);
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_PREPARE_MIRROR, 3.0f, 0.5f);
            player.playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_PREPARE_BLINDNESS, 3.0f, 0.5f);
            player.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + String.valueOf(ChatColor.ITALIC) + "The gods of waters purified the core and left something on it.");
        }
    }

    static {
        emptyLocation = new Location(null, 0.0, 0.0, 0.0);
        pmBoard = ProtocolLibrary.getProtocolManager();
        listBoard = new Hashtable();
    }
}

