/*
 * Decompiled with CFR 0.152.
 */
package com.buildkillreign.base;

import com.buildkillreign.base.Functions;
import io.papermc.lib.PaperLib;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SpawnCmd
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        int corner;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be run by a player!");
            return false;
        }
        if (args.length != 1) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Add a corner: ++, --, +- or -+. Usage: /" + label + " (corner)");
            if (Functions.coreRestorePlayer((Player)sender, true) != null) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "To get to your old location instead, use: /" + label + String.valueOf(ChatColor.BOLD) + " no");
            }
            return false;
        }
        switch (args[0]) {
            case "no": 
            case "NO": {
                corner = -1;
                break;
            }
            case "-+": {
                corner = 0;
                break;
            }
            case "+-": {
                corner = 1;
                break;
            }
            case "--": {
                corner = 2;
                break;
            }
            case "++": {
                corner = 3;
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid corner! Do just the command for info.");
                return false;
            }
        }
        return SpawnCmd.spawnCorner((Player)sender, corner);
    }

    public static boolean spawnCorner(Player player, int corner) {
        if (Functions.getPlayerExp(player) >= 0 && Functions.coreRestorePlayer(player, true) == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You already spawned!");
            return false;
        }
        if (corner < 0) {
            Location respawn = Functions.coreRestorePlayer(player, false);
            if (respawn == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You aren't spawning for the first time as an old player!");
                return false;
            }
            PaperLib.teleportAsync((Entity)player, respawn);
            player.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "You spawned at your old location.");
            return true;
        }
        if (Functions.coreRestorePlayer(player, false) == null) {
            Functions.resetPlayerExp(player, true);
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.WOODEN_PICKAXE, 1)});
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.OAK_BOAT, 1)});
            player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 300, 4));
            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 1800, 0));
        }
        Location respawn = Functions.respawnPlayer(player, corner);
        PaperLib.teleportAsync((Entity)player, respawn);
        return true;
    }
}

