/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.concurrent;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.concurrent.SortedCopyOnWriteSet;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PacketTypeMultiMap<T> {
    private final Map<PacketType, SortedCopyOnWriteSet<T, PriorityHolder>> typeMap = new HashMap<PacketType, SortedCopyOnWriteSet<T, PriorityHolder>>();

    public synchronized void put(ListeningWhitelist key, T value) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(value, "value cannot be null");
        for (PacketType packetType : key.getTypes()) {
            this.typeMap.computeIfAbsent(packetType, type -> new SortedCopyOnWriteSet()).add(value, new PriorityHolder(key));
        }
    }

    public synchronized List<PacketType> remove(ListeningWhitelist key, T value) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(value, "value cannot be null");
        ArrayList<PacketType> removedTypes = new ArrayList<PacketType>();
        for (PacketType packetType : key.getTypes()) {
            SortedCopyOnWriteSet<T, PriorityHolder> entrySet = this.typeMap.get(packetType);
            if (entrySet == null) continue;
            assert (!entrySet.isEmpty());
            if (!entrySet.remove(value) || !entrySet.isEmpty()) continue;
            this.typeMap.remove(packetType);
            removedTypes.add(packetType);
        }
        return removedTypes;
    }

    public ImmutableSet<PacketType> getPacketTypes() {
        return ImmutableSet.copyOf(this.typeMap.keySet());
    }

    public boolean contains(PacketType packetType) {
        return this.typeMap.containsKey(packetType);
    }

    public Iterable<T> get(PacketType packetType) {
        return () -> {
            SortedCopyOnWriteSet<T, PriorityHolder> entrySet = this.typeMap.get(packetType);
            if (entrySet != null) {
                return entrySet.iterator();
            }
            return Collections.emptyIterator();
        };
    }

    public Iterable<T> values() {
        return Iterables.concat(this.typeMap.values());
    }

    public synchronized void clear() {
        this.typeMap.clear();
    }

    private static class PriorityHolder
    implements Comparable<PriorityHolder> {
        private final ListenerPriority priority;

        public PriorityHolder(ListeningWhitelist key) {
            this.priority = key.getPriority();
        }

        @Override
        public int compareTo(PriorityHolder other) {
            return Integer.compare(this.priority.getSlot(), other.priority.getSlot());
        }
    }
}

