/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.google.common.base.Preconditions;

public abstract class AbstractWrapper {
    protected Object handle;
    protected Class<?> handleType;

    public AbstractWrapper(Class<?> handleType) {
        this.handleType = (Class)Preconditions.checkNotNull(handleType, (Object)"handleType cannot be NULL");
    }

    protected void setHandle(Object handle) {
        if (handle == null) {
            throw new IllegalArgumentException("handle cannot be NULL.");
        }
        if (!this.handleType.isAssignableFrom(handle.getClass())) {
            throw new IllegalArgumentException("handle (" + handle + ") is not a " + this.handleType + ", but " + handle.getClass());
        }
        this.handle = handle;
    }

    public Object getHandle() {
        return this.handle;
    }

    public Class<?> getHandleType() {
        return this.handleType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractWrapper) {
            AbstractWrapper that = (AbstractWrapper)obj;
            return this.handle.equals(that.handle);
        }
        return false;
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "[handle=" + this.handle + "]";
    }
}

