/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.collection;

import com.comphenix.protocol.wrappers.collection.AbstractConverted;
import com.comphenix.protocol.wrappers.collection.ConvertedCollection;
import com.comphenix.protocol.wrappers.collection.ConvertedMap;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class ConvertedMultimap<Key, VInner, VOuter>
extends AbstractConverted<VInner, VOuter>
implements Multimap<Key, VOuter> {
    private final Multimap<Key, VInner> inner;

    public ConvertedMultimap(Multimap<Key, VInner> inner) {
        this.inner = (Multimap)Preconditions.checkNotNull(inner, (Object)"inner map cannot be NULL.");
    }

    protected Collection<VOuter> toOuterCollection(Collection<VInner> inner) {
        return new ConvertedCollection<VInner, VOuter>(inner){

            @Override
            protected VInner toInner(VOuter outer) {
                return ConvertedMultimap.this.toInner(outer);
            }

            @Override
            protected VOuter toOuter(VInner inner) {
                return ConvertedMultimap.this.toOuter(inner);
            }

            public String toString() {
                return "[" + Joiner.on((String)", ").join((Iterable)this) + "]";
            }
        };
    }

    protected Collection<VInner> toInnerCollection(Collection<VOuter> outer) {
        return new ConvertedCollection<VOuter, VInner>(outer){

            @Override
            protected VOuter toInner(VInner outer) {
                return ConvertedMultimap.this.toOuter(outer);
            }

            @Override
            protected VInner toOuter(VOuter inner) {
                return ConvertedMultimap.this.toInner(inner);
            }

            public String toString() {
                return "[" + Joiner.on((String)", ").join((Iterable)this) + "]";
            }
        };
    }

    protected Object toInnerObject(Object outer) {
        return this.toInner(outer);
    }

    public int size() {
        return this.inner.size();
    }

    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    public boolean containsKey(@Nullable Object key) {
        return this.inner.containsKey(key);
    }

    public boolean containsValue(@Nullable Object value) {
        return this.inner.containsValue(this.toInnerObject(value));
    }

    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        return this.inner.containsEntry(key, this.toInnerObject(value));
    }

    public boolean put(@Nullable Key key, @Nullable VOuter value) {
        return this.inner.put(key, this.toInner(value));
    }

    public boolean remove(@Nullable Object key, @Nullable Object value) {
        return this.inner.remove(key, this.toInnerObject(value));
    }

    public boolean putAll(@Nullable Key key, Iterable<? extends VOuter> values) {
        return this.inner.putAll(key, Iterables.transform(values, this.getInnerConverter()));
    }

    public boolean putAll(Multimap<? extends Key, ? extends VOuter> multimap) {
        return this.inner.putAll((Multimap)new ConvertedMultimap<Key, VOuter, VInner>(multimap){

            @Override
            protected VOuter toInner(VInner outer) {
                return ConvertedMultimap.this.toOuter(outer);
            }

            @Override
            protected VInner toOuter(VOuter inner) {
                return ConvertedMultimap.this.toInner(inner);
            }
        });
    }

    public Collection<VOuter> replaceValues(@Nullable Key key, Iterable<? extends VOuter> values) {
        return this.toOuterCollection(this.inner.replaceValues(key, Iterables.transform(values, this.getInnerConverter())));
    }

    public Collection<VOuter> removeAll(@Nullable Object key) {
        return this.toOuterCollection(this.inner.removeAll(key));
    }

    public void clear() {
        this.inner.clear();
    }

    public Collection<VOuter> get(@Nullable Key key) {
        return this.toOuterCollection(this.inner.get(key));
    }

    public Set<Key> keySet() {
        return this.inner.keySet();
    }

    public Multiset<Key> keys() {
        return this.inner.keys();
    }

    public Collection<VOuter> values() {
        return this.toOuterCollection(this.inner.values());
    }

    public Collection<Map.Entry<Key, VOuter>> entries() {
        return ConvertedMap.convertedEntrySet(this.inner.entries(), (key, outer) -> this.toInner(outer), (key, inner) -> this.toOuter(inner));
    }

    public Map<Key, Collection<VOuter>> asMap() {
        return new ConvertedMap<Key, Collection<VInner>, Collection<VOuter>>(this.inner.asMap()){

            @Override
            protected Collection<VInner> toInner(Collection<VOuter> outer) {
                return ConvertedMultimap.this.toInnerCollection(outer);
            }

            @Override
            protected Collection<VOuter> toOuter(Collection<VInner> inner) {
                return ConvertedMultimap.this.toOuterCollection(inner);
            }
        };
    }

    public String toString() {
        Iterator<Map.Entry<Key, VOuter>> i = this.entries().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<Key, VOuter> e = i.next();
            Key key = e.getKey();
            VOuter value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }
}

