/*
 * Decompiled with CFR 0.152.
 */
package com.buildkillreign.base;

import com.buildkillreign.base.Functions;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminCmd
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No command specified!");
            return false;
        }
        switch (args[0]) {
            case "addexp": {
                return AdminCmd.addexp(sender, args);
            }
            case "getexp": {
                return AdminCmd.getexp(sender, args);
            }
            case "resexp": {
                return AdminCmd.resexp(sender, args);
            }
            case "revive": {
                return AdminCmd.revive(sender, args);
            }
            case "tier": {
                return AdminCmd.tier(sender, args);
            }
            case "drop": {
                Functions.doDrop();
                return true;
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid command!");
        return false;
    }

    public static boolean addexp(CommandSender sender, String[] args) {
        if (args.length != 3) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: " + args[0] + " (player) (exp)");
            return false;
        }
        Player player = Bukkit.getPlayerExact((String)args[1]);
        if (player == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
            return false;
        }
        try {
            Functions.addPlayerExp(player, Integer.parseInt(args[2], 10));
        }
        catch (NumberFormatException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid amount of experience!");
            return false;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Experience added!");
        return true;
    }

    public static boolean getexp(CommandSender sender, String[] args) {
        if (args.length != 2) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: " + args[0] + " (player)");
            return false;
        }
        Player player = Bukkit.getPlayerExact((String)args[1]);
        if (player == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
            return false;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + player.getName() + " has " + Functions.getPlayerExp(player) + " EXP.");
        return true;
    }

    public static boolean resexp(CommandSender sender, String[] args) {
        if (args.length != 2) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: " + args[0] + " (player)");
            return false;
        }
        Player player = Bukkit.getPlayerExact((String)args[1]);
        if (player == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
            return false;
        }
        Functions.resetPlayerExp(player, true);
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Experience reset!");
        return true;
    }

    public static boolean revive(CommandSender sender, String[] args) {
        if (args.length != 2) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: " + args[0] + " (uuid)");
            return false;
        }
        try {
            Functions.updatePlayerDeath(UUID.fromString(args[1]), false);
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid uuid!");
            return false;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Revived!");
        return true;
    }

    public static boolean tier(CommandSender sender, String[] args) {
        UUID uuid;
        int action;
        if (args.length != 3) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: " + args[0] + " (clear/italic/aqua/blue) (uuid)");
            return false;
        }
        try {
            action = Integer.parseInt(args[1]);
            uuid = UUID.fromString(args[2]);
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid action number or uuid!");
            return false;
        }
        if (!Functions.renewPlayerTier(uuid, action)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player or action not found!");
            return false;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Done!");
        return true;
    }
}

