/*
 * Decompiled with CFR 0.152.
 */
package com.buildkillreign.base;

import com.buildkillreign.base.Functions;
import io.papermc.lib.PaperLib;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Flying;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wither;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Events
implements Listener {
    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent e) {
        Functions.initPlayer(e.getPlayer());
        int death = Functions.checkPlayerDeath(e.getPlayer().getUniqueId());
        if (death > 3600) {
            e.disallow(PlayerLoginEvent.Result.KICK_OTHER, String.valueOf(ChatColor.RED) + "You are dead!\n\nYou can start back from the ashes in less than " + (int)Math.ceil((float)death / 3600.0f) + " hours.");
        } else if (death > 0) {
            e.disallow(PlayerLoginEvent.Result.KICK_OTHER, String.valueOf(ChatColor.RED) + "You are dead!\n\nYou can start back from the ashes in less than " + (int)Math.ceil((float)death / 60.0f) + " minutes.");
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Functions.createPlayerScore(e.getPlayer());
        Functions.updatePlayerScore(e.getPlayer());
        boolean old = Functions.coreOldPlayer(e.getPlayer());
        if (old) {
            if (e.getPlayer().isDead()) {
                Functions.resetPlayerExp(e.getPlayer(), false);
                return;
            }
            Functions.coreBackupPlayer(e.getPlayer());
        }
        if (old || !e.getPlayer().hasPlayedBefore()) {
            Location respawn = Functions.coreSpawnPlayer(e.getPlayer());
            PaperLib.teleportAsync((Entity)e.getPlayer(), respawn);
        }
        if (old || Functions.coreRestorePlayer(e.getPlayer(), true) != null) {
            old = true;
            e.getPlayer().sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "As an " + String.valueOf(ChatColor.BOLD) + "old player" + String.valueOf(ChatColor.DARK_GREEN) + ", you automatically spawned at the " + String.valueOf(ChatColor.DARK_AQUA) + "core" + String.valueOf(ChatColor.DARK_GREEN) + ". Do " + String.valueOf(ChatColor.GOLD) + "/spawncorner" + String.valueOf(ChatColor.BOLD) + " no" + String.valueOf(ChatColor.DARK_GREEN) + " if you want to spawn at your old location.");
        }
        if (old || Functions.getPlayerExp(e.getPlayer()) < 0 && !e.getPlayer().isDead()) {
            e.getPlayer().sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "Wellcome to the " + String.valueOf(ChatColor.DARK_AQUA) + "core" + String.valueOf(ChatColor.DARK_GREEN) + "! Until you do " + String.valueOf(ChatColor.GOLD) + "/spawncorner" + String.valueOf(ChatColor.DARK_GREEN) + " and officially spawn you are immortal and can't interact. Read " + String.valueOf(ChatColor.GOLD) + "/tutorial" + String.valueOf(ChatColor.DARK_GREEN) + ".");
            e.getPlayer().sendTitle("", String.valueOf(ChatColor.GRAY) + "Read the first message in chat!", 5, 320, 10);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        Functions.removePlayerScore(e.getPlayer());
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent e) {
        if (e.getPlayer().getBedSpawnLocation() != null) {
            return;
        }
        if (e.getRespawnReason() == PlayerRespawnEvent.RespawnReason.END_PORTAL) {
            Location respawn = Functions.getPlayerExp(e.getPlayer()) < 0 || Functions.coreRestorePlayer(e.getPlayer(), true) != null ? Functions.coreSpawnPlayer(e.getPlayer()) : Functions.respawnPlayer(e.getPlayer(), -1);
            e.setRespawnLocation(respawn);
            return;
        }
        e.setRespawnLocation(Functions.coreSpawnPlayer(e.getPlayer()));
        e.getPlayer().sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "Wellcome to the " + String.valueOf(ChatColor.DARK_AQUA) + "core" + String.valueOf(ChatColor.DARK_GREEN) + "! Until you do " + String.valueOf(ChatColor.GOLD) + "/spawncorner" + String.valueOf(ChatColor.DARK_GREEN) + " and officially spawn you are immortal and can't interact. Read " + String.valueOf(ChatColor.GOLD) + "/tutorial" + String.valueOf(ChatColor.DARK_GREEN) + ".");
        e.getPlayer().sendTitle("", String.valueOf(ChatColor.GRAY) + "Read the first message in chat!", 5, 320, 10);
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        if (Functions.getPlayerExp((Player)e.getWhoClicked()) < 0 || Functions.coreRestorePlayer((Player)e.getWhoClicked(), true) != null) {
            e.setCancelled(true);
            return;
        }
        if (e.getRecipe() instanceof ShapelessRecipe) {
            Functions.redeemExpBook((ShapelessRecipe)e.getRecipe(), e.getInventory(), (Player)e.getWhoClicked());
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        Functions.updatePlayerCompass(e.getPlayer());
        double x = Math.floor(e.getTo().getX());
        double z = Math.floor(e.getTo().getZ());
        if (Math.floor(e.getFrom().getX()) != x || Math.floor(e.getFrom().getZ()) != z) {
            Functions.updatePlayerZone(e.getPlayer());
            if (Math.abs(x) < 500.0 && Math.abs(z) < 500.0) {
                return;
            }
            if (Functions.getPlayerExp(e.getPlayer()) < 0) {
                Functions.resetPlayerExp(e.getPlayer(), true);
                e.getPlayer().getInventory().addItem(new ItemStack[]{new ItemStack(Material.WOODEN_PICKAXE, 1)});
                e.getPlayer().getInventory().addItem(new ItemStack[]{new ItemStack(Material.OAK_BOAT, 1)});
                e.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 300, 4));
                e.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 1800, 0));
                Location respawn = Functions.respawnPlayer(e.getPlayer(), -1);
                PaperLib.teleportAsync((Entity)e.getPlayer(), respawn);
                e.getPlayer().sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "You spawned at a random corner as too far from the " + String.valueOf(ChatColor.DARK_AQUA) + "core" + String.valueOf(ChatColor.DARK_GREEN) + ".");
                return;
            }
            Location respawn = Functions.coreRestorePlayer(e.getPlayer(), false);
            if (respawn != null) {
                PaperLib.teleportAsync((Entity)e.getPlayer(), respawn);
                e.getPlayer().sendMessage(String.valueOf(ChatColor.DARK_GREEN) + "You spawned at your old location as too far from the " + String.valueOf(ChatColor.DARK_AQUA) + "core" + String.valueOf(ChatColor.DARK_GREEN) + ".");
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        if (e.getPlayer() == null) {
            return;
        }
        if (Functions.getPlayerExp(e.getPlayer()) < 0 || Functions.coreRestorePlayer(e.getPlayer(), true) != null) {
            e.setCancelled(true);
            return;
        }
        if (!Functions.checkPlayerZone(e.getPlayer(), e.getBlock().getLocation())) {
            e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "Level up to break blocks here! If stuck, do " + String.valueOf(ChatColor.YELLOW) + "/unstuck" + String.valueOf(ChatColor.RED) + ".");
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        if (e.getPlayer() == null) {
            return;
        }
        if (Functions.getPlayerExp(e.getPlayer()) < 0 || Functions.coreRestorePlayer(e.getPlayer(), true) != null) {
            e.setCancelled(true);
            return;
        }
        if (!Functions.checkPlayerZone(e.getPlayer(), e.getBlock().getLocation())) {
            e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "Level up to place blocks here! If stuck, do " + String.valueOf(ChatColor.YELLOW) + "/unstuck" + String.valueOf(ChatColor.RED) + ".");
            e.setCancelled(true);
        }
        if (e.getBlockPlaced().getType() == Material.PLAYER_HEAD || e.getBlockPlaced().getType() == Material.PLAYER_WALL_HEAD) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockIgnite(BlockIgniteEvent e) {
        if (e.getPlayer() == null) {
            return;
        }
        if (Functions.getPlayerExp(e.getPlayer()) < 0 || Functions.coreRestorePlayer(e.getPlayer(), true) != null) {
            e.setCancelled(true);
            return;
        }
        if (!Functions.checkPlayerZone(e.getPlayer(), e.getBlock().getLocation())) {
            e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "Level up to burn blocks here! If stuck, do " + String.valueOf(ChatColor.YELLOW) + "/unstuck" + String.valueOf(ChatColor.RED) + ".");
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent e) {
        if (Functions.getPlayerExp(e.getPlayer()) < 0 || Functions.coreRestorePlayer(e.getPlayer(), true) != null) {
            e.setCancelled(true);
            return;
        }
        if (!Functions.checkPlayerZone(e.getPlayer(), e.getBlockClicked().getLocation())) {
            e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "Level up to place liquids here! If stuck, do " + String.valueOf(ChatColor.YELLOW) + "/unstuck" + String.valueOf(ChatColor.RED) + ".");
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (Functions.getPlayerExp(e.getPlayer()) < 0 || Functions.coreRestorePlayer(e.getPlayer(), true) != null) {
            e.setCancelled(true);
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        switch (e.getClickedBlock().getType()) {
            case END_PORTAL_FRAME: {
                if (!e.hasItem() || e.getItem().getType() != Material.ENDER_EYE || Functions.checkPlayerZone(e.getPlayer(), e.getClickedBlock().getLocation())) break;
                e.setCancelled(true);
                break;
            }
            case BEDROCK: 
            case OBSIDIAN: {
                if (!e.hasItem() || e.getItem().getType() != Material.END_CRYSTAL || Functions.checkPlayerZone(e.getPlayer(), e.getClickedBlock().getLocation())) break;
                e.setCancelled(true);
                break;
            }
            case BEEHIVE: 
            case BARREL: 
            case BLAST_FURNACE: 
            case SMOKER: 
            case COMPOSTER: 
            case DISPENSER: 
            case NOTE_BLOCK: 
            case TNT: 
            case CHEST: 
            case FURNACE: 
            case LEVER: 
            case STONE_BUTTON: 
            case ACACIA_BUTTON: 
            case BIRCH_BUTTON: 
            case DARK_OAK_BUTTON: 
            case JUNGLE_BUTTON: 
            case OAK_BUTTON: 
            case SPRUCE_BUTTON: 
            case JUKEBOX: 
            case BEACON: 
            case HOPPER: 
            case DROPPER: 
            case SHULKER_BOX: 
            case BLACK_SHULKER_BOX: 
            case BLUE_SHULKER_BOX: 
            case BROWN_SHULKER_BOX: 
            case CYAN_SHULKER_BOX: 
            case GRAY_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case LIGHT_GRAY_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case ORANGE_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case RED_SHULKER_BOX: 
            case WHITE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: 
            case REPEATER: 
            case COMPARATOR: 
            case BREWING_STAND: 
            case CAULDRON: 
            case FLOWER_POT: 
            case ARMOR_STAND: 
            case BLACK_BED: 
            case BLUE_BED: 
            case BROWN_BED: 
            case CYAN_BED: 
            case GRAY_BED: 
            case GREEN_BED: 
            case LIGHT_BLUE_BED: 
            case LIGHT_GRAY_BED: 
            case LIME_BED: 
            case MAGENTA_BED: 
            case ORANGE_BED: 
            case PINK_BED: 
            case PURPLE_BED: 
            case RED_BED: 
            case WHITE_BED: 
            case YELLOW_BED: {
                if (Functions.checkPlayerZone(e.getPlayer(), e.getClickedBlock().getLocation())) break;
                e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "Level up to interact to this here! If stuck, do " + String.valueOf(ChatColor.YELLOW) + "/unstuck" + String.valueOf(ChatColor.RED) + ".");
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onHangingPlace(HangingPlaceEvent e) {
        if (e.getPlayer() == null) {
            return;
        }
        if (Functions.getPlayerExp(e.getPlayer()) < 0 || Functions.coreRestorePlayer(e.getPlayer(), true) != null) {
            e.setCancelled(true);
            return;
        }
        if (!Functions.checkPlayerZone(e.getPlayer(), e.getBlock().getLocation())) {
            e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "Level up to hang this here! If stuck, do " + String.valueOf(ChatColor.YELLOW) + "/unstuck" + String.valueOf(ChatColor.RED) + ".");
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onHangingBreak(HangingBreakByEntityEvent e) {
        if (!(e.getRemover() instanceof Player)) {
            return;
        }
        if (Functions.getPlayerExp((Player)e.getRemover()) < 0 || Functions.coreRestorePlayer((Player)e.getRemover(), true) != null) {
            e.setCancelled(true);
            return;
        }
        if (!Functions.checkPlayerZone((Player)e.getRemover(), e.getEntity().getLocation())) {
            e.getRemover().sendMessage(String.valueOf(ChatColor.RED) + "Level up to unhang this from here! If stuck, do " + String.valueOf(ChatColor.YELLOW) + "/unstuck" + String.valueOf(ChatColor.RED) + ".");
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent e) {
        Player damager;
        if (e.getDamager() instanceof Player) {
            damager = (Player)e.getDamager();
        } else if (e.getDamager() instanceof Projectile && ((Projectile)e.getDamager()).getShooter() instanceof Player) {
            damager = (Player)((Projectile)e.getDamager()).getShooter();
        } else {
            return;
        }
        if (Functions.getPlayerExp(damager) < 0 || Functions.coreRestorePlayer(damager, true) != null) {
            e.setCancelled(true);
            return;
        }
        if (e.getEntity() instanceof Monster || e.getEntity() instanceof Flying) {
            if (Functions.checkPlayerZone(damager, damager.getLocation())) {
                return;
            }
            damager.sendMessage(String.valueOf(ChatColor.RED) + "You can't attack or get attacked by hostile mobs here if you don't reach this zone's level! This doesn't affect PvP.");
            e.setCancelled(true);
        } else if (e.getEntity() instanceof ItemFrame) {
            if (Functions.checkPlayerZone(damager, e.getEntity().getLocation())) {
                return;
            }
            damager.sendMessage(String.valueOf(ChatColor.RED) + "Level up to take this here! If stuck, do " + String.valueOf(ChatColor.YELLOW) + "/unstuck" + String.valueOf(ChatColor.RED) + ".");
            e.setCancelled(true);
        } else if (e.getEntity() instanceof Player) {
            if (Functions.getPlayerExp((Player)e.getEntity()) < 0 || Functions.coreRestorePlayer((Player)e.getEntity(), true) != null) {
                Location location = e.getEntity().getLocation();
                location.setX(location.getX() + 4.0);
                location.setY((double)(location.getWorld().getHighestBlockYAt(location) + 1));
                e.getEntity().teleport(location);
                e.getEntity().sendMessage(String.valueOf(ChatColor.YELLOW) + "Getting attacked before you spawn moves you away.");
                damager.sendMessage(String.valueOf(ChatColor.YELLOW) + "Attacking players who didn't spawn yet moves them away.");
                e.setCancelled(true);
                return;
            }
            if (Math.abs(damager.getLocation().getBlockX()) > 127 || Math.abs(damager.getLocation().getBlockZ()) > 127) {
                return;
            }
            boolean removed = false;
            PotionEffect damage = damager.getPotionEffect(PotionEffectType.INSTANT_DAMAGE);
            PotionEffect resistance = damager.getPotionEffect(PotionEffectType.RESISTANCE);
            PotionEffect digging = damager.getPotionEffect(PotionEffectType.HASTE);
            if (damage != null && damage.getAmplifier() == 2) {
                removed = true;
                damager.removePotionEffect(PotionEffectType.INSTANT_DAMAGE);
            }
            if (resistance != null && resistance.getAmplifier() == 2) {
                removed = true;
                damager.removePotionEffect(PotionEffectType.RESISTANCE);
            }
            if (digging != null && digging.getAmplifier() == 2) {
                removed = true;
                damager.removePotionEffect(PotionEffectType.HASTE);
            }
            if (removed) {
                damager.sendMessage(String.valueOf(ChatColor.RED) + "Core Potions' effects removed by gods because too close to the core.");
            }
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player && (Functions.getPlayerExp((Player)e.getEntity()) < 0 || Functions.coreRestorePlayer((Player)e.getEntity(), true) != null)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityTarget(EntityTargetEvent e) {
        if (!(e.getEntity() instanceof Monster) && !(e.getEntity() instanceof Flying) || !(e.getTarget() instanceof Player)) {
            return;
        }
        if (Functions.getPlayerExp((Player)e.getTarget()) < 0 || Functions.coreRestorePlayer((Player)e.getTarget(), true) != null) {
            e.setCancelled(true);
            return;
        }
        if (!Functions.checkPlayerZone((Player)e.getTarget(), e.getTarget().getLocation())) {
            e.setCancelled(true);
            return;
        }
        if (e.getEntity() instanceof Wither && (e.getReason() == EntityTargetEvent.TargetReason.CLOSEST_PLAYER || e.getReason() == EntityTargetEvent.TargetReason.CLOSEST_ENTITY) && e.getEntity().getLocation().distanceSquared(e.getTarget().getLocation()) > 400.0) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent e) {
        if (Functions.getPlayerExp(e.getPlayer()) < 0 || Functions.coreRestorePlayer(e.getPlayer(), true) != null) {
            e.setCancelled(true);
            return;
        }
        if (e.getRightClicked() instanceof Creeper && !Functions.checkPlayerZone(e.getPlayer(), e.getRightClicked().getLocation())) {
            e.setCancelled(true);
            return;
        }
        if (!(e.getRightClicked() instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)e.getRightClicked();
        int n = villager.getRecipeCount();
        for (int i = 0; i < n; ++i) {
            MerchantRecipe recipe = villager.getRecipe(i);
            if (recipe.getResult().getType() != Material.LAPIS_LAZULI) continue;
            MerchantRecipe recipeNew = new MerchantRecipe(new ItemStack(Material.BLUE_DYE, recipe.getResult().getAmount()), recipe.getUses(), recipe.getMaxUses(), recipe.hasExperienceReward());
            recipeNew.setVillagerExperience(recipe.getVillagerExperience());
            recipeNew.setPriceMultiplier(recipe.getPriceMultiplier());
            recipeNew.setIngredients(recipe.getIngredients());
            villager.setRecipe(i, recipeNew);
        }
    }

    @EventHandler
    public void onEntityDropItem(EntityDropItemEvent e) {
        if (!(e.getEntity() instanceof Villager) && !(e.getEntity() instanceof Piglin)) {
            return;
        }
        if (e.getItemDrop().getItemStack().getType() == Material.LAPIS_LAZULI) {
            e.getItemDrop().getItemStack().setType(Material.BLUE_DYE);
        } else if (e.getItemDrop().getItemStack().getType() == Material.QUARTZ) {
            e.getItemDrop().getItemStack().setType(Material.WHITE_DYE);
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent e) {
        if (Functions.getPlayerExp(e.getPlayer()) < 0 || Functions.coreRestorePlayer(e.getPlayer(), true) != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityPickupItem(EntityPickupItemEvent e) {
        if (e.getEntity() instanceof Player && (Functions.getPlayerExp((Player)e.getEntity()) < 0 || Functions.coreRestorePlayer((Player)e.getEntity(), true) != null)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onHungerChange(FoodLevelChangeEvent e) {
        if (e.getEntity() instanceof Player && (Functions.getPlayerExp((Player)e.getEntity()) < 0 || Functions.coreRestorePlayer((Player)e.getEntity(), true) != null)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDeath(final PlayerDeathEvent e) {
        final Player player = e.getEntity();
        if (player.getKiller() != null) {
            int gotExp = Functions.getPlayerExp(player) / 10 * 8;
            Functions.addPlayerExp(player.getKiller(), gotExp);
            Functions.givePlayerHead(player.getKiller(), Bukkit.getOfflinePlayer((UUID)player.getUniqueId()));
            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_LIGHTNING_BOLT_IMPACT, 3.0f, 0.5f);
            player.getKiller().sendMessage(String.valueOf(ChatColor.YELLOW) + "You got " + gotExp + " EXP from killing " + String.valueOf(ChatColor.GRAY) + player.getName() + String.valueOf(ChatColor.YELLOW) + ", and his head.");
        }
        Functions.resetPlayerExp(player, false);
        Functions.updatePlayerDeath(player.getUniqueId(), true);
        player.setDisplayName(null);
        player.setBedSpawnLocation(null);
        player.getInventory().clear();
        Bukkit.getServer().getScheduler().runTaskLater((Plugin)Functions.mainClass, new Runnable(){

            @Override
            public void run() {
                player.kickPlayer(String.valueOf(ChatColor.RED) + "You died! " + e.getDeathMessage() + ".\n\nYou can start back from the ashes in 24 hours.");
            }
        }, 2L);
    }
}

