/*
 * Decompiled with CFR 0.152.
 */
package com.buildkillreign.base;

import com.buildkillreign.base.Functions;
import io.papermc.lib.PaperLib;
import java.util.Date;
import java.util.Hashtable;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class InviteCmd
implements CommandExecutor {
    public static Hashtable<UUID, UUID> invites = new Hashtable();
    public static Hashtable<UUID, Long> expirations = new Hashtable();

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be run by a player!");
            return false;
        }
        if (args.length != 1) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /" + label + " (player/accept/deny)");
            return false;
        }
        if (args[0].toLowerCase().equals("accept")) {
            return InviteCmd.accept((Player)sender);
        }
        if (args[0].toLowerCase().equals("deny")) {
            return InviteCmd.deny((Player)sender);
        }
        Player player = Bukkit.getPlayerExact((String)args[0]);
        if (player == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
            return false;
        }
        return InviteCmd.invite((Player)sender, player);
    }

    public static boolean accept(Player receiver) {
        UUID uuid = receiver.getUniqueId();
        if (expirations.get(uuid) == null || expirations.get(uuid) < new Date().getTime()) {
            receiver.sendMessage(String.valueOf(ChatColor.RED) + "Pending invite not found or expired!");
            return false;
        }
        Player sender = Bukkit.getPlayer((UUID)invites.get(uuid));
        invites.remove(uuid);
        expirations.remove(uuid);
        if (sender == null) {
            receiver.sendMessage(String.valueOf(ChatColor.RED) + "Player disconnected!");
            return false;
        }
        Location location = sender.getLocation();
        if (!Functions.checkPlayerZone(receiver, location)) {
            receiver.sendMessage(String.valueOf(ChatColor.RED) + "You can't accept an invite in a zone higher than your level!");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Invite could't be accepted as your zone is too high.");
            return false;
        }
        PaperLib.teleportAsync((Entity)receiver, location);
        receiver.sendMessage(String.valueOf(ChatColor.YELLOW) + "Teleported to " + String.valueOf(ChatColor.GRAY) + sender.getName() + String.valueOf(ChatColor.YELLOW) + ".");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + receiver.getName() + String.valueOf(ChatColor.YELLOW) + " teleported to you.");
        return true;
    }

    public static boolean deny(Player receiver) {
        UUID uuid = receiver.getUniqueId();
        if (expirations.get(uuid) == null || expirations.get(uuid) < new Date().getTime()) {
            receiver.sendMessage(String.valueOf(ChatColor.RED) + "Pending invite not found or expired!");
            return false;
        }
        invites.remove(uuid);
        expirations.remove(uuid);
        receiver.sendMessage(String.valueOf(ChatColor.YELLOW) + "Invite denied.");
        return true;
    }

    public static boolean invite(Player sender, Player receiver) {
        if (Functions.getPlayerExp(sender) < 0 || Functions.coreRestorePlayer(sender, true) != null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You can't use this command before you spawn!");
            return false;
        }
        if (Functions.getPlayerExp(receiver) < 0 || Functions.coreRestorePlayer(receiver, true) != null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You can't invite players who didn't spawn yet!");
            return false;
        }
        if (!Functions.checkPlayerZone(sender, sender.getLocation())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You can't use this command in a zone higher than your level!");
            return false;
        }
        if (!Functions.checkPlayerZone(receiver, sender.getLocation())) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You can't invite a player in a zone higher than his level!");
            return false;
        }
        if (sender.getUniqueId() == receiver.getUniqueId()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player is yourself!");
            return false;
        }
        if (expirations.get(receiver.getUniqueId()) != null && expirations.get(receiver.getUniqueId()) >= new Date().getTime()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player already has a pending invite!");
            return false;
        }
        invites.put(receiver.getUniqueId(), sender.getUniqueId());
        expirations.put(receiver.getUniqueId(), new Date().getTime() + 30000L);
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Invited " + String.valueOf(ChatColor.GRAY) + receiver.getName() + String.valueOf(ChatColor.YELLOW) + " to " + String.valueOf(ChatColor.BOLD) + "teleport" + String.valueOf(ChatColor.YELLOW) + " to you.");
        receiver.sendMessage(String.valueOf(ChatColor.GRAY) + sender.getName() + String.valueOf(ChatColor.YELLOW) + " invited you to " + String.valueOf(ChatColor.BOLD) + "teleport" + String.valueOf(ChatColor.YELLOW) + " to him.\nUse /invite " + String.valueOf(ChatColor.GREEN) + "accept" + String.valueOf(ChatColor.YELLOW) + " or " + String.valueOf(ChatColor.RED) + "deny" + String.valueOf(ChatColor.YELLOW) + " to respond.");
        return true;
    }
}

