/*
 * Decompiled with CFR 0.152.
 */
package com.buildkillreign.base;

import com.buildkillreign.base.Functions;
import io.papermc.lib.PaperLib;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class UnstuckCmd
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be run by a player!");
            return false;
        }
        return UnstuckCmd.unstuck((Player)sender);
    }

    public static boolean unstuck(Player player) {
        if (Functions.checkPlayerZone(player, player.getLocation()) && Functions.coreRestorePlayer(player, true) == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You can use this command in a zone higher than your level!");
            return false;
        }
        switch (player.getLocation().getWorld().getEnvironment()) {
            case NORMAL: {
                break;
            }
            case NETHER: 
            case THE_END: 
            case CUSTOM: {
                if (player.getBedSpawnLocation() != null) {
                    PaperLib.teleportAsync((Entity)player, player.getBedSpawnLocation());
                    return true;
                }
                Location respawn = Functions.getPlayerExp(player) < 0 || Functions.coreRestorePlayer(player, true) != null ? Functions.coreSpawnPlayer(player) : Functions.respawnPlayer(player, -1);
                PaperLib.teleportAsync((Entity)player, respawn);
                return true;
            }
        }
        int playerX = player.getLocation().getBlockX();
        int playerY = player.getLocation().getBlockY();
        int playerZ = player.getLocation().getBlockZ();
        int highestX = playerX;
        int highestY = playerY;
        int highestZ = playerZ;
        int lowestX = playerX;
        int lowestY = playerY;
        int lowestZ = playerZ;
        for (int i = playerX - 3; i <= playerX + 3; ++i) {
            for (int j = playerZ - 3; j <= playerZ + 3; ++j) {
                int tempY = player.getLocation().getWorld().getHighestBlockYAt(i, j) + 1;
                if (player.getLocation().getWorld().getBlockAt(i, tempY - 1, j).isLiquid() || player.getLocation().getWorld().getBlockAt(i, tempY, j).getType() == Material.FIRE) continue;
                if (tempY > highestY) {
                    highestX = i;
                    highestY = tempY;
                    highestZ = j;
                }
                if (tempY >= lowestY) continue;
                lowestX = i;
                lowestY = tempY;
                lowestZ = j;
            }
        }
        if (playerY - lowestY > highestY - playerY && playerY - lowestY >= 2) {
            PaperLib.teleportAsync((Entity)player, new Location(player.getLocation().getWorld(), (double)lowestX, (double)lowestY, (double)lowestZ));
        } else if (highestY - playerY >= 2) {
            PaperLib.teleportAsync((Entity)player, new Location(player.getLocation().getWorld(), (double)highestX, (double)highestY, (double)highestZ));
        }
        if (Functions.getPlayerExp(player) < 0 || Functions.coreRestorePlayer(player, true) != null) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Remember to do /spawncorner to start playing. Read /tutorial.");
        } else {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Walk the opposite direction to build again (away from the core).");
        }
        return true;
    }
}

