/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.misc.HolderType;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntFunction;
import com.viaversion.viaversion.libs.fastutil.objects.Object2ObjectArrayMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;

public record ArmorTrimMaterial(String assetName, int itemId, float itemModelIndex, Map<String, String> overrideArmorMaterials, Tag description) {
    public static final HolderType<ArmorTrimMaterial> TYPE1_20_5 = new HolderType<ArmorTrimMaterial>(){

        @Override
        public ArmorTrimMaterial readDirect(ByteBuf buffer) {
            String assetName = (String)Types.STRING.read(buffer);
            int item = Types.VAR_INT.readPrimitive(buffer);
            float itemModelIndex = buffer.readFloat();
            int overrideArmorMaterialsSize = Types.VAR_INT.readPrimitive(buffer);
            Object2ObjectArrayMap<String, String> overrideArmorMaterials = new Object2ObjectArrayMap<String, String>(overrideArmorMaterialsSize);
            for (int i = 0; i < overrideArmorMaterialsSize; ++i) {
                int key = Types.VAR_INT.readPrimitive(buffer);
                String value = (String)Types.STRING.read(buffer);
                overrideArmorMaterials.put(Integer.toString(key), value);
            }
            Tag description = (Tag)Types.TAG.read(buffer);
            return new ArmorTrimMaterial(assetName, item, itemModelIndex, overrideArmorMaterials, description);
        }

        @Override
        public void writeDirect(ByteBuf buffer, ArmorTrimMaterial value) {
            Types.STRING.write(buffer, value.assetName());
            Types.VAR_INT.writePrimitive(buffer, value.itemId());
            buffer.writeFloat(value.itemModelIndex());
            Types.VAR_INT.writePrimitive(buffer, value.overrideArmorMaterials().size());
            for (Map.Entry<String, String> entry : value.overrideArmorMaterials().entrySet()) {
                Types.VAR_INT.writePrimitive(buffer, Integer.parseInt(entry.getKey()));
                Types.STRING.write(buffer, entry.getValue());
            }
            Types.TAG.write(buffer, value.description());
        }
    };
    public static final HolderType<ArmorTrimMaterial> TYPE1_21_2 = new HolderType<ArmorTrimMaterial>(){

        @Override
        public ArmorTrimMaterial readDirect(ByteBuf buffer) {
            String assetName = (String)Types.STRING.read(buffer);
            int item = Types.VAR_INT.readPrimitive(buffer);
            float itemModelIndex = buffer.readFloat();
            int overrideArmorMaterialsSize = Types.VAR_INT.readPrimitive(buffer);
            Object2ObjectArrayMap<String, String> overrideArmorMaterials = new Object2ObjectArrayMap<String, String>(overrideArmorMaterialsSize);
            for (int i = 0; i < overrideArmorMaterialsSize; ++i) {
                String key = (String)Types.STRING.read(buffer);
                String value = (String)Types.STRING.read(buffer);
                overrideArmorMaterials.put(key, value);
            }
            Tag description = (Tag)Types.TAG.read(buffer);
            return new ArmorTrimMaterial(assetName, item, itemModelIndex, overrideArmorMaterials, description);
        }

        @Override
        public void writeDirect(ByteBuf buffer, ArmorTrimMaterial value) {
            Types.STRING.write(buffer, value.assetName());
            Types.VAR_INT.writePrimitive(buffer, value.itemId());
            buffer.writeFloat(value.itemModelIndex());
            Types.VAR_INT.writePrimitive(buffer, value.overrideArmorMaterials().size());
            for (Map.Entry<String, String> entry : value.overrideArmorMaterials().entrySet()) {
                Types.STRING.write(buffer, entry.getKey());
                Types.STRING.write(buffer, entry.getValue());
            }
            Types.TAG.write(buffer, value.description());
        }
    };
    public static final HolderType<ArmorTrimMaterial> TYPE1_21_4 = new HolderType<ArmorTrimMaterial>(){

        @Override
        public ArmorTrimMaterial readDirect(ByteBuf buffer) {
            String assetName = (String)Types.STRING.read(buffer);
            int item = Types.VAR_INT.readPrimitive(buffer);
            int overrideArmorMaterialsSize = Types.VAR_INT.readPrimitive(buffer);
            Object2ObjectArrayMap<String, String> overrideArmorMaterials = new Object2ObjectArrayMap<String, String>(overrideArmorMaterialsSize);
            for (int i = 0; i < overrideArmorMaterialsSize; ++i) {
                String key = (String)Types.STRING.read(buffer);
                String value = (String)Types.STRING.read(buffer);
                overrideArmorMaterials.put(key, value);
            }
            Tag description = (Tag)Types.TAG.read(buffer);
            return new ArmorTrimMaterial(assetName, item, overrideArmorMaterials, description);
        }

        @Override
        public void writeDirect(ByteBuf buffer, ArmorTrimMaterial value) {
            Types.STRING.write(buffer, value.assetName());
            Types.VAR_INT.writePrimitive(buffer, value.itemId());
            Types.VAR_INT.writePrimitive(buffer, value.overrideArmorMaterials().size());
            for (Map.Entry<String, String> entry : value.overrideArmorMaterials().entrySet()) {
                Types.STRING.write(buffer, entry.getKey());
                Types.STRING.write(buffer, entry.getValue());
            }
            Types.TAG.write(buffer, value.description());
        }
    };

    public ArmorTrimMaterial(String assetName, int itemId, Map<String, String> overrideArmorMaterials, Tag description) {
        this(assetName, itemId, 0.0f, overrideArmorMaterials, description);
    }

    public ArmorTrimMaterial rewrite(Int2IntFunction idRewriteFunction) {
        return new ArmorTrimMaterial(this.assetName, idRewriteFunction.applyAsInt(this.itemId), this.itemModelIndex, this.overrideArmorMaterials, this.description);
    }
}

