/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.minecraft.Holder;
import com.viaversion.viaversion.api.minecraft.SoundEvent;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.misc.HolderType;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntFunction;
import com.viaversion.viaversion.util.Either;
import io.netty.buffer.ByteBuf;

public record JukeboxPlayable(Either<Holder<JukeboxSong>, String> song, boolean showInTooltip) {
    public static final Type<JukeboxPlayable> TYPE = new Type<JukeboxPlayable>(JukeboxPlayable.class){

        @Override
        public JukeboxPlayable read(ByteBuf buffer) {
            Either<JukeboxSong, String> position = Type.readEither(buffer, JukeboxSong.TYPE, Types.STRING);
            boolean showInTooltip = buffer.readBoolean();
            return new JukeboxPlayable(position, showInTooltip);
        }

        @Override
        public void write(ByteBuf buffer, JukeboxPlayable value) {
            Type.writeEither(buffer, value.song, JukeboxSong.TYPE, Types.STRING);
            buffer.writeBoolean(value.showInTooltip);
        }
    };

    public JukeboxPlayable(Holder<JukeboxSong> song, boolean showInTooltip) {
        this(Either.left(song), showInTooltip);
    }

    public JukeboxPlayable(String resourceKey, boolean showInTooltip) {
        this(Either.right(resourceKey), showInTooltip);
    }

    public JukeboxPlayable rewrite(Int2IntFunction soundIdRewriteFunction) {
        if (this.song.isRight()) {
            return this;
        }
        Holder<JukeboxSong> songHolder = this.song.left();
        if (songHolder.hasId()) {
            return this;
        }
        JukeboxSong rewrittenSong = songHolder.value().rewrite(soundIdRewriteFunction);
        return rewrittenSong == songHolder.value() ? this : new JukeboxPlayable(Holder.of(rewrittenSong), this.showInTooltip);
    }

    public record JukeboxSong(Holder<SoundEvent> soundEvent, Tag description, float lengthInSeconds, int comparatorOutput) {
        public static final HolderType<JukeboxSong> TYPE = new HolderType<JukeboxSong>(){

            @Override
            public JukeboxSong readDirect(ByteBuf buffer) {
                Object soundEvent = Types.SOUND_EVENT.read(buffer);
                Tag description = (Tag)Types.TAG.read(buffer);
                float lengthInSeconds = buffer.readFloat();
                int useDuration = Types.VAR_INT.readPrimitive(buffer);
                return new JukeboxSong((Holder<SoundEvent>)soundEvent, description, lengthInSeconds, useDuration);
            }

            @Override
            public void writeDirect(ByteBuf buffer, JukeboxSong value) {
                Types.SOUND_EVENT.write(buffer, value.soundEvent);
                Types.TAG.write(buffer, value.description);
                buffer.writeFloat(value.lengthInSeconds);
                Types.VAR_INT.writePrimitive(buffer, value.comparatorOutput);
            }
        };

        public JukeboxSong rewrite(Int2IntFunction soundIdRewriteFunction) {
            Holder<SoundEvent> soundEvent = this.soundEvent.updateId(soundIdRewriteFunction);
            return soundEvent == this.soundEvent ? this : new JukeboxSong(soundEvent, this.description, this.lengthInSeconds, this.comparatorOutput);
        }
    }
}

