/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.bukkit.providers;

import com.viaversion.viaversion.ViaVersionPlugin;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.bukkit.platform.PaperViaInjector;
import com.viaversion.viaversion.protocols.v1_21_2to1_21_4.provider.PickItemProvider;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BukkitPickItemProvider
extends PickItemProvider {
    private static final boolean HAS_PLACEMENT_MATERIAL_METHOD = PaperViaInjector.hasMethod("org.bukkit.block.data.BlockData", "getPlacementMaterial");
    private static final boolean HAS_SPAWN_EGG_METHOD = PaperViaInjector.hasMethod(ItemFactory.class, "getSpawnEgg", EntityType.class);
    private static final double BLOCK_RANGE = 5.5;
    private static final double BLOCK_RANGE_SQUARED = 30.25;
    private static final double ENTITY_RANGE = 6.0;
    private final ViaVersionPlugin plugin;

    public BukkitPickItemProvider(ViaVersionPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void pickItemFromBlock(UserConnection connection, BlockPosition blockPosition, boolean includeData) {
        UUID uuid = connection.getProtocolInfo().getUuid();
        Player player = this.plugin.getServer().getPlayer(uuid);
        if (player == null) {
            return;
        }
        this.plugin.runSyncFor(() -> {
            Location playerLocation = player.getLocation();
            if (blockPosition.distanceFromCenterSquared(playerLocation.getX(), playerLocation.getY(), playerLocation.getZ()) > 30.25) {
                return;
            }
            Block block = player.getWorld().getBlockAt(blockPosition.x(), blockPosition.y(), blockPosition.z());
            if (block.getType() == Material.AIR) {
                return;
            }
            ItemStack item = this.blockToItem(block, includeData && player.getGameMode() == GameMode.CREATIVE);
            if (item != null) {
                this.pickItem(player, item);
            }
        }, player);
    }

    private @Nullable ItemStack blockToItem(Block block, boolean includeData) {
        if (HAS_PLACEMENT_MATERIAL_METHOD) {
            ItemMeta itemMeta;
            ItemStack item = new ItemStack(block.getBlockData().getPlacementMaterial(), 1);
            if (includeData && (itemMeta = item.getItemMeta()) instanceof BlockStateMeta) {
                BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
                blockStateMeta.setBlockState(block.getState());
                item.setItemMeta((ItemMeta)blockStateMeta);
            }
            return item;
        }
        if (block.getType().isItem()) {
            return new ItemStack(block.getType(), 1);
        }
        return null;
    }

    @Override
    public void pickItemFromEntity(UserConnection connection, int entityId, boolean includeData) {
        if (!HAS_SPAWN_EGG_METHOD) {
            return;
        }
        UUID uuid = connection.getProtocolInfo().getUuid();
        Player player = this.plugin.getServer().getPlayer(uuid);
        if (player == null) {
            return;
        }
        this.plugin.runSyncFor(() -> {
            Entity entity = player.getWorld().getNearbyEntities(player.getLocation(), 6.0, 6.0, 6.0).stream().filter(e -> e.getEntityId() == entityId).findAny().orElse(null);
            if (entity == null) {
                return;
            }
            Material spawnEggType = Bukkit.getItemFactory().getSpawnEgg(entity.getType());
            if (spawnEggType != null) {
                this.pickItem(player, new ItemStack(spawnEggType, 1));
            }
        }, player);
    }

    private void pickItem(Player player, ItemStack item) {
        PlayerInventory inventory = player.getInventory();
        ItemStack[] contents = inventory.getStorageContents();
        int sourceSlot = -1;
        for (int i = 0; i < contents.length; ++i) {
            ItemStack content = contents[i];
            if (content == null || !content.isSimilar(item)) continue;
            sourceSlot = i;
            break;
        }
        if (sourceSlot != -1) {
            this.moveToHotbar(inventory, sourceSlot, contents);
        } else if (player.getGameMode() == GameMode.CREATIVE) {
            this.spawnItem(item, inventory, contents);
        }
    }

    private void spawnItem(ItemStack item, PlayerInventory inventory, ItemStack[] contents) {
        int targetSlot = this.findEmptyHotbarSlot(inventory, inventory.getHeldItemSlot());
        inventory.setHeldItemSlot(targetSlot);
        ItemStack heldItem = inventory.getItem(targetSlot);
        int emptySlot = targetSlot;
        if (heldItem != null && heldItem.getType() != Material.AIR) {
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i] != null && contents[i].getType() != Material.AIR) continue;
                emptySlot = i;
                break;
            }
        }
        inventory.setItem(emptySlot, heldItem);
        inventory.setItemInMainHand(item);
    }

    private void moveToHotbar(PlayerInventory inventory, int sourceSlot, ItemStack[] contents) {
        if (sourceSlot < 9) {
            inventory.setHeldItemSlot(sourceSlot);
            return;
        }
        int heldSlot = inventory.getHeldItemSlot();
        int targetSlot = this.findEmptyHotbarSlot(inventory, heldSlot);
        inventory.setHeldItemSlot(targetSlot);
        ItemStack heldItem = inventory.getItem(targetSlot);
        inventory.setItemInMainHand(contents[sourceSlot]);
        inventory.setItem(sourceSlot, heldItem);
    }

    private int findEmptyHotbarSlot(PlayerInventory inventory, int heldSlot) {
        for (int i = 0; i < 9; ++i) {
            ItemStack item = inventory.getItem(i);
            if (item != null && item.getType() != Material.AIR) continue;
            return i;
        }
        return heldSlot;
    }
}

