/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.text;

import com.viaversion.viaversion.libs.mcstructs.core.ICopyable;
import com.viaversion.viaversion.libs.mcstructs.core.TextFormatting;
import com.viaversion.viaversion.libs.mcstructs.text.Style;
import com.viaversion.viaversion.libs.mcstructs.text.components.StringComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public abstract class ATextComponent
implements ICopyable<ATextComponent> {
    private final List<ATextComponent> siblings = new ArrayList<ATextComponent>();
    private Style style = new Style();
    private int level = 1;

    private void setLevel(int level) {
        this.level = Math.max(this.level, level);
        if (this.level > 512) {
            throw new IllegalArgumentException("Too deep");
        }
    }

    public ATextComponent append(String s) {
        this.append((ATextComponent)new StringComponent(s));
        return this;
    }

    public ATextComponent append(ATextComponent component) {
        this.siblings.add(component);
        component.setLevel(this.level + 1);
        return this;
    }

    public ATextComponent append(ATextComponent ... components) {
        this.siblings.addAll(Arrays.asList(components));
        for (ATextComponent component : components) {
            component.setLevel(this.level + 1);
        }
        return this;
    }

    public List<ATextComponent> getSiblings() {
        return this.siblings;
    }

    public ATextComponent forEach(Consumer<ATextComponent> consumer) {
        consumer.accept(this);
        for (ATextComponent sibling : this.siblings) {
            sibling.forEach(consumer);
        }
        return this;
    }

    @Nonnull
    public Style getStyle() {
        return this.style;
    }

    public ATextComponent setStyle(@Nonnull Style style) {
        this.style = style;
        return this;
    }

    public ATextComponent modifyStyle(Consumer<Style> styleConsumer) {
        styleConsumer.accept(this.style);
        return this;
    }

    public ATextComponent setParentStyle(@Nonnull Style style) {
        this.style.setParent(style);
        return this;
    }

    public ATextComponent copyParentStyle() {
        for (ATextComponent sibling : this.siblings) {
            sibling.getStyle().setParent(this.style);
            sibling.copyParentStyle();
        }
        return this;
    }

    public ATextComponent applyParentStyle() {
        for (ATextComponent sibling : this.siblings) {
            sibling.getStyle().setParent(this.style);
            sibling.getStyle().applyParent();
            sibling.applyParentStyle();
        }
        return this;
    }

    public <C extends ATextComponent> C putMetaCopy(C component) {
        component.setStyle(this.style.copy());
        for (ATextComponent sibling : this.siblings) {
            component.append(sibling.copy());
        }
        return component;
    }

    public String asUnformattedString() {
        StringBuilder out = new StringBuilder(this.asSingleString());
        for (ATextComponent sibling : this.siblings) {
            out.append(sibling.asUnformattedString());
        }
        return out.toString();
    }

    public void visit(Consumer<String> consumer) {
        if (this.style.getColor() != null && this.style.getColor().isFormattingColor()) {
            consumer.accept(Character.toString('\u00a7') + this.style.getColor().getCode());
        } else {
            consumer.accept("\u00a7r");
        }
        if (this.style.isObfuscated()) {
            consumer.accept(Character.toString('\u00a7') + TextFormatting.OBFUSCATED.getCode());
        }
        if (this.style.isBold()) {
            consumer.accept(Character.toString('\u00a7') + TextFormatting.BOLD.getCode());
        }
        if (this.style.isStrikethrough()) {
            consumer.accept(Character.toString('\u00a7') + TextFormatting.STRIKETHROUGH.getCode());
        }
        if (this.style.isUnderlined()) {
            consumer.accept(Character.toString('\u00a7') + TextFormatting.UNDERLINE.getCode());
        }
        if (this.style.isItalic()) {
            consumer.accept(Character.toString('\u00a7') + TextFormatting.ITALIC.getCode());
        }
        consumer.accept(this.asSingleString());
        for (ATextComponent sibling : this.siblings) {
            ATextComponent copy = sibling.copy();
            copy.getStyle().setParent(this.style);
            copy.visit(consumer);
        }
    }

    public final String asLegacyFormatString() {
        StringBuilder out = new StringBuilder();
        this.visit(out::append);
        return out.toString();
    }

    public abstract String asSingleString();

    @Override
    public abstract ATextComponent copy();

    public ATextComponent shallowCopy() {
        ATextComponent copy = this.copy();
        copy.getSiblings().clear();
        return copy;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();
}

